/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser.xml;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.metadata.Label;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.util.xml.XmlUtil;
import org.joox.JOOX;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NamespaceElementHandler(elementName="label", namespace="http://windup.jboss.org/schema/jboss-labelset")
public class LabelHandler
implements ElementHandler<Label> {
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String SUPPORTED = "supported";
    public static final String UNSUITABLE = "unsuitable";
    public static final String NEUTRAL = "neutral";

    @Override
    public Label processElement(ParserContext context, Element element) {
        String id = JOOX.$((Element)element).attr("id");
        String name = null;
        String description = null;
        HashSet supported = new HashSet();
        HashSet unsuitable = new HashSet();
        HashSet neutral = new HashSet();
        List children = JOOX.$((Element)element).children().get();
        for (Element child : children) {
            if (StringUtils.equals((CharSequence)NAME, (CharSequence)child.getTagName())) {
                name = JOOX.$((Element)child).text();
                continue;
            }
            if (StringUtils.equals((CharSequence)DESCRIPTION, (CharSequence)child.getTagName())) {
                description = JOOX.$((Element)child).text();
                continue;
            }
            if (StringUtils.equals((CharSequence)SUPPORTED, (CharSequence)child.getTagName())) {
                JOOX.$((Element)child).children().get().forEach(tagElements -> supported.add((String)context.processElement((Element)tagElements)));
                continue;
            }
            if (StringUtils.equals((CharSequence)UNSUITABLE, (CharSequence)child.getTagName())) {
                JOOX.$((Element)child).children().get().forEach(tagElements -> unsuitable.add((String)context.processElement((Element)tagElements)));
                continue;
            }
            if (!StringUtils.equals((CharSequence)NEUTRAL, (CharSequence)child.getTagName())) continue;
            JOOX.$((Element)child).children().get().forEach(tagElements -> neutral.add((String)context.processElement((Element)tagElements)));
        }
        Label label = new Label(id, name, description, XmlUtil.nodeToString((Node)element));
        label.addSupportedTags(supported);
        label.addUnsuitableTags(unsuitable);
        label.addNeutralTags(neutral);
        return label;
    }
}

