/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.LabelProvider;
import org.jboss.windup.config.loader.LabelProviderLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.LabelMetadataBuilder;
import org.jboss.windup.config.metadata.LabelProviderMetadata;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.furnace.FileExtensionFilter;
import org.jboss.windup.util.furnace.FurnaceClasspathScanner;
import org.w3c.dom.Document;

public class XMLLabelProviderLoader
implements LabelProviderLoader {
    private static final Logger LOG = Logging.get(XMLLabelProviderLoader.class);
    private static final String XML_LABELS_WINDUP_EXTENSION = "windup.label.xml";
    private static final String XML_LABELS_RHAMT_EXTENSION = "rhamt.label.xml";
    private static final String XML_LABELS_MTA_EXTENSION = "mta.label.xml";
    @Inject
    private Furnace furnace;
    @Inject
    private FurnaceClasspathScanner scanner;

    public boolean isFileBased() {
        return true;
    }

    public List<LabelProvider> getProviders(RuleLoaderContext ruleLoaderContext) {
        LabelProvider labelProvider;
        ParserContext parser;
        Document doc;
        DocumentBuilder dBuilder;
        ArrayList<LabelProvider> providers = new ArrayList<LabelProvider>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new WindupException("Failed to build xml parser due to: " + e.getMessage(), (Throwable)e);
        }
        for (Map.Entry<Addon, List<URL>> addonFiles : this.getAddonWindupXmlFiles().entrySet()) {
            Addon addon = addonFiles.getKey();
            List<URL> urls = addonFiles.getValue();
            for (URL resource : urls) {
                try {
                    doc = dBuilder.parse(resource.toURI().toString());
                    parser = new ParserContext(this.furnace, ruleLoaderContext);
                    parser.setAddonContainingInputXML(addon);
                    labelProvider = (LabelProvider)parser.processElement(doc.getDocumentElement());
                    this.setOrigin(labelProvider, resource);
                    providers.add(labelProvider);
                }
                catch (Exception e) {
                    throw new WindupException("Failed to parse XML configuration at: " + resource.toString() + " due to: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        for (Path userLabelsPath : ruleLoaderContext.getRulePaths()) {
            Collection<URL> userXmlLabelsetFiles = this.getWindupUserDirectoryXmlFiles(userLabelsPath);
            StringBuilder sb = new StringBuilder(System.lineSeparator() + "Found " + userXmlLabelsetFiles.size() + " user XML labels in: " + userLabelsPath);
            for (URL resource : userXmlLabelsetFiles) {
                sb.append(System.lineSeparator()).append("\t").append(resource.toString());
            }
            LOG.info(sb.toString());
            for (URL resource : userXmlLabelsetFiles) {
                try {
                    doc = dBuilder.parse(resource.toURI().toString());
                    parser = new ParserContext(this.furnace, ruleLoaderContext);
                    parser.setXmlInputPath(Paths.get(resource.toURI()));
                    parser.setXmlInputRootPath(userLabelsPath);
                    labelProvider = (LabelProvider)parser.processElement(doc.getDocumentElement());
                    this.setOrigin(labelProvider, resource);
                    providers.add(labelProvider);
                }
                catch (Exception e) {
                    throw new WindupException("Failed to parse XML configuration at: " + resource.toString() + " due to: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return providers;
    }

    private void setOrigin(LabelProvider provider, URL resource) {
        LabelProviderMetadata metadata = provider.getMetadata();
        if (metadata instanceof LabelMetadataBuilder) {
            ((LabelMetadataBuilder)metadata).setOrigin(resource.toExternalForm());
        }
    }

    private Map<Addon, List<URL>> getAddonWindupXmlFiles() {
        Map addon = this.scanner.scanForAddonMap((Predicate)new FileExtensionFilter(XML_LABELS_WINDUP_EXTENSION));
        addon.putAll(this.scanner.scanForAddonMap((Predicate)new FileExtensionFilter(XML_LABELS_RHAMT_EXTENSION)));
        addon.putAll(this.scanner.scanForAddonMap((Predicate)new FileExtensionFilter(XML_LABELS_MTA_EXTENSION)));
        return addon;
    }

    private Collection<URL> getWindupUserDirectoryXmlFiles(Path userLabelsPath) {
        if (userLabelsPath == null) {
            return Collections.emptyList();
        }
        try {
            if (Files.isRegularFile(userLabelsPath, new LinkOption[0]) && this.pathMatchesNamePattern(userLabelsPath)) {
                return Collections.singletonList(userLabelsPath.toUri().toURL());
            }
            if (!Files.isDirectory(userLabelsPath, new LinkOption[0])) {
                LOG.warning("Not scanning: " + userLabelsPath.normalize().toString() + " for labels as the directory could not be read!");
                return Collections.emptyList();
            }
            final ArrayList<URL> results = new ArrayList<URL>();
            Files.walkFileTree(userLabelsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (XMLLabelProviderLoader.this.pathMatchesNamePattern(file)) {
                        results.add(file.toUri().toURL());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return results;
        }
        catch (IOException e) {
            throw new WindupException("Failed to search userdir: \"" + userLabelsPath + "\" for XML labels due to: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean pathMatchesNamePattern(Path file) {
        return file.getFileName().toString().toLowerCase().endsWith(".windup.label.xml") || file.getFileName().toString().toLowerCase().endsWith(".rhamt.label.xml") || file.getFileName().toString().toLowerCase().endsWith(".mta.label.xml");
    }
}

