/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.service.GraphService;

public class WindupConfigurationService
extends GraphService<WindupConfigurationModel> {
    private static final String ARCHIVES = "archives";

    public WindupConfigurationService(GraphContext context) {
        super(context, WindupConfigurationModel.class);
    }

    public static Path getArchivesPath(GraphContext graphContext) {
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel(graphContext);
        String windupOutputFolder = cfg.getOutputPath().getFilePath();
        return Paths.get(windupOutputFolder, ARCHIVES);
    }

    public static synchronized WindupConfigurationModel getConfigurationModel(GraphContext context) {
        WindupConfigurationModel config = new GraphService<WindupConfigurationModel>(context, WindupConfigurationModel.class).getUnique();
        if (config == null) {
            config = new GraphService<WindupConfigurationModel>(context, WindupConfigurationModel.class).create();
        }
        return config;
    }
}

