/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.jboss.windup.graph.Adjacency;
import org.jboss.windup.graph.Indexed;
import org.jboss.windup.graph.Property;
import org.jboss.windup.graph.model.DuplicateProjectModel;
import org.jboss.windup.graph.model.HasApplications;
import org.jboss.windup.graph.model.ProjectDependencyModel;
import org.jboss.windup.graph.model.TypeValue;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;

@TypeValue(value="ProjectModel")
public interface ProjectModel
extends WindupVertexFrame,
HasApplications {
    public static final String TYPE = "ProjectModel";
    public static final String CSV_FILENAME = "projectModelCsvFilename";
    public static final String DEPENDENCY = "dependency";
    public static final String PARENT_PROJECT = "parentProject";
    public static final String ROOT_FILE_MODEL = "rootFileModel";
    public static final String PROJECT_MODEL_TO_FILE = "projectModelToFile";
    public static final String SOURCE_BASED = "sourceBased";
    public static final String DESCRIPTION = "description";
    public static final String ORGANIZATION = "organization";
    public static final String URL = "url";
    public static final String NAME = "name";
    public static final String UNIQUE_ID = "uniqueID";
    public static final String VERSION = "version";
    public static final String PROJECT_TYPE = "projectType";
    public static final String TYPE_VIRTUAL = "VIRTUAL";

    @Adjacency(label="rootFileModel", direction=Direction.OUT)
    public FileModel getRootFileModelInternal();

    default public FileModel getRootFileModel() {
        try {
            return this.getRootFileModelInternal();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Adjacency(label="rootFileModel", direction=Direction.OUT)
    public void setRootFileModel(FileModel var1);

    @Property(value="projectModelCsvFilename")
    public String getCsvFilename();

    @Property(value="projectModelCsvFilename")
    public void setCsvFilename(String var1);

    @Property(value="sourceBased")
    public void setSourceBased(boolean var1);

    @Property(value="sourceBased")
    public Boolean isSourceBased();

    @Property(value="organization")
    public String getOrganization();

    @Property(value="organization")
    public void setOrganization(String var1);

    @Property(value="projectType")
    public String getProjectType();

    @Property(value="projectType")
    public void setProjectType(String var1);

    @Property(value="version")
    public String getVersion();

    @Property(value="version")
    public void setVersion(String var1);

    @Property(value="name")
    public String getName();

    @Property(value="name")
    public void setName(String var1);

    @Indexed
    @Property(value="uniqueID")
    public String getUniqueID();

    @Property(value="uniqueID")
    public void setUniqueID(String var1);

    @Property(value="description")
    public String getDescription();

    @Property(value="description")
    public void setDescription(String var1);

    @Property(value="url")
    public String getURL();

    @Property(value="url")
    public void setURL(String var1);

    @Adjacency(label="parentProject", direction=Direction.OUT)
    public ProjectModel getParentProjectNotNullSafe();

    @Adjacency(label="parentProject", direction=Direction.OUT)
    public void setParentProject(ProjectModel var1);

    default public ProjectModel getParentProject() {
        try {
            return this.getParentProjectNotNullSafe();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Adjacency(label="parentProject", direction=Direction.IN)
    public void addChildProject(ProjectModel var1);

    @Adjacency(label="parentProject", direction=Direction.IN)
    public List<ProjectModel> getChildProjects();

    @Adjacency(label="dependency", direction=Direction.OUT)
    public void addDependency(ProjectDependencyModel var1);

    @Adjacency(label="dependency", direction=Direction.OUT)
    public List<ProjectDependencyModel> getDependencies();

    @Adjacency(label="projectModelToFile", direction=Direction.OUT)
    public List<FileModel> getFileModels();

    @Adjacency(label="projectModelToFile", direction=Direction.OUT)
    public void addFileModel(FileModel var1);

    default public List<FileModel> getFileModelsNoDirectories() {
        ArrayList<FileModel> result = new ArrayList<FileModel>();
        this.getFileModels().forEach(fileModel -> {
            if (!fileModel.isDirectory()) {
                result.add((FileModel)fileModel);
            }
        });
        return result;
    }

    default public List<FileModel> getUnparsableFiles() {
        ArrayList<FileModel> result = new ArrayList<FileModel>();
        this.getFileModels().forEach(fileModel -> {
            if (fileModel.getParseError() != null) {
                result.add((FileModel)fileModel);
            }
        });
        return result;
    }

    default public ProjectModel getRootProjectModel() {
        ProjectModel projectModel = this;
        try {
            while (projectModel.getParentProject() != null) {
                projectModel = projectModel.getParentProject();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return projectModel;
    }

    @Override
    default public List<ProjectModel> getApplications() {
        return new ArrayList<ProjectModel>(this.getApplications(this));
    }

    default public Set<ProjectModel> getApplications(ProjectModel project) {
        HashSet<ProjectModel> applications = new HashSet<ProjectModel>();
        for (ProjectModel projectModel : project.getDuplicateProjects()) {
            projectModel.getApplications().forEach(applications::add);
        }
        ProjectModel parent = project.getParentProject();
        if (parent != null) {
            parent.getApplications().forEach(applications::add);
        }
        if (parent == null) {
            applications.add(project);
        }
        return applications;
    }

    default public Set<ProjectModel> getAllProjectModels() {
        HashSet<ProjectModel> result = new HashSet<ProjectModel>();
        result.add(this);
        for (ProjectModel child : this.getChildProjects()) {
            result.addAll(child.getAllProjectModels());
        }
        return result;
    }

    @Adjacency(label="DuplicateProjectModel-canonicalProject", direction=Direction.IN)
    public List<DuplicateProjectModel> getDuplicateProjects();
}

