/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.model;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.jboss.windup.graph.Adjacency;
import org.jboss.windup.graph.Property;
import org.jboss.windup.graph.model.DuplicateArchiveModel;
import org.jboss.windup.graph.model.OrganizationModel;
import org.jboss.windup.graph.model.TypeValue;
import org.jboss.windup.graph.model.resource.FileModel;

@TypeValue(value="ArchiveModel")
public interface ArchiveModel
extends FileModel {
    public static final String TYPE = "ArchiveModel";
    public static final String ARCHIVE_NAME = "archiveName";
    public static final String UNZIPPED_DIRECTORY = "unzippedDirectory";
    public static final String PARENT_ARCHIVE = "parentArchive";

    @Adjacency(label="parentArchive", direction=Direction.IN)
    public ArchiveModel getParentArchiveNotNullSafe();

    default public ArchiveModel getParentArchive() {
        try {
            return this.getParentArchiveNotNullSafe();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Adjacency(label="parentArchive", direction=Direction.IN)
    public void setParentArchive(ArchiveModel var1);

    @Property(value="archiveName")
    public String getArchiveName();

    @Property(value="archiveName")
    public void setArchiveName(String var1);

    @Property(value="unzippedDirectory")
    public String getUnzippedDirectory();

    @Property(value="unzippedDirectory")
    public void setUnzippedDirectory(String var1);

    @Adjacency(label="OrganizationModel-organizationModelToArchiveModel", direction=Direction.IN)
    public List<OrganizationModel> getOrganizationModels();

    default public Set<FileModel> getAllFiles() {
        LinkedHashSet<FileModel> results = new LinkedHashSet<FileModel>();
        for (FileModel child : this.getFilesInDirectory()) {
            this.addAllFiles(results, child);
        }
        return results;
    }

    default public void addAllFiles(Set<FileModel> files, FileModel file) {
        files.add(file);
        if (file instanceof ArchiveModel) {
            return;
        }
        for (FileModel child : file.getFilesInDirectory()) {
            this.addAllFiles(files, child);
        }
    }

    @Adjacency(label="DuplicateArchiveModel-canonicalArchive", direction=Direction.IN)
    public List<DuplicateArchiveModel> getDuplicateArchives();

    default public ArchiveModel getRootArchiveModel() {
        ArchiveModel archiveModel = this;
        while (archiveModel.getParentArchive() != null) {
            archiveModel = archiveModel.getParentArchive();
        }
        return archiveModel;
    }

    default public boolean containsArchive(ArchiveModel archiveModel) {
        if (this.getElement().equals(archiveModel.getElement())) {
            return true;
        }
        if (archiveModel.getParentArchive() != null) {
            return this.containsArchive(archiveModel.getParentArchive());
        }
        return false;
    }
}

