/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RuleUtils;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.phase.PreReportPfRenderingPhase;
import org.jboss.windup.reporting.data.dto.RuleContentDto;
import org.jboss.windup.reporting.data.dto.RuleDto;
import org.jboss.windup.reporting.data.rules.AbstractApiRuleProvider;
import org.jboss.windup.reporting.data.rules.utils.DataUtils;
import org.jboss.windup.reporting.ruleexecution.RuleExecutionResultsListener;
import org.ocpsoft.rewrite.config.Rule;

@RuleMetadata(phase=PreReportPfRenderingPhase.class, haltOnException=true)
public class RulesRuleProvider
extends AbstractApiRuleProvider {
    public static final String PATH = "rules";

    @Override
    public String getBasePath() {
        return PATH;
    }

    @Override
    public Object getAll(GraphRewrite event) {
        HashMap result = new HashMap();
        RuleProviderRegistry.instance((GraphRewrite)event).getProviders().forEach(ruleProvider -> {
            if (ruleProvider instanceof AbstractRuleProvider) {
                String ruleSetId = ruleProvider.getMetadata().getID();
                String phase = ruleProvider.getMetadata().getPhase().getSimpleName();
                List sourceTechnology = ruleProvider.getMetadata().getSourceTechnologies().stream().map(technologyReference -> {
                    RuleDto.TechnologyDto technologyDto = new RuleDto.TechnologyDto();
                    technologyDto.setId(technologyReference.getId());
                    technologyDto.setVersionRange(technologyReference.getVersionRangeAsString());
                    return technologyDto;
                }).collect(Collectors.toList());
                List targetTechnology = ruleProvider.getMetadata().getTargetTechnologies().stream().map(technologyReference -> {
                    RuleDto.TechnologyDto technologyDto = new RuleDto.TechnologyDto();
                    technologyDto.setId(technologyReference.getId());
                    technologyDto.setVersionRange(technologyReference.getVersionRangeAsString());
                    return technologyDto;
                }).collect(Collectors.toList());
                List rules = RuleExecutionResultsListener.instance((GraphRewrite)event).getRuleExecutionInformation((AbstractRuleProvider)ruleProvider).stream().filter(Objects::nonNull).map(ruleExecutionInformation -> {
                    RuleDto ruleDto = new RuleDto();
                    ruleDto.setId(DataUtils.sanitizeFilename(ruleExecutionInformation.getRule().getId()));
                    ruleDto.setRuleSetId(ruleSetId);
                    ruleDto.setVerticesAdded(ruleExecutionInformation.getVertexIDsAdded());
                    ruleDto.setEdgesAdded(ruleExecutionInformation.getEdgeIDsAdded());
                    ruleDto.setVerticesRemoved(ruleExecutionInformation.getVertexIDsRemoved());
                    ruleDto.setEdgesRemoved(ruleExecutionInformation.getEdgeIDsRemoved());
                    ruleDto.setExecuted(ruleExecutionInformation.isExecuted());
                    ruleDto.setFailed(ruleExecutionInformation.isFailed());
                    ruleDto.setFailureMessage(ruleExecutionInformation.getFailureCause() != null && ruleExecutionInformation.getFailureCause().getMessage() != null ? ruleExecutionInformation.getFailureCause().getMessage() : null);
                    ruleDto.setSourceTechnology(sourceTechnology);
                    ruleDto.setTargetTechnology(targetTechnology);
                    return ruleDto;
                }).collect(Collectors.toList());
                if (!result.containsKey(phase)) {
                    result.put(phase, new ArrayList());
                }
                ((List)result.get(phase)).addAll(rules);
            }
        });
        return result;
    }

    @Override
    public Map<String, Object> getById(GraphRewrite event) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RuleProviderRegistry.instance((GraphRewrite)event).getProviders().forEach(ruleProvider -> {
            if (ruleProvider instanceof AbstractRuleProvider) {
                RuleExecutionResultsListener.instance((GraphRewrite)event).getRuleExecutionInformation((AbstractRuleProvider)ruleProvider).stream().filter(Objects::nonNull).forEach(ruleExecutionInformation -> {
                    RuleContentDto ruleDto = new RuleContentDto();
                    ruleDto.setId(DataUtils.sanitizeFilename(ruleExecutionInformation.getRule().getId()));
                    ruleDto.setContent(RuleUtils.ruleToRuleContentsString((Rule)ruleExecutionInformation.getRule(), (int)0));
                    result.put(ruleDto.getId(), ruleDto);
                });
            }
        });
        return result;
    }
}

