/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.PreReportPfRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.data.dto.ApplicationPackageIncidentsDto;
import org.jboss.windup.reporting.data.rules.AbstractApiRuleProvider;
import org.jboss.windup.rules.apps.java.service.TypeReferenceService;

@RuleMetadata(phase=PreReportPfRenderingPhase.class, haltOnException=true)
public class PackageIncidentsRuleProvider
extends AbstractApiRuleProvider {
    public static final String PATH = "packages-incidents";

    @Override
    public String getBasePath() {
        return PATH;
    }

    @Override
    public Object getAll(GraphRewrite event) {
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
        GraphContext context = event.getGraphContext();
        ArrayList<ApplicationPackageIncidentsDto> result = new ArrayList<ApplicationPackageIncidentsDto>();
        for (FileModel inputPath : configurationModel.getInputPaths()) {
            ProjectModel projectModel = inputPath.getProjectModel();
            HashSet includeTags = new HashSet();
            HashSet excludeTags = new HashSet();
            TypeReferenceService typeReferenceService = new TypeReferenceService(context);
            Map packages = typeReferenceService.getPackageUseFrequencies(projectModel, includeTags, excludeTags, 2, true);
            ApplicationPackageIncidentsDto applicationPackageIncidentsDto = new ApplicationPackageIncidentsDto();
            applicationPackageIncidentsDto.setApplicationId(projectModel.getId().toString());
            applicationPackageIncidentsDto.setPackages(packages);
            result.add(applicationPackageIncidentsDto);
        }
        return result;
    }

    @Override
    public Map<String, Object> getById(GraphRewrite event) {
        return Collections.emptyMap();
    }
}

