/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.LabelProvider;
import org.jboss.windup.config.loader.LabelLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.LabelProviderRegistry;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.PreReportPfRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.data.dto.LabelDto;
import org.jboss.windup.reporting.data.rules.AbstractApiRuleProvider;

@RuleMetadata(phase=PreReportPfRenderingPhase.class, haltOnException=true)
public class LabelsRuleProvider
extends AbstractApiRuleProvider {
    public static final String PATH = "labels";
    @Inject
    private LabelLoader labelLoader;

    @Override
    public String getBasePath() {
        return PATH;
    }

    @Override
    public Object getAll(GraphRewrite event) {
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
        List userLabelPaths = cfg.getUserLabelsPaths().stream().map(fileModel -> fileModel.asFile().toPath()).collect(Collectors.toList());
        ArrayList labels = new ArrayList();
        RuleLoaderContext labelLoaderContext = new RuleLoaderContext(userLabelPaths, null);
        LabelProviderRegistry labelProviderRegistry = this.labelLoader.loadConfiguration(labelLoaderContext);
        for (LabelProvider provider : labelProviderRegistry.getProviders()) {
            labels.addAll(provider.getData().getLabels());
        }
        return labels.stream().map(label -> {
            LabelDto labelDto = new LabelDto();
            labelDto.setId(label.getId());
            labelDto.setName(label.getName());
            labelDto.setDescription(label.getDescription());
            labelDto.setSupported(new HashSet<String>(label.getSupported()));
            labelDto.setUnsuitable(new HashSet<String>(label.getUnsuitable()));
            labelDto.setNeutral(new HashSet<String>(label.getNeutral()));
            return labelDto;
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> getById(GraphRewrite event) {
        return Collections.emptyMap();
    }
}

