/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.PreReportPfRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.ReportResourceFileModel;
import org.jboss.windup.graph.service.ProjectService;
import org.jboss.windup.graph.traversal.OnlyOnceTraversalStrategy;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.graph.traversal.TraversalStrategy;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.data.dto.ApplicationIssuesDto;
import org.jboss.windup.reporting.data.rules.AbstractApiRuleProvider;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummaryService;
import org.jboss.windup.reporting.service.EffortReportService;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;

@RuleMetadata(phase=PreReportPfRenderingPhase.class, haltOnException=true)
public class IssuesRuleProvider
extends AbstractApiRuleProvider {
    public static final String PATH = "issues";

    @Override
    public String getBasePath() {
        return PATH;
    }

    @Override
    public Object getAll(GraphRewrite event) {
        GraphContext context = event.getGraphContext();
        Set includeTags = Collections.emptySet();
        Set excludeTags = Collections.emptySet();
        Set allProjects = new ProjectService(context).getRootProjectModels();
        allProjects.add(null);
        return allProjects.stream().map(projectModel -> {
            Set<ProjectModel> projectModels = this.getProjects((ProjectModel)projectModel);
            Map problemSummariesOriginal = ProblemSummaryService.getProblemSummaries((GraphContext)event.getGraphContext(), projectModels, (Set)includeTags, (Set)excludeTags);
            IssueCategoryModel.IssueSummaryPriorityComparator severityComparator = new IssueCategoryModel.IssueSummaryPriorityComparator();
            TreeMap problemSummaries = new TreeMap(severityComparator);
            problemSummaries.putAll(problemSummariesOriginal);
            LinkedHashMap<String, List> primarySummariesByString = new LinkedHashMap<String, List>(problemSummariesOriginal.size());
            for (Map.Entry entry : problemSummaries.entrySet()) {
                String severityString = entry.getKey() == null ? null : ((IssueCategoryModel)entry.getKey()).getName();
                primarySummariesByString.put(severityString, (List)entry.getValue());
            }
            String applicationId = Optional.ofNullable(projectModel).map(val -> val.getId().toString()).orElse("");
            ApplicationIssuesDto applicationIssuesDto = new ApplicationIssuesDto();
            applicationIssuesDto.setApplicationId(applicationId);
            applicationIssuesDto.setIssues(new HashMap<String, List<ApplicationIssuesDto.IssueDto>>());
            for (Map.Entry entry : primarySummariesByString.entrySet()) {
                String key = (String)entry.getKey();
                List value = ((List)entry.getValue()).stream().map(problemSummary -> {
                    ApplicationIssuesDto.IssueDto issueData = new ApplicationIssuesDto.IssueDto();
                    issueData.setId(problemSummary.getId().toString());
                    issueData.setRuleId(problemSummary.getRuleID());
                    issueData.setSourceTechnologies(problemSummary.getSourceTechnologies());
                    issueData.setTargetTechnologies(problemSummary.getTargetTechnologies());
                    EffortReportService.EffortLevel effortLevel = EffortReportService.EffortLevel.forPoints((int)problemSummary.getEffortPerIncident());
                    issueData.setEffort(new ApplicationIssuesDto.EffortDto());
                    issueData.getEffort().setType(effortLevel.getShortDescription());
                    issueData.getEffort().setDescription(effortLevel.getVerboseDescription());
                    issueData.getEffort().setPoints(effortLevel.getPoints());
                    issueData.setTotalIncidents(problemSummary.getNumberFound());
                    issueData.setTotalStoryPoints(problemSummary.getNumberFound() * problemSummary.getEffortPerIncident());
                    issueData.setName(problemSummary.getIssueName());
                    issueData.setLinks(problemSummary.getLinks().stream().map(link -> {
                        ApplicationIssuesDto.LinkDto linkDto = new ApplicationIssuesDto.LinkDto();
                        linkDto.setTitle(link.getTitle());
                        linkDto.setHref(link.getLink());
                        return linkDto;
                    }).collect(Collectors.toList()));
                    issueData.setAffectedFiles(StreamSupport.stream(problemSummary.getDescriptions().spliterator(), false).map(description -> {
                        ApplicationIssuesDto.IssueAffectedFilesDto issueAffectedFilesDto = new ApplicationIssuesDto.IssueAffectedFilesDto();
                        issueAffectedFilesDto.setDescription((String)description);
                        issueAffectedFilesDto.setFiles(StreamSupport.stream(problemSummary.getFilesForDescription(description).spliterator(), false).map(fileSummary -> {
                            ApplicationIssuesDto.IssueFileDto issueFileDto = new ApplicationIssuesDto.IssueFileDto();
                            issueFileDto.setFileId(fileSummary.getFile().getId().toString());
                            issueFileDto.setFileName(IssuesRuleProvider.getPrettyPathForFile(fileSummary.getFile()));
                            issueFileDto.setOccurrences(fileSummary.getOccurrences());
                            return issueFileDto;
                        }).collect(Collectors.toList()));
                        return issueAffectedFilesDto;
                    }).collect(Collectors.toList()));
                    return issueData;
                }).collect(Collectors.toList());
                String category = key.toLowerCase().trim().replaceAll("migration ", "").replaceAll(" ", "-");
                applicationIssuesDto.getIssues().put(category, value);
            }
            return applicationIssuesDto;
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> getById(GraphRewrite event) {
        return Collections.emptyMap();
    }

    private Set<ProjectModel> getProjects(ProjectModel projectModel) {
        if (projectModel == null) {
            return null;
        }
        ProjectModelTraversal traversal = new ProjectModelTraversal(projectModel, (TraversalStrategy)new OnlyOnceTraversalStrategy());
        return traversal.getAllProjects(true);
    }

    public static String getPrettyPathForFile(FileModel fileModel) {
        if (fileModel instanceof JavaClassFileModel) {
            JavaClassFileModel jcfm = (JavaClassFileModel)fileModel;
            if (jcfm.getJavaClass() == null) {
                return fileModel.getPrettyPathWithinProject();
            }
            return jcfm.getJavaClass().getQualifiedName();
        }
        if (fileModel instanceof ReportResourceFileModel) {
            return "resources/" + fileModel.getPrettyPath();
        }
        if (fileModel instanceof JavaSourceFileModel) {
            JavaSourceFileModel javaSourceModel = (JavaSourceFileModel)fileModel;
            String filename = StringUtils.removeEndIgnoreCase((String)fileModel.getFileName(), (String)".java");
            String packageName = javaSourceModel.getPackageName();
            return packageName == null || packageName.isEmpty() ? filename : packageName + "." + filename;
        }
        if (fileModel instanceof ArchiveModel) {
            return fileModel.getPrettyPath();
        }
        return fileModel.getPrettyPathWithinProject();
    }
}

