/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.PreReportPfRenderingPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.IgnoredFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.data.dto.ApplicationIgnoredFilesDto;
import org.jboss.windup.reporting.data.rules.AbstractApiRuleProvider;

@RuleMetadata(phase=PreReportPfRenderingPhase.class, haltOnException=true)
public class IgnoredFilesRuleProvider
extends AbstractApiRuleProvider {
    public static final String PATH = "ignored-files";

    @Override
    public String getBasePath() {
        return PATH;
    }

    @Override
    public Object getAll(GraphRewrite event) {
        GraphContext context = event.getGraphContext();
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        ArrayList<ApplicationIgnoredFilesDto> result = new ArrayList<ApplicationIgnoredFilesDto>();
        for (FileModel inputPath : configurationModel.getInputPaths()) {
            ProjectModel application = inputPath.getProjectModel();
            GraphService ignoredFilesModelService = new GraphService(context, IgnoredFileModel.class);
            ArrayList<ApplicationIgnoredFilesDto.IgnoredFileDto> filesDto = new ArrayList<ApplicationIgnoredFilesDto.IgnoredFileDto>();
            for (IgnoredFileModel file : ignoredFilesModelService.findAll()) {
                Set fileApplications = ProjectTraversalCache.getApplicationsForProject((GraphContext)context, (ProjectModel)file.getProjectModel());
                if (!fileApplications.contains(application)) continue;
                ApplicationIgnoredFilesDto.IgnoredFileDto ignoredFileDto = new ApplicationIgnoredFilesDto.IgnoredFileDto();
                ignoredFileDto.setFileName(file.getFileName());
                ignoredFileDto.setFilePath(file.getFilePath());
                ignoredFileDto.setReason(file.getIgnoredRegex());
                filesDto.add(ignoredFileDto);
            }
            ApplicationIgnoredFilesDto applicationIgnoredFilesDto = new ApplicationIgnoredFilesDto();
            applicationIgnoredFilesDto.setApplicationId(application.getId().toString());
            applicationIgnoredFilesDto.setIgnoredFiles(filesDto);
            result.add(applicationIgnoredFilesDto);
        }
        return result;
    }

    @Override
    public Map<String, Object> getById(GraphRewrite event) {
        return Collections.emptyMap();
    }
}

