/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.PreReportPfRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.data.dto.ApplicationSpringBeansDto;
import org.jboss.windup.reporting.data.rules.AbstractApiRuleProvider;
import org.jboss.windup.reporting.data.rules.utils.DataUtils;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.SourceReportService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.SpringConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.service.SpringBeanService;

@RuleMetadata(phase=PreReportPfRenderingPhase.class, haltOnException=true)
public class ApplicationSpringBeansRuleProvider
extends AbstractApiRuleProvider {
    public static final String PATH = "spring-beans";

    @Override
    public String getBasePath() {
        return PATH;
    }

    @Override
    public Object getAll(GraphRewrite event) {
        GraphContext context = event.getGraphContext();
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        SourceReportService sourceReportService = new SourceReportService(context);
        JavaClassService javaClassService = new JavaClassService(context);
        ArrayList<ApplicationSpringBeansDto> result = new ArrayList<ApplicationSpringBeansDto>();
        for (FileModel inputPath : configurationModel.getInputPaths()) {
            ProjectModel application = inputPath.getProjectModel();
            SpringBeanService springBeanService = new SpringBeanService(context);
            ApplicationSpringBeansDto applicationSpringBeansDto = new ApplicationSpringBeansDto();
            applicationSpringBeansDto.setApplicationId(application.getId().toString());
            Iterable models = springBeanService.findAllByApplication(application);
            if (!models.iterator().hasNext()) {
                applicationSpringBeansDto.setBeans(Collections.emptyList());
                continue;
            }
            GraphService listService = new GraphService(context, WindupVertexListModel.class);
            WindupVertexListModel springBeanList = (WindupVertexListModel)listService.create();
            springBeanList.addAll(models);
            applicationSpringBeansDto.setBeans(StreamSupport.stream(springBeanList.spliterator(), false).map(springBeanModel -> {
                JavaClassModel clz;
                ApplicationSpringBeansDto.SpringBeanDto springBeanDto = new ApplicationSpringBeansDto.SpringBeanDto();
                springBeanDto.setBeanName(springBeanModel.getSpringBeanName());
                springBeanDto.setClassName(springBeanModel.getJavaClass().getQualifiedName());
                SpringConfigurationFileModel springConfiguration = springBeanModel.getSpringConfiguration();
                if (springConfiguration != null) {
                    if (springBeanDto.getBeanName() == null) {
                        springBeanDto.setBeanName(springConfiguration.getPrettyPathWithinProject());
                    }
                    springBeanDto.setBeanDescriptorFileId(DataUtils.getSourceFileId(sourceReportService, (FileModel)springConfiguration));
                }
                if ((clz = springBeanModel.getJavaClass()) != null) {
                    springBeanDto.setClassFileId(DataUtils.getSourceFileId(javaClassService, sourceReportService, clz.getQualifiedName()));
                }
                return springBeanDto;
            }).collect(Collectors.toList()));
            result.add(applicationSpringBeansDto);
        }
        return result;
    }

    @Override
    public Map<String, Object> getById(GraphRewrite event) {
        return Collections.emptyMap();
    }
}

