/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.PreReportPfRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.data.dto.ApplicationEJBsDto;
import org.jboss.windup.reporting.data.rules.AbstractApiRuleProvider;
import org.jboss.windup.reporting.data.rules.utils.DataUtils;
import org.jboss.windup.reporting.service.SourceReportService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.EjbBeanBaseModel;
import org.jboss.windup.rules.apps.javaee.model.EjbDeploymentDescriptorModel;
import org.jboss.windup.rules.apps.javaee.model.EjbEntityBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.service.EjbBeanService;

@RuleMetadata(phase=PreReportPfRenderingPhase.class, haltOnException=true)
public class ApplicationEJBsRuleProvider
extends AbstractApiRuleProvider {
    public static final String PATH = "ejb";

    @Override
    public String getBasePath() {
        return PATH;
    }

    @Override
    public Object getAll(GraphRewrite event) {
        GraphContext context = event.getGraphContext();
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        SourceReportService sourceReportService = new SourceReportService(context);
        JavaClassService javaClassService = new JavaClassService(context);
        ArrayList<ApplicationEJBsDto> result = new ArrayList<ApplicationEJBsDto>();
        for (FileModel inputPath : configurationModel.getInputPaths()) {
            ProjectModel application = inputPath.getProjectModel();
            EjbBeanService ejbService = new EjbBeanService(context);
            ApplicationEJBsDto applicationEJBsDto = new ApplicationEJBsDto();
            applicationEJBsDto.setApplicationId(application.getId().toString());
            applicationEJBsDto.setEntityBeans(new ArrayList<ApplicationEJBsDto.EntityBeanDto>());
            applicationEJBsDto.setSessionBeans(new ArrayList<ApplicationEJBsDto.SessionBeanDto>());
            applicationEJBsDto.setMessageDrivenBeans(new ArrayList<ApplicationEJBsDto.MessageDrivenBeanDto>());
            for (EjbBeanBaseModel beanBaseModel : ejbService.findAll()) {
                ApplicationEJBsDto.BeanDto beanDto2;
                if (!Iterables.contains((Iterable)beanBaseModel.getApplications(), (Object)application)) continue;
                Consumer<ApplicationEJBsDto.BeanDto> setCommonBeanData = beanDto -> {
                    beanDto.setBeanName(beanBaseModel.getBeanName());
                    JavaClassModel clz = beanBaseModel.getEjbClass();
                    if (clz != null) {
                        beanDto.setClassName(beanBaseModel.getEjbClass().getQualifiedName());
                        beanDto.setClassFileId(DataUtils.getSourceFileId(javaClassService, sourceReportService, clz.getQualifiedName()));
                    }
                };
                if (beanBaseModel instanceof EjbMessageDrivenModel) {
                    beanDto2 = new ApplicationEJBsDto.MessageDrivenBeanDto();
                    applicationEJBsDto.getMessageDrivenBeans().add((ApplicationEJBsDto.MessageDrivenBeanDto)beanDto2);
                    setCommonBeanData.accept(beanDto2);
                    EjbMessageDrivenModel mdb = (EjbMessageDrivenModel)beanBaseModel;
                    beanDto2.setBeanDescriptorFileId(this.getDescriptorFileId(sourceReportService, mdb.getEjbDeploymentDescriptor()));
                    if (mdb.getDestination() == null) continue;
                    ((ApplicationEJBsDto.MessageDrivenBeanDto)beanDto2).setJmsDestination(mdb.getDestination().getJndiLocation());
                    continue;
                }
                if (beanBaseModel instanceof EjbEntityBeanModel) {
                    beanDto2 = new ApplicationEJBsDto.EntityBeanDto();
                    applicationEJBsDto.getEntityBeans().add((ApplicationEJBsDto.EntityBeanDto)beanDto2);
                    setCommonBeanData.accept(beanDto2);
                    EjbEntityBeanModel entity = (EjbEntityBeanModel)beanBaseModel;
                    beanDto2.setBeanDescriptorFileId(this.getDescriptorFileId(sourceReportService, entity.getEjbDeploymentDescriptor()));
                    ((ApplicationEJBsDto.EntityBeanDto)beanDto2).setTableName(entity.getTableName());
                    ((ApplicationEJBsDto.EntityBeanDto)beanDto2).setPersistenceType(entity.getPersistenceType());
                    continue;
                }
                if (!(beanBaseModel instanceof EjbSessionBeanModel)) continue;
                beanDto2 = new ApplicationEJBsDto.SessionBeanDto();
                applicationEJBsDto.getSessionBeans().add((ApplicationEJBsDto.SessionBeanDto)beanDto2);
                setCommonBeanData.accept(beanDto2);
                EjbSessionBeanModel sessionBean = (EjbSessionBeanModel)beanBaseModel;
                beanDto2.setBeanDescriptorFileId(this.getDescriptorFileId(sourceReportService, sessionBean.getEjbDeploymentDescriptor()));
                ((ApplicationEJBsDto.SessionBeanDto)beanDto2).setType("stateful".equalsIgnoreCase(beanBaseModel.getSessionType()) ? ApplicationEJBsDto.SessionBeanType.STATEFUL : ApplicationEJBsDto.SessionBeanType.STATELESS);
                if (sessionBean.getEjbHome() != null) {
                    ((ApplicationEJBsDto.SessionBeanDto)beanDto2).setHomeEJBFileId(DataUtils.getSourceFileId(javaClassService, sourceReportService, sessionBean.getEjbHome().getQualifiedName()));
                }
                if (sessionBean.getEjbLocal() != null) {
                    ((ApplicationEJBsDto.SessionBeanDto)beanDto2).setLocalEJBFileId(DataUtils.getSourceFileId(javaClassService, sourceReportService, sessionBean.getEjbLocal().getQualifiedName()));
                }
                if (sessionBean.getEjbRemote() != null) {
                    ((ApplicationEJBsDto.SessionBeanDto)beanDto2).setRemoteEJBFileId(DataUtils.getSourceFileId(javaClassService, sourceReportService, sessionBean.getEjbRemote().getQualifiedName()));
                }
                ((ApplicationEJBsDto.SessionBeanDto)beanDto2).setJndiLocation(Stream.of(sessionBean.getGlobalJndiReference() != null ? sessionBean.getGlobalJndiReference().getJndiLocation() : null, sessionBean.getModuleJndiReference() != null ? sessionBean.getModuleJndiReference().getJndiLocation() : null, sessionBean.getLocalJndiReference() != null ? sessionBean.getLocalJndiReference().getJndiLocation() : null).filter(Objects::nonNull).findFirst().orElse(null));
            }
            result.add(applicationEJBsDto);
        }
        return result;
    }

    @Override
    public Map<String, Object> getById(GraphRewrite event) {
        return Collections.emptyMap();
    }

    private String getDescriptorFileId(SourceReportService sourceReportService, EjbDeploymentDescriptorModel ejbDeploymentDescriptor) {
        if (ejbDeploymentDescriptor != null) {
            return DataUtils.getSourceFileId(sourceReportService, (FileModel)ejbDeploymentDescriptor);
        }
        return null;
    }
}

