/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data.rules;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.PreReportPfRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.ReportResourceFileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.AllTraversalStrategy;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.graph.traversal.TraversalStrategy;
import org.jboss.windup.reporting.data.dto.ApplicationCompatibleFilesDto;
import org.jboss.windup.reporting.data.rules.AbstractApiRuleProvider;
import org.jboss.windup.reporting.data.rules.utils.DataUtils;
import org.jboss.windup.reporting.service.SourceReportService;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.query.FindFilesNotClassifiedOrHintedGremlinCriterion;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;

@RuleMetadata(phase=PreReportPfRenderingPhase.class, haltOnException=true)
public class ApplicationCompatibleFilesRuleProvider
extends AbstractApiRuleProvider {
    public static final String PATH = "compatible-files";

    @Override
    public String getBasePath() {
        return PATH;
    }

    @Override
    public Object getAll(GraphRewrite event) {
        Boolean generateReport = (Boolean)event.getGraphContext().getOptionMap().get("enableCompatibleFilesReport");
        if (generateReport == null || !generateReport.booleanValue()) {
            return Collections.emptyList();
        }
        GraphContext context = event.getGraphContext();
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        ArrayList<ApplicationCompatibleFilesDto> result = new ArrayList<ApplicationCompatibleFilesDto>();
        for (FileModel inputPath : configurationModel.getInputPaths()) {
            ProjectModel application = inputPath.getProjectModel();
            ApplicationCompatibleFilesDto applicationCompatibleFilesDto = new ApplicationCompatibleFilesDto();
            applicationCompatibleFilesDto.setApplicationId(application.getId().toString());
            applicationCompatibleFilesDto.setArtifacts(new ArrayList<ApplicationCompatibleFilesDto.ArtifactDto>());
            ProjectModelTraversal traversal = new ProjectModelTraversal(application, (TraversalStrategy)new AllTraversalStrategy());
            this.populateArrayWithArtifactDtos(context, traversal, applicationCompatibleFilesDto.getArtifacts());
            result.add(applicationCompatibleFilesDto);
        }
        return result;
    }

    @Override
    public Map<String, Object> getById(GraphRewrite event) {
        return Collections.emptyMap();
    }

    public void populateArrayWithArtifactDtos(GraphContext context, ProjectModelTraversal traversal, List<ApplicationCompatibleFilesDto.ArtifactDto> accumulator) {
        SourceReportService sourceReportService = new SourceReportService(context);
        ProjectModel projectModel = traversal.getCanonicalProject();
        FileModel rootFileModel = projectModel.getRootFileModel();
        ApplicationCompatibleFilesDto.ArtifactDto artifactDto = new ApplicationCompatibleFilesDto.ArtifactDto();
        artifactDto.setName(rootFileModel.getPrettyPath());
        artifactDto.setFiles(this.getAllCompatibleFiles(context, traversal).stream().filter(fileModel -> fileModel.getPrettyPathWithinProject() != null && !fileModel.getPrettyPathWithinProject().isEmpty()).map(fileModel -> {
            ApplicationCompatibleFilesDto.FileDto fileDto = new ApplicationCompatibleFilesDto.FileDto();
            fileDto.setFileName(this.getFilename((FileModel)fileModel));
            fileDto.setFileId(DataUtils.getSourceFileId(sourceReportService, fileModel));
            return fileDto;
        }).collect(Collectors.toList()));
        accumulator.add(artifactDto);
        ProjectModelTraversal traversal1 = new ProjectModelTraversal(projectModel, (TraversalStrategy)new AllTraversalStrategy());
        for (ProjectModelTraversal child : traversal1.getChildren()) {
            this.populateArrayWithArtifactDtos(context, child, accumulator);
        }
    }

    public List<FileModel> getAllCompatibleFiles(GraphContext context, ProjectModelTraversal traversal) {
        ProjectModel projectModel = traversal.getCanonicalProject();
        List fileModels = projectModel.getFileModelsNoDirectories();
        FindFilesNotClassifiedOrHintedGremlinCriterion criterion = new FindFilesNotClassifiedOrHintedGremlinCriterion();
        ArrayList initialFileModelsAsVertices = new ArrayList();
        fileModels.forEach(fm -> initialFileModelsAsVertices.add(fm.getElement()));
        Iterable vertices = criterion.query(context, initialFileModelsAsVertices);
        ArrayList<FileModel> compatibleFiles = new ArrayList<FileModel>();
        for (Vertex v : vertices) {
            Iterator decompiled;
            FileModel f = (FileModel)context.getFramed().frameElement((Element)v, FileModel.class);
            boolean wasNotGenerated = f.isWindupGenerated() == null || f.isWindupGenerated() == false;
            boolean isOfInterestingType = f instanceof JavaSourceFileModel || f instanceof XmlFileModel || f instanceof JavaClassFileModel;
            boolean withoutHiddenHints = true;
            if (f instanceof JavaClassFileModel && (decompiled = v.vertices(Direction.OUT, new String[]{"decompiledFile"})).hasNext()) {
                boolean bl = withoutHiddenHints = !((Vertex)decompiled.next()).vertices(Direction.IN, new String[]{"file"}).hasNext();
            }
            if (!wasNotGenerated || !withoutHiddenHints || !isOfInterestingType) continue;
            compatibleFiles.add(f);
        }
        return compatibleFiles;
    }

    public String getFilename(FileModel fileModel) {
        if (fileModel instanceof JavaClassFileModel) {
            return this.getPath((JavaClassFileModel)fileModel);
        }
        if (fileModel instanceof JavaSourceFileModel) {
            return this.getPath((JavaSourceFileModel)fileModel);
        }
        if (fileModel instanceof ReportResourceFileModel) {
            return this.getPath((ReportResourceFileModel)fileModel);
        }
        return fileModel.getPrettyPathWithinProject();
    }

    public String getPath(JavaClassFileModel jcfm) {
        String qualifiedName;
        String filename = jcfm.getFileName();
        String packageName = jcfm.getPackageName() == null ? "" : jcfm.getPackageName().replaceAll("\\.", File.separator);
        String reportFileName = qualifiedName = packageName + File.separator + filename;
        return reportFileName;
    }

    public String getPath(JavaSourceFileModel javaSourceModel) {
        String qualifiedName;
        String filename = javaSourceModel.getFileName();
        String packageName = javaSourceModel.getPackageName() == null ? "" : javaSourceModel.getPackageName().replaceAll("\\.", File.separator);
        String reportFileName = qualifiedName = packageName + File.separator + filename;
        return reportFileName;
    }

    public String getPath(ReportResourceFileModel model) {
        return "resources/" + model.getPrettyPath();
    }
}

