/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.DefaultEvaluationContext;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.PreRulesetEvaluation;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.RuleSubset;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.metadata.TechnologyReferenceAliasTranslator;
import org.jboss.windup.config.phase.PostReportGenerationPhase;
import org.jboss.windup.config.phase.PostReportPfRenderingPhase;
import org.jboss.windup.config.phase.PostReportRenderingPhase;
import org.jboss.windup.config.phase.PreReportGenerationPhase;
import org.jboss.windup.config.phase.PreReportPfRenderingPhase;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.phase.ReportPfRenderingPhase;
import org.jboss.windup.config.phase.ReportRenderingPhase;
import org.jboss.windup.exec.DefaultRuleLifecycleListener;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.exec.rulefilters.AndPredicate;
import org.jboss.windup.exec.rulefilters.NotPredicate;
import org.jboss.windup.exec.rulefilters.RuleProviderPhasePredicate;
import org.jboss.windup.exec.rulefilters.SourceAndTargetPredicate;
import org.jboss.windup.exec.rulefilters.TaggedRuleProviderPredicate;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.graph.model.ApplicationModel;
import org.jboss.windup.graph.model.TechnologyReferenceModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.Checks;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.Theme;
import org.jboss.windup.util.ThemeProvider;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleVisit;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;

public class WindupProcessorImpl
implements WindupProcessor {
    private static final Logger LOG = Logging.get(WindupProcessorImpl.class);
    @Inject
    private RuleLoader ruleLoader;
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private Imported<RuleLifecycleListener> listeners;

    public void execute() {
        this.execute(new WindupConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WindupConfiguration configuration) {
        Theme theme = ThemeProvider.getInstance().getTheme();
        long startTime = System.currentTimeMillis();
        this.validateConfig(configuration);
        boolean autoCloseGraph = false;
        if (configuration.getGraphContext() == null) {
            autoCloseGraph = true;
            Path graphPath = configuration.getOutputDirectory().resolve("graph");
            GraphContext graphContext = this.graphContextFactory.create(graphPath, true);
            configuration.setGraphContext(graphContext);
        }
        try {
            this.printConfigInfo(configuration);
            GraphContext graphContext = configuration.getGraphContext();
            graphContext.setOptions(configuration.getOptionMap());
            WindupConfigurationModel configurationModel = this.setupWindupConfigurationModel(configuration, graphContext);
            ArrayList<DefaultRuleLifecycleListener> listeners = new ArrayList<DefaultRuleLifecycleListener>();
            this.listeners.forEach(listeners::add);
            GraphRewrite windupContext = new GraphRewrite(listeners, graphContext);
            RuleLoaderContext ruleLoaderContext = new RuleLoaderContext(windupContext.getRewriteContext(), configuration.getAllUserRulesDirectories(), configuration.getRuleProviderFilter());
            ruleLoaderContext = this.configureRuleProviderAndTagFilters(ruleLoaderContext, configuration);
            this.saveSourceAndTargetInformation(windupContext, configuration, configurationModel);
            RuleProviderRegistry ruleProviderRegistry = this.ruleLoader.loadConfiguration(ruleLoaderContext);
            Configuration rulesConfiguration = ruleProviderRegistry.getConfiguration();
            if (configuration.getProgressMonitor() != null) {
                listeners.add(new DefaultRuleLifecycleListener(configuration.getProgressMonitor(), rulesConfiguration));
            }
            windupContext.getRewriteContext().put(RuleProviderRegistry.class, (Object)ruleProviderRegistry);
            RuleSubset ruleSubset = RuleSubset.create((Configuration)rulesConfiguration);
            ruleSubset.setAlwaysHaltOnFailure(configuration.isAlwaysHaltOnException());
            listeners.forEach(arg_0 -> ((RuleSubset)ruleSubset).addLifecycleListener(arg_0));
            new RuleVisit((Rule)ruleSubset).accept(rule -> {
                if (rule instanceof PreRulesetEvaluation) {
                    ((PreRulesetEvaluation)rule).preRulesetEvaluation(windupContext);
                }
            });
            ruleSubset.perform((Rewrite)windupContext, this.createEvaluationContext());
            if (windupContext.getWindupStopException() != null) {
                String message = theme.getBrandNameAcronym() + " was cancelled on request before finishing";
                if (windupContext.getWindupStopException().getMessage() != null) {
                    message = message + ", cause: " + windupContext.getWindupStopException().getMessage();
                }
                LOG.log(Level.INFO, message);
            }
        }
        finally {
            if (autoCloseGraph) {
                try {
                    configuration.getGraphContext().close();
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Failed to close graph due to: " + t.getMessage(), t);
                }
            }
            long endTime = System.currentTimeMillis();
            long seconds = (endTime - startTime) / 1000L;
            LOG.info(theme.getBrandNameAcronym() + " execution took " + seconds + " seconds to execute on input: " + configuration.getInputPaths() + "!");
            ExecutionStatistics.get().reset();
        }
    }

    private WindupConfigurationModel setupWindupConfigurationModel(WindupConfiguration configuration, GraphContext graphContext) {
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)graphContext);
        LinkedHashSet<FileModel> inputPathModels = new LinkedHashSet<FileModel>();
        for (Path inputPath : configuration.getInputPaths()) {
            inputPathModels.add(this.getFileModel(graphContext, inputPath));
        }
        configurationModel.setInputPaths(inputPathModels);
        List applicationNames = configuration.getInputApplicationNames();
        GraphService applicationModelService = new GraphService(graphContext, ApplicationModel.class);
        if (applicationNames == null) {
            inputPathModels.forEach(applicationModel -> ((ApplicationModel)applicationModelService.addTypeToModel((WindupVertexFrame)applicationModel)).setApplicationName(applicationModel.getFileName()));
        } else {
            ArrayList inputModelsList = new ArrayList(inputPathModels);
            for (int i = 0; i < inputModelsList.size(); ++i) {
                FileModel fileModel = (FileModel)inputModelsList.get(i);
                ApplicationModel applicationModel2 = (ApplicationModel)applicationModelService.addTypeToModel((WindupVertexFrame)fileModel);
                if (i < applicationNames.size()) {
                    applicationModel2.setApplicationName((String)applicationNames.get(i));
                    continue;
                }
                applicationModel2.setApplicationName(fileModel.getFileName());
            }
        }
        configurationModel.setOutputPath(this.getFileModel(graphContext, configuration.getOutputDirectory()));
        configurationModel.setOnlineMode(configuration.isOnline());
        configurationModel.setExportingCSV(configuration.isExportingCSV());
        configurationModel.setExportingSummary(configuration.isExportingSummary());
        configurationModel.setKeepWorkDirectories((Boolean)configuration.getOptionValue("keepWorkDirs"));
        configurationModel.setExportingZipReport(configuration.isExportingZipReport());
        this.addUserRulesDirsToConfig(configuration, graphContext, configurationModel);
        this.addUserLabelsDirsToConfig(configuration, graphContext, configurationModel);
        configuration.getAllIgnoreDirectories().forEach(dir -> configurationModel.addUserIgnorePath(this.getFileModel(graphContext, (Path)dir)));
        configurationModel.setAnalyzeKnownLibraries(Boolean.valueOf(configuration.isAnalyseKnownLibrariesSet()));
        configurationModel.setSkipSourceCodeReportsRendering((Boolean)configuration.getOptionValue("skipSourceCodeReports"));
        return configurationModel;
    }

    private void addUserLabelsDirsToConfig(WindupConfiguration configuration, GraphContext graphContext, WindupConfigurationModel configurationModel) {
        for (Path path : configuration.getAllUserLabelsDirectories()) {
            System.out.println("Using user labels dir: " + path);
            if (path == null) {
                throw new WindupException(String.format("Null path found (all paths are: %s)", configuration.getAllUserLabelsDirectories()));
            }
            configurationModel.addUserLabelsPath(this.getFileModel(graphContext, path));
        }
    }

    private void addUserRulesDirsToConfig(WindupConfiguration configuration, GraphContext graphContext, WindupConfigurationModel configurationModel) {
        for (Path path : configuration.getAllUserRulesDirectories()) {
            System.out.println("Using user rules dir: " + path);
            if (path == null) {
                throw new WindupException(String.format("Null path found (all paths are: %s)", configuration.getAllUserRulesDirectories()));
            }
            configurationModel.addUserRulesPath(this.getFileModel(graphContext, path));
        }
    }

    private void saveSourceAndTargetInformation(GraphRewrite event, WindupConfiguration configuration, WindupConfigurationModel configurationModel) {
        Collection sources = (Collection)configuration.getOptionMap().get("source");
        Collection targets = (Collection)configuration.getOptionMap().get("target");
        GraphService technologyReferenceService = new GraphService(event.getGraphContext(), TechnologyReferenceModel.class);
        Function<String, TechnologyReferenceModel> createReferenceModel = techID -> {
            TechnologyReference reference = TechnologyReference.parseFromIDAndVersion((String)techID);
            TechnologyReferenceModel technologyReferenceModel = (TechnologyReferenceModel)technologyReferenceService.create();
            technologyReferenceModel.setTechnologyID(reference.getId());
            technologyReferenceModel.setVersionRange(reference.getVersionRangeAsString());
            return technologyReferenceModel;
        };
        Optional.ofNullable(sources).ifPresent(ss -> ss.forEach(sId -> configurationModel.addSourceTechnology((TechnologyReferenceModel)createReferenceModel.apply((String)sId))));
        Optional.ofNullable(targets).ifPresent(ts -> ts.forEach(tId -> configurationModel.addTargetTechnology((TechnologyReferenceModel)createReferenceModel.apply((String)tId))));
    }

    private RuleLoaderContext configureRuleProviderAndTagFilters(RuleLoaderContext ruleLoaderContext, WindupConfiguration config) {
        NotPredicate skipReportsProviderFilter;
        Collection includeTags = (Collection)config.getOptionMap().get("includeTags");
        Collection excludeTags = (Collection)config.getOptionMap().get("excludeTags");
        Collection sources = (Collection)config.getOptionMap().get("source");
        Collection targets = (Collection)config.getOptionMap().get("target");
        if (includeTags != null && includeTags.isEmpty()) {
            includeTags = null;
        }
        if (excludeTags != null && excludeTags.isEmpty()) {
            excludeTags = null;
        }
        if (sources != null && sources.isEmpty()) {
            sources = null;
        }
        if (targets != null && targets.isEmpty()) {
            targets = null;
        }
        if (includeTags != null || excludeTags != null || sources != null || targets != null) {
            Predicate configuredPredicate = config.getRuleProviderFilter();
            TaggedRuleProviderPredicate tagPredicate = new TaggedRuleProviderPredicate(includeTags, excludeTags);
            Function<String, Set<String>> translateTechAliasFn = WindupProcessorImpl.translateTechnologyAliasFn(ruleLoaderContext);
            sources = Optional.ofNullable(sources).map(ss -> ss.stream().map(translateTechAliasFn).flatMap(Collection::stream).collect(Collectors.toSet())).orElse(null);
            targets = Optional.ofNullable(targets).map(ts -> ts.stream().map(translateTechAliasFn).flatMap(Collection::stream).collect(Collectors.toSet())).orElse(null);
            config.setOptionValue("source", (Object)sources);
            config.setOptionValue("target", (Object)targets);
            SourceAndTargetPredicate sourceAndTargetPredicate = new SourceAndTargetPredicate(sources, targets);
            AndPredicate providerFilter = new AndPredicate(new Predicate[]{tagPredicate, sourceAndTargetPredicate});
            if (configuredPredicate != null) {
                providerFilter = new AndPredicate(new Predicate[]{configuredPredicate, tagPredicate, sourceAndTargetPredicate});
            }
            LOG.info("RuleProvider filter: " + (Predicate)providerFilter);
            config.setRuleProviderFilter((Predicate)providerFilter);
        }
        Boolean skipReports = false;
        if (config.getOptionMap().containsKey("skipReports")) {
            skipReports = (Boolean)config.getOptionMap().get("skipReports");
        }
        if (skipReports.booleanValue()) {
            skipReportsProviderFilter = new NotPredicate((Predicate)new RuleProviderPhasePredicate(new Class[]{PreReportGenerationPhase.class, ReportGenerationPhase.class, ReportRenderingPhase.class, PostReportGenerationPhase.class, PostReportRenderingPhase.class, PreReportPfRenderingPhase.class, ReportPfRenderingPhase.class, PostReportPfRenderingPhase.class}));
        } else {
            Boolean legacyReports = false;
            if (config.getOptionMap().containsKey("legacyReports")) {
                legacyReports = (Boolean)config.getOptionMap().get("legacyReports");
            }
            skipReportsProviderFilter = legacyReports != false ? new NotPredicate((Predicate)new RuleProviderPhasePredicate(new Class[]{PreReportPfRenderingPhase.class, ReportPfRenderingPhase.class, PostReportPfRenderingPhase.class})) : new NotPredicate((Predicate)new RuleProviderPhasePredicate(new Class[]{ReportRenderingPhase.class, PostReportRenderingPhase.class}));
        }
        Predicate configuredProvider = config.getRuleProviderFilter();
        AndPredicate providerFilter = new AndPredicate(new Predicate[]{skipReportsProviderFilter});
        if (configuredProvider != null) {
            providerFilter = new AndPredicate(new Predicate[]{configuredProvider, skipReportsProviderFilter});
        }
        config.setRuleProviderFilter((Predicate)providerFilter);
        LOG.info("Adding RuleProvider filter for skipping reports: " + (Predicate)providerFilter);
        return new RuleLoaderContext(ruleLoaderContext.getContext(), ruleLoaderContext.getRulePaths(), config.getRuleProviderFilter());
    }

    private static Function<String, Set<String>> translateTechnologyAliasFn(RuleLoaderContext ruleLoaderContext) {
        List translators = TechnologyReferenceAliasTranslator.getAliasTranslators((RuleLoaderContext)ruleLoaderContext);
        Map<String, List> translatorMap = translators.stream().collect(Collectors.toMap(transformer -> transformer.getOriginalTechnology().getId(), transformer -> {
            ArrayList<TechnologyReferenceAliasTranslator> list = new ArrayList<TechnologyReferenceAliasTranslator>();
            list.add((TechnologyReferenceAliasTranslator)transformer);
            return list;
        }, (old, latest) -> {
            old.addAll(latest);
            return old;
        }));
        return sourceTechIdAndVersion -> {
            HashSet<String> result = new HashSet<String>();
            if (translatorMap.containsKey(sourceTechIdAndVersion)) {
                String id = TechnologyReference.parseFromIDAndVersion((String)sourceTechIdAndVersion).getId();
                for (TechnologyReferenceAliasTranslator translator : (List)translatorMap.get(id)) {
                    result.add(translator.translate(sourceTechIdAndVersion).toString());
                }
            } else {
                result.add((String)sourceTechIdAndVersion);
            }
            return result;
        };
    }

    private FileModel getFileModel(GraphContext context, Path file) {
        return new FileService(context).createByFilePath(file.toString());
    }

    private EvaluationContext createEvaluationContext() {
        DefaultEvaluationContext evaluationContext = new DefaultEvaluationContext();
        DefaultParameterValueStore values = new DefaultParameterValueStore();
        evaluationContext.put(ParameterValueStore.class, (Object)values);
        return evaluationContext;
    }

    private void validateConfig(WindupConfiguration windupConfiguration) {
        Assert.notNull((Object)windupConfiguration, (String)(ThemeProvider.getInstance().getTheme().getBrandNameAcronym() + " configuration must not be null. (Call default execution if no configuration is required.)"));
        Collection inputPaths = windupConfiguration.getInputPaths();
        Assert.notNull((Object)inputPaths, (String)"Path to the application must not be null!");
        for (Path inputPath : inputPaths) {
            Assert.notNull((Object)inputPath, (String)"Path to the application must not be null!");
            Checks.checkFileOrDirectoryToBeRead((File)inputPath.toFile(), (String)"Application");
        }
        Path outputDirectory = windupConfiguration.getOutputDirectory();
        Assert.notNull((Object)outputDirectory, (String)"Output directory must not be null!");
        Checks.checkDirectoryToBeFilled((File)outputDirectory.toFile(), (String)"Output directory");
    }

    private void printConfigInfo(WindupConfiguration windupConfiguration) {
        LOG.info("");
        if (windupConfiguration.getInputPaths().size() == 1) {
            LOG.info("Input Application:" + windupConfiguration.getInputPaths().iterator().next());
        } else {
            LOG.info("Input Applications:");
            for (Path path : windupConfiguration.getInputPaths()) {
                LOG.info("\t" + path);
            }
            LOG.info("");
        }
        LOG.info("Output Path:" + windupConfiguration.getOutputDirectory());
        LOG.info("");
        for (Map.Entry entry : windupConfiguration.getOptionMap().entrySet()) {
            LOG.info("\t" + (String)entry.getKey() + ": " + entry.getValue());
        }
    }
}

