/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.core.VerifyArgument;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class WindupClasspathTypeLoader
implements ITypeLoader {
    private static final Logger LOG = Logger.getLogger(WindupClasspathTypeLoader.class.getSimpleName());
    private final URLClassLoader urlClassLoader;

    public WindupClasspathTypeLoader(String classPath) {
        String[] parts = ((String)VerifyArgument.notNull((Object)classPath, (String)"classPath")).split(Pattern.quote(System.getProperty("path.separator")));
        URL[] urls = (URL[])Arrays.stream(parts).map(path -> {
            try {
                return new File((String)path).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new UndeclaredThrowableException(e);
            }
        }).toArray(URL[]::new);
        this.urlClassLoader = new URLClassLoader(urls);
    }

    public boolean tryLoadType(String internalName, Buffer buffer) {
        boolean bl;
        block12: {
            String path;
            URL resource;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Attempting to load type: " + internalName + "...");
            }
            if ((resource = this.urlClassLoader.getResource(path = internalName.concat(".class"))) == null) {
                return false;
            }
            InputStream stream = this.urlClassLoader.getResourceAsStream(path);
            try {
                int bytesRead;
                byte[] temp = new byte[4096];
                while ((bytesRead = stream.read(temp, 0, temp.length)) > 0) {
                    buffer.ensureWriteableBytes(bytesRead);
                    buffer.putByteArray(temp, 0, bytesRead);
                }
                buffer.flip();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Type loaded from " + resource + ".");
                }
                bl = true;
                if (stream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }
}

