/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.project.condition;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.windup.graph.model.DependencyLocation;
import org.jboss.windup.rules.apps.java.condition.Version;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternParser;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class Artifact
implements Parameterized {
    private RegexParameterizedPatternParser groupId;
    private RegexParameterizedPatternParser artifactId;
    private Version version;
    private Collection<DependencyLocation> locations;

    public static Artifact withVersion(Version v) {
        Artifact artifact = new Artifact();
        artifact.version = v;
        return artifact;
    }

    public static Artifact withGroupId(String groupId) {
        Artifact artifact = new Artifact();
        artifact.groupId = new RegexParameterizedPatternParser(groupId);
        return artifact;
    }

    public static Artifact withArtifactId(String artifactId) {
        Artifact artifact = new Artifact();
        artifact.artifactId = new RegexParameterizedPatternParser(artifactId);
        return artifact;
    }

    public Artifact andVersion(Version version) {
        this.version = version;
        return this;
    }

    public Artifact andArtifactId(String artifactId) {
        this.artifactId = new RegexParameterizedPatternParser(artifactId);
        return this;
    }

    public Artifact andLocations(Collection<DependencyLocation> locations) {
        this.locations = locations;
        return this;
    }

    public ParameterizedPatternParser getGroupId() {
        return this.groupId;
    }

    public ParameterizedPatternParser getArtifactId() {
        return this.artifactId;
    }

    public Version getVersion() {
        return this.version;
    }

    public Collection<DependencyLocation> getLocations() {
        return this.locations;
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.groupId != null) {
            result.addAll(this.groupId.getRequiredParameterNames());
        }
        if (this.artifactId != null) {
            result.addAll(this.artifactId.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        if (this.groupId != null) {
            this.groupId.setParameterStore(store);
        }
        if (this.artifactId != null) {
            this.artifactId.setParameterStore(store);
        }
    }
}

