/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva.irgen;

import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.translator.Java2IRTranslator;
import com.ibm.wala.cast.java.translator.jdt.JDT2CAstUtils;
import com.ibm.wala.cast.java.translator.jdt.JDTJava2CAstTranslator;
import com.ibm.wala.cast.java.translator.jdt.JDTTypeDictionary;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.classLoader.BytecodeClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.strings.StringStuff;
import io.tackle.diva.Constants;
import io.tackle.diva.Framework;
import io.tackle.diva.Util;
import io.tackle.diva.irgen.DivaPhantomClass;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class DivaIRGen {
    private static final Logger LOGGER = Logger.getLogger(DivaIRGen.class.getName());
    public static DivaIRGen current;
    public IClassLoader loader;
    public Consumer<IClass> addClass;
    public static final Map<String, String> importsKnownToDiva;
    public static Map<Object, List<Annotation>> annotations;
    public static Map<TypeReference, Map<TypeName, List<TypeName>>> instantiations;
    public Function<String, ITypeBinding> wellKnownType;
    public Map<String, String> imports = new HashMap<String, String>();
    public Map<String, ITypeBinding> phantomTypes;
    public Map<Object, IMethodBinding> phantomMethods;
    public Set<String> knownAsClasses;
    public Set<String> knownAsInterfaces;

    public DivaIRGen(IClassLoader loader, Consumer<IClass> addClass) {
        current = this;
        this.loader = loader;
        this.addClass = addClass;
    }

    public void genIR(IClassHierarchy cha, Map<String, ModuleEntry> sourceMap, String[] stdlibs, String[] jdtDirs, BiFunction<CompilationUnit, String, JDTJava2CAstTranslator<CAstSourcePositionMap.Position>> makeCAstTranslator, Supplier<Java2IRTranslator> makeIRTranslator) {
        TypeReference classRef;
        TypeName t;
        String[] sourceFiles = sourceMap.keySet().toArray(new String[0]);
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setStatementsRecovery(true);
        parser.setEnvironment(stdlibs, jdtDirs, null, true);
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "1.8");
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        parser.setCompilerOptions((Map)options);
        final LinkedHashMap<String, CompilationUnit> units = new LinkedHashMap<String, CompilationUnit>();
        parser.createASTs(sourceFiles, null, new String[0], new FileASTRequestor(){

            public void acceptAST(String source, CompilationUnit unit) {
                units.put(source, unit);
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        this.recoverBindings(parser, units, cha);
        int success = 0;
        int failure = 0;
        for (String source : units.keySet()) {
            CompilationUnit unit = (CompilationUnit)units.get(source);
            try {
                JDTJava2CAstTranslator<CAstSourcePositionMap.Position> jdt2cast = makeCAstTranslator.apply(unit, source);
                Java2IRTranslator java2ir = makeIRTranslator.get();
                java2ir.translate(sourceMap.get(source), jdt2cast.translateToCAst());
                LOGGER.fine("Done wala IR: " + source);
                ++success;
            }
            catch (Throwable e) {
                LOGGER.fine(e.getMessage());
                for (StackTraceElement s : e.getStackTrace()) {
                    LOGGER.fine(s.toString());
                }
                LOGGER.fine("Failed wala IR: " + source + ", reason: " + e.getMessage());
                ++failure;
            }
            if ((success + failure) % 100 != 0) continue;
            LOGGER.info("wala IR: " + (success + failure) + " classes (" + failure + " failed)");
        }
        LOGGER.info("wala IR: " + (success + failure) + " classes (" + failure + " failed)");
        if (this.knownAsClasses != null) {
            for (String klazz : this.knownAsClasses) {
                t = TypeName.string2TypeName((String)StringStuff.deployment2CanonicalTypeString((String)klazz));
                if (this.loader.lookupClass(t) != null) continue;
                classRef = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (TypeName)t);
                this.addClass.accept((IClass)new DivaPhantomClass(classRef, cha));
            }
        }
        if (this.knownAsInterfaces != null) {
            for (String klazz : this.knownAsInterfaces) {
                t = TypeName.string2TypeName((String)StringStuff.deployment2CanonicalTypeString((String)klazz));
                if (this.loader.lookupClass(t) != null) continue;
                classRef = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (TypeName)t);
                this.addClass.accept((IClass)new DivaPhantomClass(classRef, cha, true));
            }
        }
    }

    public static final void loadKnownIntefaces(IClassHierarchy cha) {
        for (String klazz : importsKnownToDiva.values()) {
            TypeName t = TypeName.string2TypeName((String)StringStuff.deployment2CanonicalTypeString((String)klazz));
            IClassLoader loader = cha.getLoader(ClassLoaderReference.Application);
            if (loader.lookupClass(t) != null) continue;
            TypeReference classRef = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (TypeName)t);
            cha.addClass((IClass)new DivaPhantomClass(classRef, cha, true));
        }
    }

    public void recoverBindings(ASTParser parser, Map<String, CompilationUnit> units, final IClassHierarchy cha) {
        CompilationUnit unit;
        for (String source : units.keySet()) {
            unit = units.get(source);
            for (ImportDeclaration imp : unit.imports()) {
                if (imp.isOnDemand() || imp.isStatic()) continue;
                QualifiedName qname = (QualifiedName)imp.getName();
                this.imports.put(qname.getName().toString(), qname.toString());
            }
        }
        for (String source : units.keySet()) {
            unit = units.get(source);
            this.wellKnownType = arg_0 -> ((AST)unit.getAST()).resolveWellKnownType(arg_0);
            unit.accept(new ASTVisitor(){

                public boolean visit(MethodInvocation node) {
                    IMethodBinding binding = node.resolveMethodBinding();
                    if (binding == null) {
                        binding = DivaIRGen.this.findOrCreatePhantomMethod((ASTNode)node);
                    }
                    return true;
                }

                public boolean visit(SuperMethodInvocation node) {
                    IMethodBinding binding = node.resolveMethodBinding();
                    if (binding == null) {
                        binding = DivaIRGen.this.findOrCreatePhantomMethod((ASTNode)node);
                    }
                    return true;
                }

                public boolean visit(SuperConstructorInvocation node) {
                    IMethodBinding binding = node.resolveConstructorBinding();
                    if (binding == null || binding.getParameterTypes().length != node.arguments().size()) {
                        binding = DivaIRGen.this.findOrCreatePhantomMethod((ASTNode)node);
                    }
                    return true;
                }

                public boolean visit(ClassInstanceCreation node) {
                    IMethodBinding binding = node.resolveConstructorBinding();
                    if (binding == null) {
                        binding = DivaIRGen.this.findOrCreatePhantomMethod((ASTNode)node);
                    }
                    if (DivaIRGen.this.knownAsClasses == null) {
                        DivaIRGen.this.knownAsClasses = new HashSet<String>();
                    }
                    String name = binding.getDeclaringClass().getBinaryName();
                    DivaIRGen.this.knownAsClasses.add(name);
                    return true;
                }

                public boolean visit(TryStatement node) {
                    List resources = node.resources();
                    if (resources == null || resources.isEmpty()) {
                        return true;
                    }
                    for (Expression exp : resources) {
                        ITypeBinding klazz;
                        if (!(exp instanceof VariableDeclarationExpression) || (klazz = ((VariableDeclarationExpression)exp).getType().resolveBinding()) == null || !klazz.isRecovered()) continue;
                        DivaIRGen.this.findOrCreateCloseable(klazz);
                    }
                    return super.visit(node);
                }

                public boolean visit(TypeDeclaration node) {
                    ITypeBinding t = node.resolveBinding();
                    if (t == null) {
                        return false;
                    }
                    Type sup = node.getSuperclassType();
                    if (sup != null) {
                        String superName = sup.resolveBinding().getBinaryName();
                        if (DivaIRGen.this.knownAsClasses == null) {
                            DivaIRGen.this.knownAsClasses = new HashSet<String>();
                        }
                        DivaIRGen.this.knownAsClasses.add(superName);
                    }
                    TypeReference tref = null;
                    if (t != null) {
                        tref = TypeReference.findOrCreate((ClassLoaderReference)DivaIRGen.this.loader.getReference(), (String)StringStuff.deployment2CanonicalTypeString((String)t.getBinaryName()));
                    }
                    List ifaces = node.superInterfaceTypes();
                    for (Type i : ifaces) {
                        if (i.resolveBinding() == null) continue;
                        String ifaceName = i.resolveBinding().getBinaryName();
                        if (DivaIRGen.this.knownAsInterfaces == null) {
                            DivaIRGen.this.knownAsInterfaces = new HashSet<String>();
                        }
                        DivaIRGen.this.knownAsInterfaces.add(ifaceName);
                        if (tref == null || !i.isParameterizedType()) continue;
                        ParameterizedType pt = (ParameterizedType)i;
                        for (Type p : pt.typeArguments()) {
                            LinkedHashMap<TypeName, ArrayList<TypeName>> map = instantiations.getOrDefault(tref, null);
                            if (map == null) {
                                map = new LinkedHashMap<TypeName, ArrayList<TypeName>>();
                                instantiations.put(tref, map);
                            }
                            String pname = StringStuff.deployment2CanonicalTypeString((String)p.resolveBinding().getBinaryName());
                            String iname = StringStuff.deployment2CanonicalTypeString((String)ifaceName);
                            ArrayList<TypeName> list = map.getOrDefault(TypeName.findOrCreate((String)iname), null);
                            if (list == null) {
                                list = new ArrayList<TypeName>();
                                map.put(TypeName.findOrCreate((String)iname), list);
                            }
                            list.add(TypeName.findOrCreate((String)pname));
                        }
                    }
                    if (tref != null) {
                        DivaIRGen.this.processAnnotations(cha, tref, (BodyDeclaration)node);
                    }
                    return true;
                }

                public boolean visit(AnonymousClassDeclaration node) {
                    ITypeBinding t = node.resolveBinding();
                    if (t == null) {
                        return false;
                    }
                    ITypeBinding sup = t.getSuperclass();
                    if (sup != null) {
                        String superName = sup.getBinaryName();
                        if (DivaIRGen.this.knownAsClasses == null) {
                            DivaIRGen.this.knownAsClasses = new HashSet<String>();
                        }
                        DivaIRGen.this.knownAsClasses.add(superName);
                    }
                    return true;
                }

                public boolean visit(MethodDeclaration node) {
                    IMethodBinding binding = node.resolveBinding();
                    if (binding != null && !binding.getDeclaringClass().isAnonymous()) {
                        String mname = binding.isConstructor() ? "<init>" : binding.getName();
                        TypeReference tref = TypeReference.findOrCreate((ClassLoaderReference)DivaIRGen.this.loader.getReference(), (String)StringStuff.deployment2CanonicalTypeString((String)binding.getDeclaringClass().getBinaryName()));
                        MethodReference mref = MethodReference.findOrCreate((TypeReference)tref, (Selector)Selector.make((String)DivaIRGen.methodSignatureAux(mname, binding.getParameterTypes(), binding.getReturnType())));
                        DivaIRGen.this.processAnnotations(cha, mref, (BodyDeclaration)node);
                        int k = 0;
                        for (SingleVariableDeclaration var : node.parameters()) {
                            DivaIRGen.this.processAnnotations(cha, (Pair<MethodReference, Integer>)Pair.make((Object)mref, (Object)k++), var);
                        }
                    }
                    return true;
                }

                public boolean visit(FieldDeclaration node) {
                    ASTNode enclosing = node.getParent();
                    if (enclosing instanceof TypeDeclaration) {
                        ITypeBinding klazz = ((TypeDeclaration)enclosing).resolveBinding();
                        if (klazz == null) {
                            return true;
                        }
                        VariableDeclarationFragment vdecl = (VariableDeclarationFragment)node.fragments().get(0);
                        TypeReference tref = TypeReference.findOrCreate((ClassLoaderReference)DivaIRGen.this.loader.getReference(), (String)StringStuff.deployment2CanonicalTypeString((String)klazz.getBinaryName()));
                        Pair fref = Pair.make((Object)tref, (Object)Atom.findOrCreateUnicodeAtom((String)vdecl.getName().toString()));
                        DivaIRGen.this.processAnnotations(cha, fref, (BodyDeclaration)node);
                    }
                    return true;
                }
            });
            LOGGER.fine("Done binding: " + source);
        }
    }

    public static void init() {
        annotations = new LinkedHashMap<Object, List<Annotation>>();
        instantiations = new LinkedHashMap<TypeReference, Map<TypeName, List<TypeName>>>();
    }

    public void processAnnotations(IClassHierarchy cha, Object ref, BodyDeclaration node) {
        for (ASTNode prop : node.modifiers()) {
            if (!(prop instanceof org.eclipse.jdt.core.dom.Annotation)) continue;
            this.processAnnotationsAux(cha, ref, (org.eclipse.jdt.core.dom.Annotation)prop);
        }
    }

    public void processAnnotations(IClassHierarchy cha, Pair<MethodReference, Integer> ref, SingleVariableDeclaration node) {
        for (ASTNode prop : node.modifiers()) {
            if (!(prop instanceof org.eclipse.jdt.core.dom.Annotation)) continue;
            this.processAnnotationsAux(cha, ref, (org.eclipse.jdt.core.dom.Annotation)prop);
        }
    }

    public void processAnnotationsAux(IClassHierarchy cha, Object ref, org.eclipse.jdt.core.dom.Annotation annot) {
        IClass c;
        IAnnotationBinding annotBinding = annot.resolveAnnotationBinding();
        ITypeBinding binding = annotBinding == null ? this.findOrCreatePhantomType(annot.getTypeName().getFullyQualifiedName()) : annotBinding.getAnnotationType();
        String annotType = StringStuff.deployment2CanonicalTypeString((String)binding.getBinaryName().toString());
        LinkedHashMap<String, AnnotationsReader.ElementValue> namedParams = new LinkedHashMap<String, AnnotationsReader.ElementValue>();
        if (annot instanceof NormalAnnotation) {
            NormalAnnotation a1 = (NormalAnnotation)annot;
            for (MemberValuePair kv : a1.values()) {
                namedParams.put(kv.getName().toString(), this.processAnnotationAux(kv.getValue()));
            }
        } else if (annot instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation a2 = (SingleMemberAnnotation)annot;
            namedParams.put("value", this.processAnnotationAux(a2.getValue()));
        }
        TypeReference t1 = (c = cha.getLoader(ClassLoaderReference.Extension).lookupClass(TypeName.findOrCreate((String)annotType))) != null ? c.getReference() : TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (String)annotType);
        Annotation a = Annotation.makeWithNamed((TypeReference)t1, namedParams);
        if (!annotations.containsKey(ref)) {
            annotations.put(ref, new ArrayList());
        }
        annotations.get(ref).add(a);
    }

    public AnnotationsReader.ElementValue processAnnotationAux(Expression e) {
        AnnotationsReader.ConstantElementValue ev = null;
        if (e instanceof ArrayInitializer) {
            ArrayInitializer i = (ArrayInitializer)e;
            AnnotationsReader.ElementValue[] vs = new AnnotationsReader.ElementValue[i.expressions().size()];
            int k = 0;
            for (Expression e2 : i.expressions()) {
                vs[k++] = this.processAnnotationAux(e2);
            }
            ev = new AnnotationsReader.ArrayElementValue(vs);
        } else {
            Object v = e.resolveConstantExpressionValue();
            ev = new AnnotationsReader.ConstantElementValue(v);
        }
        return ev;
    }

    public static Map<String, Class<?>> advices() {
        return new HashMap<String, Class<?>>(){
            {
                this.put("org.eclipse.jdt.core.dom.MethodInvocation.resolveMethodBinding", DoMethodBinding.class);
                this.put("org.eclipse.jdt.core.dom.SuperMethodInvocation.resolveMethodBinding", DoSuperMethodBinding.class);
                this.put("org.eclipse.jdt.core.dom.SuperConstructorInvocation.resolveConstructorBinding", DoSuperConstructorBinding.class);
                this.put("org.eclipse.jdt.core.dom.ClassInstanceCreation.resolveConstructorBinding", DoClassInstanceCreationBinding.class);
                this.put("org.eclipse.jdt.core.dom.Name.resolveBinding", DoName.class);
                this.put("org.eclipse.jdt.core.dom.Type.resolveBinding", DoType.class);
                this.put("org.eclipse.jdt.core.dom.VariableBinding.getType", DoVariableBinding.class);
                this.put("org.eclipse.jdt.core.dom.Expression.resolveTypeBinding", DoExpressionTypeBinding.class);
                this.put("org.eclipse.jdt.core.dom.TypeBinding.getSuperclass", DoGetSuperClass.class);
                this.put("org.eclipse.jdt.core.dom.TypeBinding$LocalTypeBinding.getBinaryName", DoLocalTypeBinding.class);
                this.put("org.eclipse.jdt.core.dom.MethodBinding.overrides", DoOverrides.class);
                this.put("org.eclipse.jdt.core.dom.MethodBinding.getParameterTypes", DoGetParameterTypes.class);
                this.put("org.eclipse.jdt.core.dom.DefaultBindingResolver.getTypeBinding", DoGetTypeBinding.class);
                this.put("org.eclipse.jdt.core.dom.RecoveredTypeBinding.getBinaryName", DoRecoveredBinaryName.class);
                this.put("com.ibm.wala.shrikeCT.ClassReader.<init>", DoShrikeCTParse.class);
                this.put("com.ibm.wala.cast.java.translator.jdt.JDTJava2CAstTranslator.visitNode", DoJDT2CastVisitNode.class);
                this.put("com.ibm.wala.cast.java.translator.jdt.JDTTypeDictionary.getCAstTypeFor", DoGetCAstTypeFor.class);
                this.put("com.ibm.wala.cast.java.translator.jdt.JDTIdentityMapper.typeToTypeID", DoTypeToTypeId.class);
                this.put("com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl$JavaClass.getSuperclass", DoSourceLoaderClassSuperclass.class);
                this.put("com.ibm.wala.classLoader.BytecodeClass.getSuperclass", DoBytecodeClassSuperclass.class);
                this.put("com.ibm.wala.ipa.callgraph.cha.CHACallGraph.isRelevantMethod", DoCHACallGraph.class);
                this.put("com.ibm.wala.classLoader.BytecodeClass.array2IClassSet", DoBytecodeClassArray2IClassSet.class);
                this.put("com.ibm.wala.cast.ir.ssa.AbstractSSAConversion.top", DoAbstractSSAConversionTop.class);
            }
        };
    }

    public ITypeBinding findOrCreateUnknownPhantomType(ITypeBinding b) {
        if (b.isParameterizedType()) {
            b = b.getErasure();
        }
        if (b.getName().contains(".")) {
            return this.findOrCreatePhantomType(b.getName());
        }
        if (b.getBinaryName() != null && b.getBinaryName().contains(".")) {
            return this.findOrCreatePhantomType(b.getBinaryName());
        }
        return this.findOrCreateUnknownPhantomType(b.getName());
    }

    public ITypeBinding findOrCreateUnknownPhantomType(String name) {
        String suffix = "";
        if (name.endsWith("[]")) {
            suffix = name.substring(name.indexOf(91));
            name = name.substring(0, name.indexOf(91));
        }
        if (this.imports.containsKey(name)) {
            return this.findOrCreatePhantomType(this.imports.get(name) + suffix);
        }
        if (importsKnownToDiva.containsKey(name)) {
            return this.findOrCreatePhantomType(importsKnownToDiva.get(name) + suffix);
        }
        return this.findOrCreatePhantomType("unknown." + name + suffix);
    }

    public ITypeBinding findOrCreatePhantomType(String name) {
        if (this.phantomTypes == null) {
            this.phantomTypes = new HashMap<String, ITypeBinding>();
        }
        if (this.phantomTypes.containsKey(name)) {
            return this.phantomTypes.get(name);
        }
        final ITypeBinding[] emptyTypes = new ITypeBinding[]{};
        final String key = "PHANTOM:" + StringStuff.deployment2CanonicalTypeString((String)name);
        if (name.endsWith("[]")) {
            String suffix = name.substring(name.indexOf(91));
            name = suffix.replace("]", "") + "L" + name.substring(0, name.indexOf(91)) + ";";
        }
        final String theName = name;
        final Object[] lazyData = new Object[2];
        ITypeBinding binding = new ITypeBinding(){

            public IAnnotationBinding[] getAnnotations() {
                return null;
            }

            public int getKind() {
                return 2;
            }

            public boolean isDeprecated() {
                return false;
            }

            public boolean isRecovered() {
                return true;
            }

            public boolean isSynthetic() {
                return false;
            }

            public IJavaElement getJavaElement() {
                return null;
            }

            public String getKey() {
                return key;
            }

            public boolean isEqualTo(IBinding binding) {
                return false;
            }

            public ITypeBinding createArrayType(int dimension) {
                return null;
            }

            public String getBinaryName() {
                return theName;
            }

            public ITypeBinding getBound() {
                return null;
            }

            public ITypeBinding getGenericTypeOfWildcardType() {
                return null;
            }

            public int getRank() {
                return 0;
            }

            public ITypeBinding getComponentType() {
                if (theName.charAt(0) == '[') {
                    return DivaIRGen.this.findOrCreatePhantomType(theName.substring(1));
                }
                return null;
            }

            public IVariableBinding[] getDeclaredFields() {
                return null;
            }

            public IMethodBinding[] getDeclaredMethods() {
                if (lazyData[0] == null) {
                    ArrayList<IMethodBinding> list = new ArrayList<IMethodBinding>();
                    for (IMethodBinding binding : DivaIRGen.this.phantomMethods.values()) {
                        if (binding.getDeclaringClass() != this) continue;
                        list.add(binding);
                    }
                    lazyData[0] = list.toArray(new IMethodBinding[list.size()]);
                }
                return (IMethodBinding[])lazyData[0];
            }

            public int getDeclaredModifiers() {
                return 0;
            }

            public ITypeBinding[] getDeclaredTypes() {
                return emptyTypes;
            }

            public ITypeBinding getDeclaringClass() {
                return null;
            }

            public IMethodBinding getDeclaringMethod() {
                return null;
            }

            public IBinding getDeclaringMember() {
                return null;
            }

            public int getDimensions() {
                return 0;
            }

            public ITypeBinding getElementType() {
                return null;
            }

            public ITypeBinding getErasure() {
                return (ITypeBinding)lazyData[1];
            }

            public IMethodBinding getFunctionalInterfaceMethod() {
                return null;
            }

            public ITypeBinding[] getInterfaces() {
                return emptyTypes;
            }

            public int getModifiers() {
                return 0;
            }

            public String getName() {
                return theName;
            }

            public IPackageBinding getPackage() {
                return null;
            }

            public String getQualifiedName() {
                return null;
            }

            public ITypeBinding getSuperclass() {
                return null;
            }

            public IAnnotationBinding[] getTypeAnnotations() {
                return null;
            }

            public ITypeBinding[] getTypeArguments() {
                return emptyTypes;
            }

            public ITypeBinding[] getTypeBounds() {
                return emptyTypes;
            }

            public ITypeBinding getTypeDeclaration() {
                return (ITypeBinding)lazyData[1];
            }

            public ITypeBinding[] getTypeParameters() {
                return null;
            }

            public ITypeBinding getWildcard() {
                return null;
            }

            public boolean isAnnotation() {
                return false;
            }

            public boolean isAnonymous() {
                return false;
            }

            public boolean isArray() {
                return theName.startsWith("[");
            }

            public boolean isAssignmentCompatible(ITypeBinding variableType) {
                return false;
            }

            public boolean isCapture() {
                return false;
            }

            public boolean isCastCompatible(ITypeBinding type) {
                return true;
            }

            public boolean isClass() {
                return DivaIRGen.this.knownAsClasses.contains(theName);
            }

            public boolean isEnum() {
                return false;
            }

            public boolean isFromSource() {
                return false;
            }

            public boolean isGenericType() {
                return false;
            }

            public boolean isInterface() {
                return !DivaIRGen.this.knownAsClasses.contains(theName);
            }

            public boolean isIntersectionType() {
                return false;
            }

            public boolean isLocal() {
                return false;
            }

            public boolean isMember() {
                return false;
            }

            public boolean isNested() {
                return false;
            }

            public boolean isNullType() {
                return false;
            }

            public boolean isParameterizedType() {
                return false;
            }

            public boolean isPrimitive() {
                return false;
            }

            public boolean isRawType() {
                return false;
            }

            public boolean isSubTypeCompatible(ITypeBinding type) {
                return true;
            }

            public boolean isTopLevel() {
                return false;
            }

            public boolean isTypeVariable() {
                return false;
            }

            public boolean isUpperbound() {
                return false;
            }

            public boolean isWildcardType() {
                return false;
            }
        };
        lazyData[1] = binding;
        this.phantomTypes.put(theName, binding);
        return binding;
    }

    public ITypeBinding findOrCreateType(Expression exp) {
        return this.findOrCreateType(exp, true);
    }

    public static boolean isBroken(ITypeBinding type) {
        return type.isRecovered() && !type.getKey().startsWith("PHANTOM:");
    }

    public ITypeBinding findOrCreateType(Expression exp, boolean resolve) {
        ITypeBinding expType;
        if (exp == null) {
            return this.findOrCreatePhantomType("unknown.Unknown");
        }
        ITypeBinding iTypeBinding = expType = resolve ? exp.resolveTypeBinding() : null;
        if (expType == null) {
            if (exp instanceof SimpleName) {
                return this.findOrCreateUnknownPhantomType(exp.toString());
            }
        } else {
            if (DivaIRGen.isBroken(expType)) {
                return this.findOrCreateUnknownPhantomType(expType);
            }
            return expType;
        }
        return this.findOrCreatePhantomType("unknown.Unknown");
    }

    public IMethodBinding findOrCreatePhantomMethod(ASTNode node) {
        ITypeBinding returnType;
        MethodInvocation method;
        if (this.phantomMethods == null) {
            this.phantomMethods = new IdentityHashMap<Object, IMethodBinding>();
        }
        if (this.phantomMethods.containsKey(node)) {
            return this.phantomMethods.get(node);
        }
        Expression exp = null;
        List arguments = null;
        ITypeBinding klazz = null;
        String name = null;
        boolean isCtor = false;
        if (node instanceof MethodInvocation) {
            method = (MethodInvocation)node;
            name = method.getName().toString();
            exp = method.getExpression();
            arguments = method.arguments();
            klazz = this.findOrCreateType(exp);
        } else if (node instanceof SuperMethodInvocation) {
            method = (SuperMethodInvocation)node;
            name = method.getName().toString();
            arguments = method.arguments();
            klazz = this.findOrCreatePhantomType("unknown.Unknown");
        } else if (node instanceof SuperConstructorInvocation) {
            method = (SuperConstructorInvocation)node;
            name = "<init>";
            arguments = method.arguments();
            klazz = this.findOrCreatePhantomType("unknown.Unknown");
            isCtor = true;
        } else if (node instanceof ClassInstanceCreation) {
            method = (ClassInstanceCreation)node;
            name = "<init>";
            arguments = method.arguments();
            isCtor = true;
            Type type = method.getType();
            if (type.isParameterizedType()) {
                type = ((ParameterizedType)type).getType();
            }
            klazz = type.resolveBinding();
            if (type instanceof SimpleType && (klazz == null || klazz.isRecovered())) {
                klazz = this.findOrCreateUnknownPhantomType(((SimpleType)type).getName().toString());
            }
        }
        ArrayList<ITypeBinding> list = new ArrayList<ITypeBinding>();
        for (Expression arg : arguments) {
            list.add(this.findOrCreateType(arg));
        }
        ITypeBinding[] params = list.toArray(new ITypeBinding[list.size()]);
        ITypeBinding iTypeBinding = returnType = isCtor ? klazz : ((Expression)node).resolveTypeBinding();
        if (returnType == null) {
            returnType = this.findOrCreatePhantomType("unknown.Unknown");
        }
        IMethodBinding binding = !isCtor || arguments.size() > 0 ? this.findOrCreatePhantomMethod0(klazz, name, params, returnType, isCtor) : this.findOrCreateDefaultCtor(klazz);
        this.phantomMethods.put(node, binding);
        return binding;
    }

    public IMethodBinding findOrCreateDefaultCtor(ITypeBinding klazz) {
        String key;
        if (this.phantomMethods == null) {
            this.phantomMethods = new IdentityHashMap<Object, IMethodBinding>();
        }
        if (this.phantomMethods.containsKey(key = (klazz.getName() + ".<init>()").intern())) {
            return this.phantomMethods.get(key);
        }
        IMethodBinding binding = this.findOrCreatePhantomMethod0(klazz, "<init>", new ITypeBinding[0], klazz, true);
        this.phantomMethods.put(key, binding);
        return binding;
    }

    public IMethodBinding findOrCreateCloseable(ITypeBinding klazz) {
        String key;
        if (this.phantomMethods == null) {
            this.phantomMethods = new IdentityHashMap<Object, IMethodBinding>();
        }
        if (this.phantomMethods.containsKey(key = (klazz.getName() + ".close()").intern())) {
            return this.phantomMethods.get(key);
        }
        IMethodBinding binding = this.findOrCreatePhantomMethod0(klazz, "close", new ITypeBinding[0], this.wellKnownType.apply("void"), true);
        this.phantomMethods.put(key, binding);
        return binding;
    }

    public IMethodBinding findOrCreatePhantomMethod0(final ITypeBinding klazz, final String name, final ITypeBinding[] params, final ITypeBinding returnType, final boolean isCtor) {
        final ITypeBinding[] exceptionTypes = new ITypeBinding[]{};
        final String key = "PHANTOM:" + DivaIRGen.methodSignature(klazz, name, params, returnType);
        final Object[] lazyData = new Object[1];
        IMethodBinding binding = new IMethodBinding(){

            public IAnnotationBinding[] getAnnotations() {
                return null;
            }

            public int getKind() {
                return 4;
            }

            public int getModifiers() {
                return 0;
            }

            public boolean isDeprecated() {
                return false;
            }

            public boolean isRecovered() {
                return true;
            }

            public boolean isSynthetic() {
                return false;
            }

            public IJavaElement getJavaElement() {
                return null;
            }

            public String getKey() {
                return key;
            }

            public boolean isEqualTo(IBinding binding) {
                return false;
            }

            public boolean isConstructor() {
                return isCtor;
            }

            public boolean isDefaultConstructor() {
                return false;
            }

            public String getName() {
                return name;
            }

            public ITypeBinding getDeclaringClass() {
                return klazz;
            }

            public IBinding getDeclaringMember() {
                return klazz;
            }

            public Object getDefaultValue() {
                return null;
            }

            public IAnnotationBinding[] getParameterAnnotations(int paramIndex) {
                return null;
            }

            public ITypeBinding[] getParameterTypes() {
                return params;
            }

            public ITypeBinding getDeclaredReceiverType() {
                return klazz;
            }

            public ITypeBinding getReturnType() {
                return returnType;
            }

            public ITypeBinding[] getExceptionTypes() {
                return exceptionTypes;
            }

            public ITypeBinding[] getTypeParameters() {
                return null;
            }

            public boolean isAnnotationMember() {
                return false;
            }

            public boolean isGenericMethod() {
                return false;
            }

            public boolean isParameterizedMethod() {
                return false;
            }

            public ITypeBinding[] getTypeArguments() {
                return params;
            }

            public IMethodBinding getMethodDeclaration() {
                return (IMethodBinding)lazyData[0];
            }

            public boolean isRawMethod() {
                return false;
            }

            public boolean isSubsignature(IMethodBinding otherMethod) {
                return false;
            }

            public boolean isVarargs() {
                return false;
            }

            public boolean overrides(IMethodBinding method) {
                return false;
            }

            public IVariableBinding[] getSyntheticOuterLocals() {
                return null;
            }
        };
        lazyData[0] = binding;
        return binding;
    }

    public static String methodSignature(ITypeBinding klazz, String name, ITypeBinding[] params, ITypeBinding returnType) {
        String k = StringStuff.deployment2CanonicalTypeString((String)klazz.getBinaryName());
        k = k + " " + DivaIRGen.methodSignatureAux(name, params, returnType);
        return k;
    }

    public static String methodSignatureAux(String name, ITypeBinding[] params, ITypeBinding returnType) {
        String k = name + "(";
        for (ITypeBinding p : params) {
            k = k + DivaIRGen.canonicalTypeString(p);
        }
        k = k + ")" + DivaIRGen.canonicalTypeString(returnType);
        return k;
    }

    public static String canonicalTypeString(ITypeBinding p) {
        if ((p = p.getErasure()).isPrimitive()) {
            return p.getBinaryName();
        }
        if (p.isArray()) {
            return StringStuff.deployment2CanonicalTypeString((String)p.getBinaryName()).substring(1);
        }
        return StringStuff.deployment2CanonicalTypeString((String)p.getBinaryName()) + ";";
    }

    static {
        importsKnownToDiva = new HashMap<String, String>();
        for (Field f : Constants.class.getDeclaredFields()) {
            if (f.getType() != TypeName.class) continue;
            try {
                String t = StringStuff.jvmToBinaryName((String)((TypeName)f.get(null)).toString());
                String name = t.substring(t.toString().lastIndexOf(46) + 1);
                importsKnownToDiva.put(name, t);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    public static class DoAbstractSSAConversionTop {
        @Advice.OnMethodExit(onThrowable=AssertionError.class)
        public static void exit(@Advice.Argument(value=0) int v, @Advice.Thrown(readOnly=false) AssertionError e, @Advice.Return(readOnly=false) int res) {
            if (e != null) {
                res = v;
                e = null;
            }
        }
    }

    public static class DoBytecodeClassArray2IClassSet {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static boolean enter() {
            return true;
        }

        @Advice.OnMethodExit
        public static void exit(@Advice.Enter boolean skip, @Advice.Argument(value=0) ImmutableByteArray[] interfaces, @Advice.FieldValue(value="cha") IClassHierarchy cha, @Advice.FieldValue(value="loader") IClassLoader loader, @Advice.Return(readOnly=false) Collection<IClass> res) {
            ArrayList<IClass> result = new ArrayList<IClass>(interfaces.length);
            for (ImmutableByteArray name : interfaces) {
                Object klass = null;
                TypeName tname = TypeName.findOrCreate((ImmutableByteArray)name);
                klass = loader.lookupClass(tname);
                if (klass == null) {
                    klass = new DivaPhantomClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)tname), cha, true);
                }
                result.add((IClass)klass);
            }
            res = result;
        }
    }

    public static class DoCHACallGraph {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static boolean enter() {
            return Framework.isRelevantMethod != null;
        }

        @Advice.OnMethodExit
        public static void exit(@Advice.Enter boolean skip, @Advice.Argument(value=0) IMethod m, @Advice.Return(readOnly=false) boolean res) {
            if (skip) {
                res = !m.isAbstract() && Framework.isRelevantMethod.test(m);
            }
        }
    }

    public static class DoBytecodeClassSuperclass {
        @Advice.OnMethodExit
        public static void exit(@Advice.This BytecodeClass self, @Advice.FieldValue(value="cha") IClassHierarchy cha, @Advice.FieldValue(value="loader") IClassLoader loader, @Advice.FieldValue(value="superClass", readOnly=false) IClass superClass, @Advice.Return(readOnly=false) IClass res) {
            if (res != null && res.getName() == Constants.LJavaLangObject && self.getSuperName() != Constants.LJavaLangObject) {
                superClass = new DivaPhantomClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (TypeName)self.getSuperName()), cha);
                cha.addClass(superClass);
                res = superClass;
            }
        }
    }

    public static class DoSourceLoaderClassDirectInterfaces {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static boolean enter() {
            return true;
        }

        @Advice.OnMethodExit
        public static void exit(@Advice.FieldValue(value="superTypeNames") Collection<TypeName> superTypeNames, @Advice.FieldValue(value="this$0") JavaSourceLoaderImpl loader, @Advice.Return(readOnly=false) IClass res) {
            ArrayList result = new ArrayList();
            for (TypeName name : superTypeNames) {
                IClass domoType = loader.lookupClass(name);
                if (domoType != null) continue;
            }
        }
    }

    public static class DoSourceLoaderClassSuperclass {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static boolean enter() {
            return true;
        }

        @Advice.OnMethodExit
        public static void exit(@Advice.FieldValue(value="superTypeNames") Collection<TypeName> superTypeNames, @Advice.FieldValue(value="this$0") JavaSourceLoaderImpl loader, @Advice.Return(readOnly=false) IClass res) {
            TypeName name;
            Iterator<TypeName> iterator = superTypeNames.iterator();
            while (iterator.hasNext() && ((res = loader.lookupClass(name = iterator.next())) == null || res.isInterface())) {
            }
            if (res == null || res.isInterface()) {
                res = loader.lookupClass(Constants.LJavaLangObject);
            }
        }
    }

    public static class DoTypeToTypeId {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static boolean enter(@Advice.Argument(value=0) ITypeBinding typ) {
            return typ.isNullType();
        }

        @Advice.OnMethodExit
        public static void exit(@Advice.Enter boolean skip, @Advice.Return(readOnly=false) String res) {
            if (skip) {
                res = "Ljava/lang/Object";
            }
        }
    }

    public static class DoGetCAstTypeFor {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static boolean enter(@Advice.Argument(value=0) Object o) {
            ITypeBinding astType = (ITypeBinding)o;
            return astType.isNullType();
        }

        @Advice.OnMethodExit
        public static void exit(@Advice.Enter boolean skip, @Advice.This JDTTypeDictionary self, @Advice.FieldValue(value="fAst") AST fAst, @Advice.Return(readOnly=false) CAstType res) {
            if (skip) {
                Util.LOGGER.fine("resolving nullType");
                res = self.getCAstTypeFor((Object)fAst.resolveWellKnownType("java.lang.Object"));
            }
        }
    }

    public static class DoJDT2CastVisitNode {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static boolean enter(@Advice.Argument(value=0) ASTNode n) {
            if (n instanceof ExpressionMethodReference) {
                Util.LOGGER.fine(n.toString());
                return true;
            }
            if (n instanceof LambdaExpression) {
                Util.LOGGER.fine(n.toString());
                return true;
            }
            return false;
        }

        @Advice.OnMethodExit
        public static void exit(@Advice.Enter boolean skip, @Advice.FieldValue(value="fFactory") CAst fFactory, @Advice.Return(readOnly=false) CAstNode res) {
            if (skip) {
                Util.LOGGER.fine("replaced with ??");
                res = fFactory.makeConstant((Object)"??");
            }
        }
    }

    public static class DoShrikeCTParse {
        @Advice.OnMethodEnter
        public static void enter(@Advice.Argument(value=0) byte[] bytes) {
            if (bytes[7] > 57) {
                bytes[7] = 57;
            }
        }
    }

    public static class DoRecoveredBinaryName {
        @Advice.OnMethodExit
        public static void exit(@Advice.FieldValue(value="binding") Object binding, @Advice.Return(readOnly=false) String res) {
            String bindingStr = binding.toString();
            if (bindingStr.contains("[closestMatch=[MISSING:")) {
                res = bindingStr.substring(bindingStr.lastIndexOf(58) + 1, bindingStr.length() - 2);
            }
        }
    }

    public static class DoGetTypeBinding {
        @Advice.OnMethodExit
        public static void exit(@Advice.Return(readOnly=false) ITypeBinding binding) {
            if (binding != null && DivaIRGen.isBroken(binding)) {
                binding = current.findOrCreateUnknownPhantomType(binding);
            }
        }
    }

    public static class DoGetParameterTypes {
        @Advice.OnMethodExit
        public static void exit(@Advice.Return(readOnly=true) ITypeBinding[] parameterTypes) {
            for (int k = 0; k < parameterTypes.length; ++k) {
                ITypeBinding binding = parameterTypes[k];
                if (!DivaIRGen.isBroken(binding)) continue;
                parameterTypes[k] = current.findOrCreateUnknownPhantomType(binding);
            }
        }
    }

    public static class DoOverrides {
        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        public static boolean enter(@Advice.Argument(value=0) IMethodBinding other) {
            return !other.getClass().getName().equals("org.eclipse.jdt.core.dom.MethodBinding");
        }

        @Advice.OnMethodExit
        public static void exit(@Advice.Enter boolean skip, @Advice.This(typing=Assigner.Typing.DYNAMIC) IMethodBinding type, @Advice.Argument(value=0) IMethodBinding other, @Advice.Return(readOnly=false) boolean binding) {
            if (skip) {
                binding = type.getName().equals(other.getName()) && JDT2CAstUtils.sameErasedSignatureAndReturnType((IMethodBinding)type, (IMethodBinding)other);
            }
        }
    }

    public static class DoLocalTypeBinding {
        @Advice.OnMethodExit
        public static void exit(@Advice.This(typing=Assigner.Typing.DYNAMIC) ITypeBinding type, @Advice.Return(readOnly=false) String name) {
            if (name == null) {
                String key = type.getKey();
                name = StringStuff.jvmToBinaryName((String)key);
            }
        }
    }

    public static class DoGetSuperClass {
        @Advice.OnMethodExit
        public static void exit(@Advice.This ITypeBinding type, @Advice.Return(readOnly=false) ITypeBinding binding) {
            if (binding != null && binding.isRecovered()) {
                if (DivaIRGen.isBroken(binding)) {
                    binding = current.findOrCreateUnknownPhantomType(binding);
                }
                current.findOrCreateDefaultCtor(binding);
            }
        }
    }

    public static class DoExpressionTypeBinding {
        @Advice.OnMethodExit
        public static void exit(@Advice.This Expression node, @Advice.Return(readOnly=false) ITypeBinding binding) {
            if (binding == null) {
                binding = current.findOrCreateType(node, false);
            }
        }
    }

    public static class DoVariableBinding {
        @Advice.OnMethodExit
        public static void exit(@Advice.Return(readOnly=false) ITypeBinding binding) {
            if (DivaIRGen.isBroken(binding)) {
                binding = current.findOrCreateUnknownPhantomType(binding);
            }
        }
    }

    public static class DoType {
        @Advice.OnMethodExit
        public static void exit(@Advice.This Type node, @Advice.Return(readOnly=false) ITypeBinding binding) {
            if (node instanceof SimpleType && (binding == null || DivaIRGen.isBroken(binding))) {
                binding = current.findOrCreateUnknownPhantomType(((SimpleType)node).getName().toString());
            }
        }
    }

    public static class DoName {
        @Advice.OnMethodExit
        public static void exit(@Advice.This Name node, @Advice.Return(readOnly=false) IBinding binding) {
            String key;
            if (binding == null) {
                binding = current.findOrCreateUnknownPhantomType(node.toString());
            } else if (binding.isRecovered() && (key = binding.getKey()).startsWith("Recovered#typeBindingL")) {
                key = key.substring("Recovered#typeBindingL".length());
                if (Character.isUpperCase((key = key.substring(0, key.lastIndexOf(59))).charAt(0))) {
                    binding = current.findOrCreateUnknownPhantomType(key);
                }
            }
        }
    }

    public static class DoClassInstanceCreationBinding {
        @Advice.OnMethodExit
        public static void exit(@Advice.This ClassInstanceCreation node, @Advice.Return(readOnly=false) IMethodBinding binding) {
            if (binding == null) {
                binding = current.findOrCreatePhantomMethod((ASTNode)node);
            }
        }
    }

    public static class DoSuperConstructorBinding {
        @Advice.OnMethodExit
        public static void exit(@Advice.This SuperConstructorInvocation node, @Advice.Return(readOnly=false) IMethodBinding binding) {
            if (binding == null || binding.getParameterTypes().length != node.arguments().size()) {
                binding = current.findOrCreatePhantomMethod((ASTNode)node);
            }
        }
    }

    public static class DoSuperMethodBinding {
        @Advice.OnMethodExit
        public static void exit(@Advice.This SuperMethodInvocation node, @Advice.Return(readOnly=false) IMethodBinding binding) {
            if (binding == null) {
                binding = current.findOrCreatePhantomMethod((ASTNode)node);
            }
        }
    }

    public static class DoMethodBinding {
        @Advice.OnMethodExit
        public static void exit(@Advice.This MethodInvocation node, @Advice.Return(readOnly=false) IMethodBinding binding) {
            if (binding == null) {
                binding = current.findOrCreatePhantomMethod((ASTNode)node);
            }
        }
    }
}

