/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva.analysis;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import io.tackle.diva.Constants;
import io.tackle.diva.Context;
import io.tackle.diva.Framework;
import io.tackle.diva.Report;
import io.tackle.diva.Trace;
import io.tackle.diva.Util;
import io.tackle.diva.analysis.PointerAnalysis;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class QuarkusAnalysis {
    public static boolean checkRelevance(IClass c) {
        return Util.any(Util.getAnnotations(c), a -> a.getType().getName() == Constants.LMicroprofileReigsterRestClient);
    }

    public static List<IMethod> getEntries(IClassHierarchy cha) throws IOException {
        ArrayList<IMethod> entries = new ArrayList<IMethod>();
        for (IClass c : cha) {
            if (c.isInterface() || !Util.any(Util.getAnnotations(c), a -> a.getType().getName() == Constants.LJavaxWsRsPath)) continue;
            for (IMethod m : c.getDeclaredMethods()) {
                if (!Util.any(Util.getAnnotations(m), a -> a.getType().getName() == Constants.LJavaxWsRsPath)) continue;
                entries.add(m);
            }
        }
        return entries;
    }

    public static Context.CallSiteVisitor getTransactionAnalysis(final Framework fw, Context context) {
        Context context2 = context;
        context2.getClass();
        return new Context.CallSiteVisitor(context2){

            @Override
            public void visitCallSite(Trace trace) {
                CGNode node = trace.node();
                CallSiteReference site = trace.site();
                MethodReference ref = site.getDeclaredTarget();
                TypeReference tref = ref.getDeclaringClass();
                IClass c = fw.classHierarchy().lookupClass(tref);
                if (c != null && Util.any(Util.getAnnotations(c), a -> a.getType().getName() == Constants.LMicroprofileReigsterRestClient)) {
                    IMethod m = c.getMethod(ref.getSelector());
                    String method = null;
                    String path = null;
                    for (Annotation a2 : Util.getAnnotations(m)) {
                        if (a2.getType().getName() == Constants.LJavaxWsRsGET) {
                            method = "GET";
                        } else if (a2.getType().getName() == Constants.LJavaxWsRsPOST) {
                            method = "POST";
                        } else if (a2.getType().getName() == Constants.LJavaxWsRsPATCH) {
                            method = "PATCH";
                        } else if (a2.getType().getName() == Constants.LJavaxWsRsDELETE) {
                            method = "DELETE";
                        }
                        if (a2.getType().getName() != Constants.LJavaxWsRsPath) continue;
                        path = ((AnnotationsReader.ConstantElementValue)a2.getNamedArguments().get((Object)"value")).val.toString();
                    }
                    if (method != null) {
                        String httpMethod = method;
                        String httpPath = path;
                        fw.reportOperation(trace, named -> named.put("rest-call", map -> {
                            map.put("http-method", httpMethod);
                            map.put("url-path", httpPath);
                            map.put("client-class", c.getName().toString());
                            QuarkusAnalysis.restCallParameterAnalysis(fw, m, trace, map);
                        }));
                    }
                }
            }
        };
    }

    public static void restCallParameterAnalysis(Framework fw, IMethod m, Trace trace, Report.Named map) {
        SSAAbstractInvokeInstruction instr = trace.instrFromSite(trace.site());
        int nparam = 0;
        block0: for (int k = 0; k < m.getNumberOfParameters() - 1; ++k) {
            for (Annotation a : Util.getAnnotations(m, k)) {
                Trace.Val v;
                if (a.getType().getName() == Constants.LJavaxWsRsPathParam) {
                    v = trace.getDef(instr.getUse(k + 1));
                    if (v == null || !v.isConstant()) continue block0;
                    map.put("param:" + nparam++, v.constant().toString());
                    continue block0;
                }
                if (a.getType().getName() != Constants.LJavaxWsRsQueryParam) continue;
                v = trace.getDef(instr.getUse(k + 1));
                if (v == null || !v.isConstant()) continue block0;
                map.put(((AnnotationsReader.ElementValue)a.getNamedArguments().get("value")).toString(), v.constant().toString());
                continue block0;
            }
            Trace.Val def = trace.getDef(instr.getUse(k + 1));
            if (def == null || !def.isInstr() || !(def.instr() instanceof SSANewInstruction)) continue;
            TypeReference typ = fw.classHierarchy().lookupClass(((SSANewInstruction)def.instr()).getConcreteType()).getReference();
            Trace trace2 = trace;
            trace2.getClass();
            PointerAnalysis.fromDefUse(fw, def, new Trace.Val(trace2, instr), (t, put) -> {
                Trace.Val v;
                if (put.getDeclaredField().getDeclaringClass() == typ && (v = t.getDef(put.getUse(1))) != null && v.isConstant()) {
                    map.put("json:" + put.getDeclaredField().getName().toString(), v.constant().toString());
                }
            });
        }
    }
}

