/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.strings.StringStuff;
import io.tackle.diva.Framework;
import io.tackle.diva.Report;
import io.tackle.diva.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface Constraint {
    default public void report(Report.Named report) {
        report.put(this.category(), map -> map.put(this.type(), values -> values.add(this.value())));
    }

    public String category();

    public String type();

    public String value();

    public boolean forbids(Constraint var1);

    public static class DispatchConstraint
    implements Constraint {
        IClass base;
        IClass impl;

        public DispatchConstraint(IClass base, IClass impl) {
            this.base = base;
            this.impl = impl;
        }

        @Override
        public String category() {
            return "dispatch";
        }

        @Override
        public String type() {
            return this.base.getName().toString();
        }

        @Override
        public String value() {
            return this.impl.getName().toString();
        }

        @Override
        public boolean forbids(Constraint other) {
            return false;
        }
    }

    public static class EntryConstraint
    implements Constraint {
        CGNode node;

        public EntryConstraint(CGNode node) {
            this.node = node;
        }

        @Override
        public String category() {
            return "entry";
        }

        @Override
        public String type() {
            return "methods";
        }

        @Override
        public String value() {
            IMethod method = this.node.getMethod();
            return StringStuff.jvmToBinaryName((String)method.getDeclaringClass().getName().toString()) + "." + method.getName().toString();
        }

        public CGNode node() {
            return this.node;
        }

        @Override
        public boolean forbids(Constraint other) {
            return other instanceof EntryConstraint;
        }
    }

    public static abstract class BranchingConstraint
    implements Constraint {
        Framework fw;
        public Map<Integer, BitVector> reachingInstrs;

        protected BranchingConstraint(Framework fw) {
            this.fw = fw;
        }

        public abstract Set<IntPair> fallenThruBranches();

        public abstract Set<IntPair> takenBranches();

        public abstract BranchingConstraint defaultConstraint();

        public Map<Integer, BitVector> reachingInstrs() {
            if (this.reachingInstrs != null) {
                return this.reachingInstrs;
            }
            this.reachingInstrs = new HashMap<Integer, BitVector>();
            CallGraph cg = this.fw.callgraph();
            Set<IntPair> fallenThru = this.fallenThruBranches();
            Set<IntPair> taken = this.takenBranches();
            HashSet<Object> nodes = new HashSet<Object>();
            for (IntPair intPair : fallenThru) {
                nodes.add(cg.getNode(intPair.getX()));
            }
            for (IntPair intPair : taken) {
                nodes.add(cg.getNode(intPair.getX()));
            }
            for (CGNode cGNode : nodes) {
                BitVector visited = new BitVector();
                BitVector todo = new BitVector();
                IR ir = cGNode.getIR();
                int i = 0;
                todo.set(i);
                while (!todo.isZero()) {
                    SSASwitchInstruction c;
                    i = todo.nextSetBit(0);
                    todo.clear(i);
                    visited.set(i);
                    if (i >= ir.getInstructions().length) continue;
                    SSAInstruction instr = ir.getInstructions()[i];
                    if (instr instanceof SSAConditionalBranchInstruction) {
                        SSAConditionalBranchInstruction c2;
                        IntPair key = IntPair.make((int)cGNode.getGraphNodeId(), (int)i);
                        if (!fallenThru.contains(key) && (c2 = (SSAConditionalBranchInstruction)instr).getTarget() >= 0 && !visited.contains(c2.getTarget())) {
                            todo.set(c2.getTarget());
                        }
                        if (taken.contains(key)) {
                            continue;
                        }
                    } else if (instr instanceof SSASwitchInstruction) {
                        c = (SSASwitchInstruction)instr;
                        for (int l : c.getCasesAndLabels()) {
                            int j = c.getTarget(l);
                            if (visited.contains(j)) continue;
                            todo.set(j);
                        }
                        if (!visited.contains(c.getDefault())) {
                            todo.set(c.getDefault());
                        }
                    } else if (instr instanceof SSAGotoInstruction && (c = (SSAGotoInstruction)instr).getTarget() >= 0 && !visited.contains(c.getTarget())) {
                        todo.set(c.getTarget());
                    }
                    if (instr != null && !instr.isFallThrough() || visited.contains(i + 1)) continue;
                    todo.set(i + 1);
                }
                this.reachingInstrs.put(cGNode.getGraphNodeId(), visited);
            }
            return this.reachingInstrs;
        }

        @Override
        public boolean forbids(Constraint other) {
            if (this.category().equals(other.category()) && this.type().equals(other.type())) {
                return true;
            }
            if (other instanceof BranchingConstraint) {
                if (this.type().compareTo(other.type()) > 0) {
                    return false;
                }
                return !this.covers((BranchingConstraint)other) && !((BranchingConstraint)other).covers(this);
            }
            if (other instanceof EntryConstraint) {
                CGNode m = ((EntryConstraint)other).node();
                return !Util.any(this.reachingInstrs().keySet(), k -> this.fw.isReachable(m, (CGNode)this.fw.callgraph().getNode(k.intValue())));
            }
            return false;
        }

        public boolean covers(BranchingConstraint that) {
            for (Map.Entry<Integer, BitVector> e : this.reachingInstrs().entrySet()) {
                CGNode n = (CGNode)this.fw.callgraph().getNode(e.getKey().intValue());
                IR ir = n.getIR();
                SSAInstruction[] instrs = ir.getInstructions();
                BitVector thatReachingInstrs = that.reachingInstrs().getOrDefault(e.getKey(), null);
                BitVector defaultReachingInstrs = this.defaultConstraint().reachingInstrs().getOrDefault(e.getKey(), null);
                Set<IntPair> thatBranches = that.fallenThruBranches();
                for (int i = 0; i < instrs.length; ++i) {
                    CallSiteReference site;
                    String klazz;
                    if (!(instrs[i] instanceof SSAAbstractInvokeInstruction) || !e.getValue().contains(i) || (klazz = (site = ((SSAAbstractInvokeInstruction)instrs[i]).getCallSite()).getDeclaredTarget().getDeclaringClass().getName().toString()).startsWith("Ljava/") || klazz.startsWith("Ljavax/")) continue;
                    if (thatReachingInstrs != null && !thatReachingInstrs.contains(i)) {
                        return true;
                    }
                    if (defaultReachingInstrs != null && defaultReachingInstrs.contains(i)) continue;
                    for (CGNode m : this.fw.callgraph.getPossibleTargets(n, site)) {
                        if (!Util.any(thatBranches, p -> this.fw.isReachable(m, (CGNode)this.fw.callgraph().getNode(p.getX())))) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean isRelevant() {
            for (Map.Entry<Integer, BitVector> e : this.reachingInstrs().entrySet()) {
                CGNode n = (CGNode)this.fw.callgraph().getNode(e.getKey().intValue());
                if (this.fw.relevance.contains(n.getGraphNodeId())) {
                    return true;
                }
                IR ir = n.getIR();
                SSAInstruction[] instrs = ir.getInstructions();
                BitVector defaultReachingInstrs = this.defaultConstraint().reachingInstrs().getOrDefault(e.getKey(), null);
                for (int i = 0; i < instrs.length; ++i) {
                    CallSiteReference site;
                    String klazz;
                    if (!(instrs[i] instanceof SSAAbstractInvokeInstruction) || !e.getValue().contains(i) || (klazz = (site = ((SSAAbstractInvokeInstruction)instrs[i]).getCallSite()).getDeclaredTarget().getDeclaringClass().getName().toString()).startsWith("Ljava/") || klazz.startsWith("Ljavax/") || defaultReachingInstrs != null && defaultReachingInstrs.contains(i)) continue;
                    for (CGNode m : this.fw.callgraph.getPossibleTargets(n, site)) {
                        if (!this.fw.isRelevant(m)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

