/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.query;

import com.google.common.collect.Iterables;
import com.syncleus.ferma.FramedGraph;
import com.syncleus.ferma.Traversable;
import com.syncleus.ferma.VertexFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.config.query.QueryBuilderAs;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.config.query.QueryBuilderFrom;
import org.jboss.windup.config.query.QueryBuilderPiped;
import org.jboss.windup.config.query.QueryBuilderWith;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.config.query.QueryPropertyCriterion;
import org.jboss.windup.config.query.QueryTypeCriterion;
import org.jboss.windup.config.selectors.FramesSelector;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.frames.FramedVertexIterable;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Task;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class Query
extends GraphCondition
implements QueryBuilderFind,
QueryBuilderFrom,
QueryBuilderWith,
QueryBuilderPiped {
    private final List<QueryGremlinCriterion> pipelineCriteria = new ArrayList<QueryGremlinCriterion>();
    private Class<? extends WindupVertexFrame> searchType;
    private FramesSelector framesSelector;
    private Predicate<WindupVertexFrame> resultFilter;

    private Query() {
    }

    public static QueryBuilderPiped gremlin(QueryGremlinCriterion criterion) {
        return new Query().piped(criterion);
    }

    public static QueryBuilderFind fromType(Class<? extends WindupVertexFrame> type) {
        Query query = new Query();
        query.searchType = type;
        return query;
    }

    @Override
    public QueryBuilderFind excludingType(final Class<? extends WindupVertexFrame> type) {
        this.pipelineCriteria.add(new QueryGremlinCriterion(){

            @Override
            public void query(GraphRewrite event, GraphTraversal<?, Vertex> pipeline) {
                pipeline.filter(it -> !GraphTypeManager.hasType((Class)type, (Vertex)((Vertex)it.get())));
            }
        });
        return this;
    }

    @Override
    public QueryBuilderFind includingType(final Class<? extends WindupVertexFrame> type) {
        this.pipelineCriteria.add(new QueryGremlinCriterion(){

            @Override
            public void query(GraphRewrite event, GraphTraversal<?, Vertex> pipeline) {
                pipeline.filter(it -> GraphTypeManager.hasType((Class)type, (Vertex)((Vertex)it.get())));
            }
        });
        return this;
    }

    public static QueryBuilderFrom from(String sourceVarName) {
        Query query = new Query();
        query.setInputVariablesName(sourceVarName);
        return query;
    }

    @Override
    public ConditionBuilder as(String name) {
        this.setOutputVariablesName(name);
        return this;
    }

    @Override
    public boolean evaluate(final GraphRewrite event, final EvaluationContext context) {
        String queryStr = this.toString();
        return (Boolean)ExecutionStatistics.performBenchmarked((String)queryStr, (Task)new Task<Boolean>(){

            public Boolean execute() {
                Query.this.setInitialFramesSelector(Query.createInitialFramesSelector(Query.this));
                Iterable result = Query.this.framesSelector.getFrames(event, context);
                if (Query.this.resultFilter != null) {
                    com.google.common.base.Predicate<WindupVertexFrame> guavaPred = new com.google.common.base.Predicate<WindupVertexFrame>(){

                        public boolean apply(WindupVertexFrame input) {
                            return Query.this.resultFilter.accept((Object)input);
                        }
                    };
                    result = Iterables.filter(result, (com.google.common.base.Predicate)guavaPred);
                }
                Query.this.setResults(event, Query.this.getOutputVariablesName(), result);
                return result.iterator().hasNext();
            }
        });
    }

    @Override
    public QueryBuilderWith withProperty(String property, Object searchValue) {
        return this.withProperty(property, QueryPropertyComparisonType.EQUALS, searchValue);
    }

    @Override
    public QueryBuilderWith withProperty(String property, Iterable<?> values) {
        this.pipelineCriteria.add(new QueryPropertyCriterion(property, QueryPropertyComparisonType.CONTAINS_ANY_TOKEN, values));
        return this;
    }

    @Override
    public QueryBuilderWith withProperty(String property) {
        this.pipelineCriteria.add(new QueryPropertyCriterion(property, QueryPropertyComparisonType.DEFINED, null));
        return this;
    }

    @Override
    public QueryBuilderWith withoutProperty(String property) {
        this.pipelineCriteria.add(new QueryPropertyCriterion(property, QueryPropertyComparisonType.NOT_DEFINED, null));
        return this;
    }

    private static FramesSelector createInitialFramesSelector(final Query query) {
        return new FramesSelector(){

            public Iterable<WindupVertexFrame> getFrames(GraphRewrite event, EvaluationContext context) {
                List<Vertex> startingVertices = this.getStartingVertices(event);
                if (startingVertices.isEmpty()) {
                    return Collections.emptyList();
                }
                GraphTraversal pipeline = new GraphTraversalSource((Graph)event.getGraphContext().getGraph()).V(new Object[]{startingVertices});
                HashSet<WindupVertexFrame> frames = new HashSet<WindupVertexFrame>();
                for (QueryGremlinCriterion c : query.getPipelineCriteria()) {
                    c.query(event, pipeline);
                }
                FramedVertexIterable framedVertexIterable = new FramedVertexIterable((FramedGraph)event.getGraphContext().getFramed(), (Iterable)pipeline.toList(), WindupVertexFrame.class);
                for (WindupVertexFrame frame : framedVertexIterable) {
                    frames.add(frame);
                }
                return frames;
            }

            private List<Vertex> getStartingVertices(GraphRewrite event) {
                boolean hasStartingVerticesVariable;
                boolean bl = hasStartingVerticesVariable = query.getInputVariablesName() != null && !query.getInputVariablesName().isEmpty();
                if (hasStartingVerticesVariable) {
                    if (query.searchType != null) {
                        query.piped(new QueryTypeCriterion(query.searchType));
                    }
                    Variables variables = (Variables)event.getRewriteContext().get(Variables.class);
                    Iterable<? extends WindupVertexFrame> frames = variables.findVariable(query.getInputVariablesName());
                    ArrayList<Vertex> results = new ArrayList<Vertex>();
                    for (WindupVertexFrame windupVertexFrame : frames) {
                        results.add(windupVertexFrame.getElement());
                    }
                    return results;
                }
                Traversable framesQueryType = event.getGraphContext().getFramed().traverse(g -> g.V(new Object[0]));
                if (query.searchType != null) {
                    new QueryTypeCriterion(query.searchType).query(framesQueryType);
                    return framesQueryType.toList(WindupVertexFrame.class).stream().map(VertexFrame::getElement).collect(Collectors.toList());
                }
                return event.getGraphContext().getGraph().traversal().V(new Object[0]).toList();
            }
        };
    }

    @Override
    public QueryBuilderWith withProperty(String property, Object searchValue, Object ... searchValues) {
        LinkedList<Object> values = new LinkedList<Object>();
        values.add(searchValue);
        values.addAll(Arrays.asList(searchValues));
        return this.withProperty(property, values);
    }

    @Override
    public QueryBuilderWith withProperty(String property, QueryPropertyComparisonType searchType, Object searchValue) {
        this.pipelineCriteria.add(new QueryPropertyCriterion(property, searchType, searchValue));
        return this;
    }

    @Override
    public QueryBuilderPiped piped(QueryGremlinCriterion criterion) {
        this.pipelineCriteria.add(criterion);
        return this;
    }

    private void setInitialFramesSelector(FramesSelector selector) {
        this.framesSelector = selector;
    }

    public Collection<QueryGremlinCriterion> getPipelineCriteria() {
        return this.pipelineCriteria;
    }

    @Override
    public <FRAMETYPE extends WindupVertexFrame> QueryBuilderAs filteredBy(Predicate<FRAMETYPE> predicate) {
        this.resultFilter = predicate;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Query");
        if (this.searchType != null) {
            builder.append(".fromType(").append(this.searchType.getName()).append(")");
        }
        if (!this.pipelineCriteria.isEmpty()) {
            builder.append(".gremlin()");
            for (QueryGremlinCriterion criterion : this.pipelineCriteria) {
                builder.append(criterion);
            }
        }
        builder.append(".as(" + this.getOutputVariablesName() + ")");
        return builder.toString();
    }
}

