/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.report.IgnoredFileRegexModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.IgnoredFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.PackageModel;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;
import org.jboss.windup.util.Logging;

public class WindupJavaConfigurationService
extends GraphService<WindupJavaConfigurationModel> {
    private static final Logger LOG = Logging.get(WindupJavaConfigurationService.class);
    private List<String> ignoredRegexes;

    public WindupJavaConfigurationService(GraphContext context) {
        super(context, WindupJavaConfigurationModel.class);
    }

    public static synchronized WindupJavaConfigurationModel getJavaConfigurationModel(GraphContext context) {
        WindupJavaConfigurationService service = new WindupJavaConfigurationService(context);
        WindupJavaConfigurationModel config = (WindupJavaConfigurationModel)service.getUnique();
        if (config == null) {
            config = (WindupJavaConfigurationModel)service.create();
        }
        return config;
    }

    public boolean checkRegexAndIgnore(GraphRewrite event, FileModel file) {
        List<String> patterns = this.getIgnoredFileRegexes();
        boolean ignored = false;
        if (patterns != null && !patterns.isEmpty()) {
            for (String pattern : patterns) {
                if (!file.getFilePath().matches(pattern)) continue;
                IgnoredFileModel ignoredFileModel = (IgnoredFileModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)file, IgnoredFileModel.class);
                ignoredFileModel.setIgnoredRegex(pattern);
                LOG.info("File/Directory placed in " + file.getFilePath() + " was ignored, because matched [" + pattern + "].");
                ignored = true;
                break;
            }
        }
        return ignored;
    }

    public List<String> getIgnoredFileRegexes() {
        if (this.ignoredRegexes == null) {
            this.ignoredRegexes = new ArrayList<String>();
            WindupJavaConfigurationModel cfg = WindupJavaConfigurationService.getJavaConfigurationModel(this.getGraphContext());
            for (IgnoredFileRegexModel ignored : cfg.getIgnoredFileRegexes()) {
                if (ignored.getCompilationError() != null) continue;
                this.ignoredRegexes.add(ignored.getRegex());
            }
        }
        return this.ignoredRegexes;
    }

    public boolean shouldScanFile(String path) {
        WindupJavaConfigurationModel configuration = WindupJavaConfigurationService.getJavaConfigurationModel(this.getGraphContext());
        path = FilenameUtils.separatorsToUnix((String)path);
        for (PackageModel excludePackage : configuration.getExcludeJavaPackages()) {
            String packageAsPath = excludePackage.getPackageName().replace(".", "/");
            if (!path.contains(packageAsPath)) continue;
            return false;
        }
        boolean shouldScan = true;
        for (PackageModel includePackage : configuration.getScanJavaPackages()) {
            String packageAsPath = includePackage.getPackageName().replace(".", "/");
            if (path.contains(packageAsPath)) {
                shouldScan = true;
                break;
            }
            shouldScan = false;
        }
        return shouldScan;
    }

    public boolean shouldScanPackage(String pkg) {
        String pkgToCheck = pkg == null ? "" : pkg;
        WindupJavaConfigurationModel configuration = WindupJavaConfigurationService.getJavaConfigurationModel(this.getGraphContext());
        if (configuration.getExcludeJavaPackages().stream().map(PackageModel::getPackageName).anyMatch(pkgToCheck::startsWith)) {
            return false;
        }
        if (configuration.getScanJavaPackages().isEmpty()) {
            return true;
        }
        return configuration.getScanJavaPackages().stream().map(PackageModel::getPackageName).anyMatch(pkgToCheck::startsWith);
    }

    public boolean isTargetDir(FileModel file) {
        if (!file.getFileName().equals("target")) {
            return false;
        }
        return Stream.of(Optional.ofNullable(file.asFile().getParentFile().listFiles()).orElse(new File[0])).anyMatch(f -> f.toPath().getFileName().toString().equals("pom.xml"));
    }
}

