/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.ArchiveMetadataExtractionPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.ArchiveService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.HasManifestFilesModel;
import org.jboss.windup.rules.apps.java.model.JarManifestModel;
import org.jboss.windup.rules.apps.java.service.JarManifestService;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ArchiveMetadataExtractionPhase.class, perform="DiscoverManifestFilesInArchives")
public class DiscoverArchiveManifestFilesRuleProvider
extends IteratingRuleProvider<ArchiveModel> {
    private static final Logger LOG = Logging.get(DiscoverArchiveManifestFilesRuleProvider.class);
    private static final String TECH_TAG = "Manifest";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;

    public ConditionBuilder when() {
        return Query.fromType(ArchiveModel.class);
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        String[] filenames = new String[]{"META-INF/MANIFEST.MF", "WEB-INF/classes/META-INF/MANIFEST.MF"};
        Arrays.stream(filenames).forEach(filename -> this.importManifest(event, payload, (String)filename));
    }

    private void importManifest(GraphRewrite event, ArchiveModel archive, String manifestFilePath) {
        block14: {
            ArchiveService archiveService = new ArchiveService(event.getGraphContext());
            FileModel manifestFile = archiveService.getChildFile(archive, manifestFilePath);
            if (manifestFile == null) {
                return;
            }
            TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
            JarManifestService jarManifestService = new JarManifestService(event.getGraphContext());
            technologyTagService.addTagToFileModel(manifestFile, TECH_TAG, TECH_TAG_LEVEL);
            JarManifestModel jarManifest = (JarManifestModel)jarManifestService.addTypeToModel((WindupVertexFrame)manifestFile);
            GraphService hasManifestFilesModelService = new GraphService(event.getGraphContext(), HasManifestFilesModel.class);
            ((HasManifestFilesModel)hasManifestFilesModelService.addTypeToModel((WindupVertexFrame)archive)).addManifestModel(jarManifest);
            jarManifest.setGenerateSourceReport(true);
            try (InputStream is = manifestFile.asInputStream();){
                Manifest manifest = new Manifest(is);
                if (manifest.getMainAttributes().isEmpty()) {
                    return;
                }
                for (Object key : manifest.getMainAttributes().keySet()) {
                    String property = StringUtils.trim((String)key.toString());
                    String propertyValue = StringUtils.trim((String)manifest.getMainAttributes().get(key).toString());
                    jarManifest.setProperty(property, propertyValue);
                }
                if (!StringUtils.isBlank((CharSequence)jarManifest.getName())) break block14;
                for (String entry : manifest.getEntries().keySet()) {
                    for (Object key : manifest.getAttributes(entry).keySet()) {
                        String property = StringUtils.trim((String)key.toString());
                        String propertyValue = StringUtils.trim((String)manifest.getAttributes(entry).get(key).toString());
                        if (!StringUtils.isBlank((CharSequence)((CharSequence)jarManifest.getProperty(property)))) continue;
                        jarManifest.setProperty(property, propertyValue);
                    }
                    if (StringUtils.isBlank((CharSequence)jarManifest.getName())) continue;
                    break;
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Exception reading manifest from file: " + manifestFile.getFilePath(), e);
            }
        }
    }
}

