/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.ast;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jboss.windup.ast.java.ASTProcessor;
import org.jboss.windup.ast.java.BatchASTFuture;
import org.jboss.windup.ast.java.BatchASTListener;
import org.jboss.windup.ast.java.BatchASTProcessor;
import org.jboss.windup.ast.java.WildcardImportResolver;
import org.jboss.windup.ast.java.data.ClassReference;
import org.jboss.windup.ast.java.data.ResolutionStatus;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.ast.java.data.annotations.AnnotationArrayValue;
import org.jboss.windup.ast.java.data.annotations.AnnotationClassReference;
import org.jboss.windup.ast.java.data.annotations.AnnotationLiteralValue;
import org.jboss.windup.ast.java.data.annotations.AnnotationValue;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.metadata.TechnologyMetadata;
import org.jboss.windup.config.metadata.TechnologyMetadataProvider;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.TechnologyReferenceModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.IgnoredFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.JavaTechnologyMetadata;
import org.jboss.windup.rules.apps.java.model.JarArchiveModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaAnalysisBatch;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.TypeInterestFactory;
import org.jboss.windup.rules.apps.java.scan.ast.WindupWildcardImportResolver;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationListTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationLiteralTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.jboss.windup.rules.apps.java.service.TypeReferenceService;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.ProgressEstimate;
import org.jboss.windup.util.ThemeProvider;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.exception.WindupStopException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=InitialAnalysisPhase.class, haltOnException=true)
public class AnalyzeJavaFilesRuleProvider
extends AbstractRuleProvider {
    public static final String UNPARSEABLE_JAVA_CLASSIFICATION = "Unparseable Java File";
    public static final String UNPARSEABLE_JAVA_DESCRIPTION = "This Java file could not be parsed";
    public static final int COMMIT_INTERVAL = 500;
    public static final int LOG_INTERVAL = 250;
    private static final Logger LOG = Logging.get(AnalyzeJavaFilesRuleProvider.class);
    @Inject
    private WindupWildcardImportResolver importResolver;
    @Inject
    private TechnologyMetadataProvider technologyMetadataProvider;
    final AtomicInteger ticks = new AtomicInteger();

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new ParseSourceOperation());
    }

    private final class ParseSourceOperation
    extends GraphOperation {
        private static final int ANALYSIS_QUEUE_SIZE = 5000;
        final Map<Path, JavaSourceFileModel> sourcePathToFileModel = new TreeMap<Path, JavaSourceFileModel>();

        private ParseSourceOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(GraphRewrite event, EvaluationContext context) {
            ExecutionStatistics.get().begin("AnalyzeJavaFilesRuleProvider.analyzeFile");
            try {
                GraphContext graphContext = event.getGraphContext();
                WindupJavaConfigurationService windupJavaConfigurationService = new WindupJavaConfigurationService(graphContext);
                List allJavaSourceModels = graphContext.service(JavaSourceFileModel.class).findAll();
                allJavaSourceModels = allJavaSourceModels.stream().filter(fileModel -> !(fileModel instanceof IgnoredFileModel)).collect(Collectors.toList());
                HashMap<ProjectModel, JavaAnalysisBatch> batchMap = new HashMap<ProjectModel, JavaAnalysisBatch>();
                HashSet<String> sourceRoots = new HashSet<String>();
                int sourceFileCount = 0;
                for (JavaSourceFileModel javaFile : allJavaSourceModels) {
                    FileModel rootSourceFolder = javaFile.getRootSourceFolder();
                    if (rootSourceFolder != null) {
                        sourceRoots.add(rootSourceFolder.getFilePath());
                    }
                    if (!windupJavaConfigurationService.shouldScanPackage(javaFile.getPackageName())) continue;
                    ProjectModel application = javaFile.getApplication();
                    JavaAnalysisBatch batch = (JavaAnalysisBatch)batchMap.get(application);
                    if (batch == null) {
                        batch = new JavaAnalysisBatch(application);
                        batchMap.put(application, batch);
                    }
                    Path path = Paths.get(javaFile.getFilePath(), new String[0]);
                    batch.getSourceFiles().add(path);
                    ++sourceFileCount;
                    this.sourcePathToFileModel.put(path, javaFile);
                }
                LOG.log(Level.INFO, "Analyzing {0} Java source files.", sourceFileCount);
                WindupJavaConfigurationModel javaConfiguration = WindupJavaConfigurationService.getJavaConfigurationModel(graphContext);
                this.collectLibraryPaths(graphContext, javaConfiguration, batchMap);
                ExecutionStatistics.get().begin("AnalyzeJavaFilesRuleProvider.parseFiles");
                boolean classNotFoundAnalysisEnabled = javaConfiguration.isClassNotFoundAnalysisEnabled();
                try {
                    WindupWildcardImportResolver.setContext(graphContext);
                    ProgressEstimate estimate = new ProgressEstimate(sourceFileCount);
                    for (JavaAnalysisBatch batch : batchMap.values()) {
                        this.parseJavaFiles(event, estimate, classNotFoundAnalysisEnabled, batch, sourceRoots, graphContext, context);
                    }
                }
                catch (WindupStopException ex) {
                    throw new WindupStopException((Exception)((Object)ex));
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Could not analyze java files: " + e.getMessage(), e);
                }
                finally {
                    WindupWildcardImportResolver.setContext(null);
                    ExecutionStatistics.get().end("AnalyzeJavaFilesRuleProvider.parseFiles");
                }
            }
            finally {
                this.sourcePathToFileModel.clear();
                ExecutionStatistics.get().end("AnalyzeJavaFilesRuleProvider.analyzeFile");
            }
        }

        private void parseJavaFiles(final GraphRewrite event, ProgressEstimate estimate, final boolean classNotFoundAnalysisEnabled, JavaAnalysisBatch batch, Set<String> sourceRoots, GraphContext graphContext, EvaluationContext context) throws InterruptedException {
            Object msg;
            final ArrayBlockingQueue processedPaths = new ArrayBlockingQueue(5000);
            final ConcurrentHashMap failures = new ConcurrentHashMap();
            BatchASTListener listener = new BatchASTListener(){

                public void processed(Path filePath, List<ClassReference> references) {
                    ParseSourceOperation.this.checkExecutionStopRequest(event);
                    try {
                        processedPaths.put(new ImmutablePair((Object)filePath, ParseSourceOperation.this.filterClassReferences(references, classNotFoundAnalysisEnabled)));
                    }
                    catch (InterruptedException e) {
                        throw new WindupException(e.getMessage(), (Throwable)e);
                    }
                }

                public void failed(Path filePath, Throwable cause) {
                    ParseSourceOperation.this.checkExecutionStopRequest(event);
                    String message = "Failed to process: " + filePath + " due to: " + cause.getMessage();
                    LOG.log(Level.WARNING, message, cause);
                    failures.put(filePath, message);
                }
            };
            TreeSet<Path> filesToProcess = new TreeSet<Path>(batch.getSourceFiles());
            BatchASTFuture future = BatchASTProcessor.analyze((BatchASTListener)listener, (WildcardImportResolver)AnalyzeJavaFilesRuleProvider.this.importResolver, batch.getClasspath(), sourceRoots, filesToProcess);
            AtomicInteger referenceCount = new AtomicInteger(0);
            while (!future.isDone() || !processedPaths.isEmpty()) {
                Pair pair;
                this.checkExecutionStopRequest(event);
                if (processedPaths.size() > 2500) {
                    LOG.info("Queue size: " + processedPaths.size() + " / 5000");
                }
                if ((pair = (Pair)processedPaths.poll(250L, TimeUnit.MILLISECONDS)) == null) continue;
                this.processReferences(graphContext, referenceCount, (Path)pair.getKey(), (List)pair.getValue());
                estimate.addWork(1);
                this.printProgressEstimate(event, estimate);
                filesToProcess.remove(pair.getKey());
            }
            ClassificationService classificationService = new ClassificationService(graphContext);
            for (Map.Entry failure : failures.entrySet()) {
                this.markJavaFileModelAsUnprocessed(graphContext, (Path)failure.getKey(), classificationService, event, context, (String)failure.getValue());
            }
            if (!filesToProcess.isEmpty()) {
                for (Path unprocessed : new ArrayList<Path>(filesToProcess)) {
                    this.checkExecutionStopRequest(event);
                    try {
                        List references = ASTProcessor.analyze((WildcardImportResolver)AnalyzeJavaFilesRuleProvider.this.importResolver, batch.getClasspath(), sourceRoots, (Path)unprocessed);
                        this.processReferences(graphContext, referenceCount, unprocessed, this.filterClassReferences(references, classNotFoundAnalysisEnabled));
                        filesToProcess.remove(unprocessed);
                    }
                    catch (Exception | StackOverflowError e) {
                        msg = "Failed to process: " + unprocessed + " due to: " + e.getMessage();
                        LOG.log(Level.WARNING, (String)msg, e);
                        this.markJavaFileModelAsUnprocessed(graphContext, unprocessed, classificationService, event, context, (String)msg);
                    }
                    estimate.addWork(1);
                    this.printProgressEstimate(event, estimate);
                }
            }
            if (!filesToProcess.isEmpty()) {
                StringBuilder message = new StringBuilder();
                message.append("Failed to process " + filesToProcess.size() + " files:\n");
                for (Path unprocessed : filesToProcess) {
                    message.append("\tFailed to process: " + unprocessed + System.lineSeparator());
                    msg = "Could not process neither in batch or individually.";
                    this.markJavaFileModelAsUnprocessed(graphContext, unprocessed, classificationService, event, context, (String)msg);
                }
                LOG.warning(message.toString());
            }
        }

        private void checkExecutionStopRequest(GraphRewrite event) {
            if (AnalyzeJavaFilesRuleProvider.this.ticks.incrementAndGet() % 20 == 0 && event.shouldWindupStop()) {
                throw new WindupStopException("Stop requested while analyzing Java files.");
            }
        }

        private void markJavaFileModelAsUnprocessed(GraphContext graphContext, Path unprocessed, ClassificationService classificationService, GraphRewrite event, EvaluationContext context, String msg) {
            JavaSourceFileModel sourceFileModel = this.getJavaSourceFileModel(graphContext, unprocessed);
            classificationService.attachClassification(event, context, (FileModel)sourceFileModel, AnalyzeJavaFilesRuleProvider.UNPARSEABLE_JAVA_CLASSIFICATION, AnalyzeJavaFilesRuleProvider.UNPARSEABLE_JAVA_DESCRIPTION);
            sourceFileModel.setParseError(msg);
        }

        private void collectLibraryPaths(GraphContext graphContext, WindupJavaConfigurationModel javaConfiguration, Map<ProjectModel, JavaAnalysisBatch> batchMap) {
            HashSet<String> libraryPaths = new HashSet<String>();
            WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)graphContext);
            for (TechnologyReferenceModel target : configurationModel.getTargetTechnologies()) {
                TechnologyMetadata technologyMetadata = AnalyzeJavaFilesRuleProvider.this.technologyMetadataProvider.getMetadata(graphContext, new TechnologyReference(target));
                if (technologyMetadata == null || !(technologyMetadata instanceof JavaTechnologyMetadata)) continue;
                JavaTechnologyMetadata javaMetadata = (JavaTechnologyMetadata)technologyMetadata;
                libraryPaths.addAll(javaMetadata.getAdditionalClasspaths().stream().map(Path::toString).collect(Collectors.toList()));
            }
            for (FileModel additionalClasspath : javaConfiguration.getAdditionalClasspaths()) {
                libraryPaths.add(additionalClasspath.getFilePath());
            }
            batchMap.values().forEach(batch -> batch.getClasspath().addAll(libraryPaths));
            List libraries = graphContext.service(JarArchiveModel.class).findAll();
            for (JarArchiveModel library : libraries) {
                ProjectModel application = library.getApplication();
                JavaAnalysisBatch batch2 = batchMap.get(application);
                if (batch2 == null) continue;
                batch2.getClasspath().add(library.getFilePath());
            }
        }

        private void commitIfNeeded(GraphContext context, int numberAddedToGraph) {
            if (numberAddedToGraph % 500 == 0) {
                context.commit();
            }
        }

        private void printProgressEstimate(GraphRewrite event, ProgressEstimate estimate) {
            boolean windupStopRequested;
            if (estimate.getWorked() % 250 != 0) {
                return;
            }
            int timeRemainingInMillis = (int)estimate.getTimeRemainingInMillis();
            if (timeRemainingInMillis > 0 && (windupStopRequested = event.ruleEvaluationProgress("Analyze Java", estimate.getWorked(), estimate.getTotal(), timeRemainingInMillis / 1000))) {
                throw new WindupStopException(ThemeProvider.getInstance().getTheme().getBrandNameAcronym() + " stop requested through ruleEvaluationProgress() during " + AnalyzeJavaFilesRuleProvider.class.getName());
            }
            LOG.info("Analyzed Java File: " + estimate.getWorked() + " / " + estimate.getTotal());
        }

        private List<ClassReference> filterClassReferences(List<ClassReference> references, boolean classNotFoundAnalysisEnabled) {
            ArrayList<ClassReference> results = new ArrayList<ClassReference>(references.size());
            for (ClassReference reference : references) {
                boolean shouldKeep = reference.getLocation() == TypeReferenceLocation.TYPE;
                shouldKeep |= classNotFoundAnalysisEnabled && reference.getResolutionStatus() != ResolutionStatus.RESOLVED;
                if (!(shouldKeep |= TypeInterestFactory.matchesAny(reference.getQualifiedName(), reference.getLocation())) && reference instanceof AnnotationClassReference) {
                    AnnotationClassReference annotationClassRef = (AnnotationClassReference)reference;
                    shouldKeep = this.processAnnotation(annotationClassRef.getAnnotationValues().values(), classNotFoundAnalysisEnabled);
                    ClassReference originalReference = annotationClassRef.getOriginalReference();
                    shouldKeep |= TypeInterestFactory.matchesAny(originalReference.getQualifiedName(), originalReference.getLocation());
                }
                if (!shouldKeep) continue;
                results.add(reference);
            }
            return results;
        }

        private boolean processAnnotation(Collection<AnnotationValue> references, boolean classNotFoundAnalysisEnabled) {
            if (references == null || references.isEmpty()) {
                return false;
            }
            for (AnnotationValue childValue : references) {
                boolean shouldKeep;
                if (childValue instanceof AnnotationArrayValue) {
                    AnnotationArrayValue annotationArrayValue = (AnnotationArrayValue)childValue;
                    if (!this.processAnnotation(annotationArrayValue.getValues(), classNotFoundAnalysisEnabled)) continue;
                    return true;
                }
                if (!(childValue instanceof AnnotationClassReference)) continue;
                AnnotationClassReference annotationClassReference = (AnnotationClassReference)childValue;
                boolean bl = shouldKeep = classNotFoundAnalysisEnabled && annotationClassReference.getResolutionStatus() != ResolutionStatus.RESOLVED;
                if (shouldKeep |= TypeInterestFactory.matchesAny(annotationClassReference.getQualifiedName(), annotationClassReference.getLocation())) {
                    return true;
                }
                return this.processAnnotation(annotationClassReference.getAnnotationValues().values(), classNotFoundAnalysisEnabled);
            }
            return false;
        }

        private void processReferences(GraphContext context, AtomicInteger referenceCount, Path filePath, List<ClassReference> references) {
            TypeReferenceService typeReferenceService = new TypeReferenceService(context);
            IdentityHashMap<ClassReference, JavaTypeReferenceModel> added = new IdentityHashMap<ClassReference, JavaTypeReferenceModel>(references.size());
            for (ClassReference reference : references) {
                if (added.containsKey(reference)) continue;
                JavaSourceFileModel javaSourceModel = this.getJavaSourceFileModel(context, filePath);
                JavaTypeReferenceModel typeReference = typeReferenceService.createTypeReference(javaSourceModel, reference.getLocation(), reference.getResolutionStatus(), reference.getLineNumber(), reference.getColumn(), reference.getLength(), reference.getQualifiedName(), reference.getLine());
                added.put(reference, typeReference);
                if (reference instanceof AnnotationClassReference) {
                    AnnotationClassReference annotationClassReference = (AnnotationClassReference)reference;
                    Map annotationValues = annotationClassReference.getAnnotationValues();
                    JavaAnnotationTypeReferenceModel annotationTypeReferenceModel = this.addAnnotationValues(context, javaSourceModel, typeReference, annotationValues);
                    ClassReference originalReference = annotationClassReference.getOriginalReference();
                    if (originalReference == null) {
                        LOG.warning("No original reference set for annotation: " + annotationClassReference);
                    } else {
                        JavaTypeReferenceModel originalReferenceModel = (JavaTypeReferenceModel)added.get(originalReference);
                        if (originalReferenceModel == null) {
                            originalReferenceModel = typeReferenceService.createTypeReference(javaSourceModel, originalReference.getLocation(), originalReference.getResolutionStatus(), originalReference.getLineNumber(), originalReference.getColumn(), originalReference.getLength(), originalReference.getQualifiedName(), originalReference.getLine());
                            added.put(originalReference, originalReferenceModel);
                        }
                        annotationTypeReferenceModel.setAnnotatedType(originalReferenceModel);
                    }
                }
                referenceCount.incrementAndGet();
                this.commitIfNeeded(context, referenceCount.get());
            }
        }

        private JavaSourceFileModel getJavaSourceFileModel(GraphContext context, Path filePath) {
            return (JavaSourceFileModel)GraphService.refresh((GraphContext)context, (WindupVertexFrame)this.sourcePathToFileModel.get(filePath));
        }

        private JavaAnnotationTypeReferenceModel addAnnotationValues(GraphContext context, JavaSourceFileModel javaSourceFileModel, JavaTypeReferenceModel typeReference, Map<String, AnnotationValue> annotationValues) {
            GraphService annotationTypeReferenceService = new GraphService(context, JavaAnnotationTypeReferenceModel.class);
            JavaAnnotationTypeReferenceModel javaAnnotationTypeReferenceModel = (JavaAnnotationTypeReferenceModel)annotationTypeReferenceService.addTypeToModel((WindupVertexFrame)typeReference);
            HashMap<String, JavaAnnotationTypeValueModel> valueModels = new HashMap<String, JavaAnnotationTypeValueModel>();
            for (Map.Entry<String, AnnotationValue> entry : annotationValues.entrySet()) {
                valueModels.put(entry.getKey(), this.getValueModelForAnnotationValue(context, javaSourceFileModel, entry.getValue()));
            }
            javaAnnotationTypeReferenceModel.setAnnotationValues(valueModels);
            return javaAnnotationTypeReferenceModel;
        }

        private JavaAnnotationTypeValueModel getValueModelForAnnotationValue(GraphContext context, JavaSourceFileModel javaSourceFileModel, AnnotationValue value) {
            JavaAnnotationTypeValueModel result;
            if (value instanceof AnnotationLiteralValue) {
                GraphService literalValueService = new GraphService(context, JavaAnnotationLiteralTypeValueModel.class);
                AnnotationLiteralValue literal = (AnnotationLiteralValue)value;
                JavaAnnotationLiteralTypeValueModel literalValueModel = (JavaAnnotationLiteralTypeValueModel)literalValueService.create();
                literalValueModel.setLiteralType(literal.getLiteralType().getSimpleName());
                literalValueModel.setLiteralValue(literal.getLiteralValue() == null ? null : literal.getLiteralValue().toString());
                result = literalValueModel;
            } else if (value instanceof AnnotationArrayValue) {
                GraphService listValueService = new GraphService(context, JavaAnnotationListTypeValueModel.class);
                AnnotationArrayValue arrayValues = (AnnotationArrayValue)value;
                JavaAnnotationListTypeValueModel listModel = (JavaAnnotationListTypeValueModel)listValueService.create();
                for (AnnotationValue arrayValue : arrayValues.getValues()) {
                    listModel.addItem(this.getValueModelForAnnotationValue(context, javaSourceFileModel, arrayValue));
                }
                result = listModel;
            } else if (value instanceof AnnotationClassReference) {
                GraphService annotationTypeReferenceService = new GraphService(context, JavaAnnotationTypeReferenceModel.class);
                AnnotationClassReference annotationClassReference = (AnnotationClassReference)value;
                HashMap<String, JavaAnnotationTypeValueModel> valueModels = new HashMap<String, JavaAnnotationTypeValueModel>();
                for (Map.Entry entry : annotationClassReference.getAnnotationValues().entrySet()) {
                    valueModels.put((String)entry.getKey(), this.getValueModelForAnnotationValue(context, javaSourceFileModel, (AnnotationValue)entry.getValue()));
                }
                JavaAnnotationTypeReferenceModel annotationTypeReferenceModel = (JavaAnnotationTypeReferenceModel)annotationTypeReferenceService.create();
                annotationTypeReferenceModel.setAnnotationValues(valueModels);
                this.attachLocationMetadata(annotationTypeReferenceModel, annotationClassReference, javaSourceFileModel);
                result = annotationTypeReferenceModel;
            } else {
                throw new WindupException("Unrecognized AnnotationValue subtype: " + value.getClass().getCanonicalName());
            }
            return result;
        }

        private void attachLocationMetadata(JavaTypeReferenceModel javaTypeReferenceModel, AnnotationClassReference annotationClassReference, JavaSourceFileModel javaSourceFileModel) {
            javaTypeReferenceModel.setResolutionStatus(annotationClassReference.getResolutionStatus());
            javaTypeReferenceModel.setResolvedSourceSnippit(annotationClassReference.getQualifiedName());
            javaTypeReferenceModel.setSourceSnippit(annotationClassReference.getLine());
            javaTypeReferenceModel.setReferenceLocation(annotationClassReference.getLocation());
            javaTypeReferenceModel.setColumnNumber(annotationClassReference.getColumn());
            javaTypeReferenceModel.setLineNumber(annotationClassReference.getLineNumber());
            javaTypeReferenceModel.setLength(annotationClassReference.getLength());
            javaTypeReferenceModel.setFile(javaSourceFileModel);
        }

        public String toString() {
            return "ParseJavaSource";
        }
    }
}

