/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker.dto;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.dependencyreport.DependencyReportDependencyGroupModel;

public class DependencyGraphItem {
    private final Kind kind;
    private final Map<String, String> metadata = new HashMap<String, String>(1);

    public DependencyGraphItem(DependencyReportDependencyGroupModel dependencyReportDependencyGroupModel) {
        this(dependencyReportDependencyGroupModel.getCanonicalProject());
    }

    public DependencyGraphItem(ProjectModel projectModel) {
        this.metadata.put("name", projectModel.getRootFileModel().getFileName());
        this.kind = Kind.getKind(projectModel);
    }

    public String getKind() {
        return this.kind.getValue();
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    static enum Kind {
        EAR("Ear"),
        WAR_APP("WarApp"),
        JAR_APP("JarApp"),
        WAR("War"),
        JAR("Jar"),
        EXTERNAL_JAR("ExternalJar"),
        UNKNOWN("unknown");

        private String value;

        private Kind(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        static Kind getKind(ProjectModel projectModel) {
            String projectType = projectModel.getProjectType() == null ? (!projectModel.getRootFileModel().isDirectory() ? FilenameUtils.getExtension((String)projectModel.getRootFileModel().getFileName()) : "war") : projectModel.getProjectType();
            boolean isChildren = projectModel.getParentProject() != null;
            boolean isSkipped = projectModel.getRootFileModel() instanceof IdentifiedArchiveModel;
            switch (projectType.toLowerCase()) {
                case "jar": {
                    return isChildren ? (isSkipped ? EXTERNAL_JAR : JAR) : JAR_APP;
                }
                case "war": {
                    return isChildren ? WAR : WAR_APP;
                }
                case "ear": {
                    return EAR;
                }
            }
            return UNKNOWN;
        }
    }
}

