/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.condition.annotation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.EvaluationStrategy;
import org.jboss.windup.rules.apps.java.condition.annotation.AnnotationCondition;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterizedPatternResult;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class AnnotationTypeCondition
extends AnnotationCondition {
    private RegexParameterizedPatternParser pattern;
    private Map<String, AnnotationCondition> conditions = new HashMap<String, AnnotationCondition>();

    public AnnotationTypeCondition(String pattern) {
        this.pattern = new RegexParameterizedPatternParser(pattern);
    }

    public AnnotationTypeCondition addCondition(String element, AnnotationCondition condition) {
        this.conditions.put(element, condition);
        return this;
    }

    public String toString() {
        return "AnnotationTypeCondition{pattern=" + this.pattern + ", conditions=" + this.conditions + "}";
    }

    @Override
    public boolean evaluate(GraphRewrite event, EvaluationContext context, EvaluationStrategy strategy, JavaAnnotationTypeValueModel value) {
        if (!(value instanceof JavaAnnotationTypeReferenceModel)) {
            return false;
        }
        JavaAnnotationTypeReferenceModel typeReferenceModel = (JavaAnnotationTypeReferenceModel)value;
        if (this.pattern != null) {
            String annotationValue = typeReferenceModel.getResolvedSourceSnippit();
            ParameterizedPatternResult referenceResult = this.pattern.parse(annotationValue);
            if (!referenceResult.matches()) {
                return false;
            }
            referenceResult.submit((Rewrite)event, context);
        }
        return this.evaluateChildConditions(event, context, strategy, typeReferenceModel);
    }

    protected boolean evaluateChildConditions(GraphRewrite event, EvaluationContext context, EvaluationStrategy strategy, JavaAnnotationTypeReferenceModel annotation) {
        for (Map.Entry<String, AnnotationCondition> conditionEntry : this.conditions.entrySet()) {
            JavaAnnotationTypeValueModel subValue = annotation.getAnnotationValues().get(conditionEntry.getKey());
            if (subValue == null) {
                return false;
            }
            if (conditionEntry.getValue().evaluate(event, context, strategy, subValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.pattern != null) {
            result.addAll(this.pattern.getRequiredParameterNames());
        }
        if (this.conditions != null) {
            for (AnnotationCondition condition : this.conditions.values()) {
                result.addAll(condition.getRequiredParameterNames());
            }
        }
        return result;
    }
}

