/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.ferma.framefactories.annotation;

import com.syncleus.ferma.AbstractEdgeFrame;
import com.syncleus.ferma.AbstractVertexFrame;
import com.syncleus.ferma.EdgeFrame;
import com.syncleus.ferma.ReflectionCache;
import com.syncleus.ferma.VertexFrame;
import com.syncleus.ferma.framefactories.FrameFactory;
import com.syncleus.ferma.framefactories.annotation.AnnotationFrameFactory;
import com.syncleus.ferma.framefactories.annotation.CachesReflection;
import com.syncleus.ferma.framefactories.annotation.MethodHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class AbstractAnnotationFrameFactory
implements FrameFactory {
    protected final Map<Class<? extends Annotation>, MethodHandler> methodHandlers = new HashMap<Class<? extends Annotation>, MethodHandler>();
    private final ReflectionCache reflectionCache;
    private final Map<Class, Class> constructedClassCache = new HashMap<Class, Class>();

    protected AbstractAnnotationFrameFactory(ReflectionCache reflectionCache, Set<MethodHandler> handlers) {
        this.reflectionCache = reflectionCache;
        for (MethodHandler handler : handlers) {
            this.methodHandlers.put(handler.getAnnotationType(), handler);
        }
    }

    private static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    private static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    @Override
    public <T> T create(Element e, Class<T> kind) {
        Class<T> resolvedKind = kind;
        if (AbstractAnnotationFrameFactory.isAbstract(resolvedKind)) {
            resolvedKind = this.constructClass(e, kind);
        }
        try {
            T object = resolvedKind.newInstance();
            if (object instanceof CachesReflection) {
                ((CachesReflection)object).setReflectionCache(this.reflectionCache);
            }
            return object;
        }
        catch (IllegalAccessException | InstantiationException caught) {
            throw new IllegalArgumentException("kind could not be instantiated", caught);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <E> Class<? extends E> constructClass(Element element, Class<E> clazz) {
        DynamicType.Builder classBuilder;
        Class constructedClass = this.constructedClassCache.get(clazz);
        if (constructedClass != null) {
            return constructedClass;
        }
        if (clazz.isInterface()) {
            if (element instanceof Vertex) {
                classBuilder = new ByteBuddy().subclass(AbstractVertexFrame.class).implement(new Type[]{clazz});
            } else {
                if (!(element instanceof Edge)) throw new IllegalStateException("class is neither an Edge or a vertex!");
                classBuilder = new ByteBuddy().subclass(AbstractEdgeFrame.class).implement(new Type[]{clazz});
            }
        } else {
            if (!(element instanceof Vertex) && !(element instanceof Edge)) {
                throw new IllegalStateException("element is neither an edge nor a vertex");
            }
            if (element instanceof Vertex && !VertexFrame.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException(clazz.getName() + " Class is not a type of VertexFrame");
            }
            if (element instanceof Edge && !EdgeFrame.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException(clazz.getName() + " Class is not a type of EdgeFrame");
            }
            classBuilder = new ByteBuddy().subclass(clazz);
        }
        classBuilder = classBuilder.defineField("reflectionCache", ReflectionCache.class, new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.PLAIN}).implement(new Type[]{CachesReflection.class}).intercept((Implementation)FieldAccessor.ofBeanProperty());
        block0: for (Method method : clazz.getMethods()) {
            if (!AbstractAnnotationFrameFactory.isAbstract(method)) continue;
            for (Annotation annotation : method.getAnnotations()) {
                MethodHandler handler = this.methodHandlers.get(annotation.annotationType());
                if (handler == null) continue;
                classBuilder = handler.processMethod(classBuilder, method, annotation);
                continue block0;
            }
        }
        constructedClass = classBuilder.make().load(AnnotationFrameFactory.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
        this.constructedClassCache.put(clazz, constructedClass);
        return constructedClass;
    }
}

