/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.ferma;

import com.syncleus.ferma.annotations.GraphElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class ReflectionCache
extends Reflections {
    private final Map<String, Set<String>> hierarchy;
    private final Map<Method, Map<Class<Annotation>, Annotation>> annotationCache = new HashMap<Method, Map<Class<Annotation>, Annotation>>();
    private final Map<String, Class> classStringCache = new HashMap<String, Class>();

    public ReflectionCache() {
        this.hierarchy = new HashMap<String, Set<String>>();
    }

    public ReflectionCache(Collection<? extends Class<?>> annotatedTypes) {
        super((Configuration)ReflectionCache.assembleConfig(ReflectionCache.assembleClassUrls(annotatedTypes)));
        this.hierarchy = ReflectionCache.constructHierarchy(annotatedTypes);
    }

    public ReflectionCache(String modelPackage) {
        super(modelPackage, new Scanner[0]);
        this.hierarchy = ReflectionCache.constructHierarchy(this.getTypesAnnotatedWith(GraphElement.class));
    }

    public Set<? extends String> getSubTypeNames(Class<?> type) {
        Set<String> subtypes = this.hierarchy.get(type.getName());
        if (subtypes == null) {
            subtypes = Collections.singleton(type.getName());
        }
        return Collections.unmodifiableSet(subtypes);
    }

    public Set<? extends String> getSubTypeNames(String typeName) {
        Set<String> subtypes = this.hierarchy.get(typeName);
        if (subtypes == null) {
            subtypes = Collections.singleton(typeName);
        }
        return Collections.unmodifiableSet(subtypes);
    }

    public <E extends Annotation> E getAnnotation(Method method, Class<E> annotationType) {
        Annotation annotation;
        Map<Class<Annotation>, Annotation> annotationsPresent = this.annotationCache.get(method);
        if (annotationsPresent == null) {
            annotationsPresent = new HashMap<Class<Annotation>, Annotation>();
            this.annotationCache.put(method, annotationsPresent);
        }
        if ((annotation = annotationsPresent.get(annotationType)) == null) {
            annotation = method.getAnnotation(annotationType);
            annotationsPresent.put(annotationType, annotation);
        }
        return (E)annotation;
    }

    public Class forName(String className) {
        Class<?> type = this.classStringCache.get(className);
        if (type == null) {
            try {
                type = Class.forName(className);
                this.classStringCache.put(className, type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The class " + className + " cannot be found");
            }
        }
        return type;
    }

    private static ConfigurationBuilder assembleConfig(Set<URL> toScanUrls) {
        ConfigurationBuilder reflectionConfig = new ConfigurationBuilder();
        reflectionConfig.addUrls(toScanUrls);
        reflectionConfig.setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
        return reflectionConfig;
    }

    private static Set<URL> assembleClassUrls(Collection<? extends Class<?>> annotatedTypes) {
        if (annotatedTypes == null) {
            throw new IllegalArgumentException("annotatedTypes can not be null");
        }
        HashSet<URL> toScanUrls = new HashSet<URL>();
        for (Class<?> annotatedType : annotatedTypes) {
            toScanUrls.add(ClasspathHelper.forClass(annotatedType, (ClassLoader[])new ClassLoader[0]));
        }
        return toScanUrls;
    }

    private static Set<URL> assembleClassUrls(Collection<? extends Class<?>> annotatedTypes, Collection<?> packages) {
        HashSet<URL> toScanUrls = new HashSet<URL>();
        for (Class<?> annotatedType : annotatedTypes) {
            toScanUrls.add(ClasspathHelper.forClass(annotatedType, (ClassLoader[])new ClassLoader[0]));
        }
        for (Class<?> packageObj : packages) {
            toScanUrls.addAll(ClasspathHelper.forPackage((String)((Object)packageObj).toString(), (ClassLoader[])new ClassLoader[0]));
        }
        return toScanUrls;
    }

    private static Map<String, Set<String>> constructHierarchy(Collection<? extends Class<?>> types) {
        HashMap<String, Set<String>> hierarchy = new HashMap<String, Set<String>>();
        for (Class<?> parentType : types) {
            HashSet<String> children = (HashSet<String>)hierarchy.get(parentType.getName());
            if (children == null) {
                children = new HashSet<String>();
                hierarchy.put(parentType.getName(), children);
            }
            for (Class<?> childType : types) {
                if (!parentType.isAssignableFrom(childType)) continue;
                children.add(childType.getName());
            }
        }
        return hierarchy;
    }
}

