/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.ferma;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.syncleus.ferma.AbstractElementFrame;
import com.syncleus.ferma.ClassInitializer;
import com.syncleus.ferma.DefaultClassInitializer;
import com.syncleus.ferma.DefaultTraversable;
import com.syncleus.ferma.DelegatingTransaction;
import com.syncleus.ferma.ReflectionCache;
import com.syncleus.ferma.TEdge;
import com.syncleus.ferma.TVertex;
import com.syncleus.ferma.Traversable;
import com.syncleus.ferma.VertexFrame;
import com.syncleus.ferma.WrappedFramedGraph;
import com.syncleus.ferma.WrappedTransaction;
import com.syncleus.ferma.framefactories.DefaultFrameFactory;
import com.syncleus.ferma.framefactories.FrameFactory;
import com.syncleus.ferma.framefactories.annotation.AnnotationFrameFactory;
import com.syncleus.ferma.typeresolvers.PolymorphicTypeResolver;
import com.syncleus.ferma.typeresolvers.TypeResolver;
import com.syncleus.ferma.typeresolvers.UntypedTypeResolver;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class DelegatingFramedGraph<G extends Graph>
implements WrappedFramedGraph<G> {
    private final TypeResolver defaultResolver;
    private final TypeResolver untypedResolver;
    private final FrameFactory builder;
    private final G delegate;

    public G getBaseGraph() {
        return this.delegate;
    }

    public DelegatingFramedGraph(G delegate, FrameFactory builder, TypeResolver defaultResolver) {
        if (builder == null) {
            throw new IllegalArgumentException("builder can not be null");
        }
        if (defaultResolver == null) {
            throw new IllegalArgumentException("defaultResolver can not be null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate can not be null");
        }
        this.delegate = delegate;
        this.defaultResolver = defaultResolver;
        this.untypedResolver = new UntypedTypeResolver();
        this.builder = builder;
    }

    public DelegatingFramedGraph(G delegate) {
        this.delegate = delegate;
        this.untypedResolver = this.defaultResolver = new UntypedTypeResolver();
        this.builder = new DefaultFrameFactory();
    }

    public DelegatingFramedGraph(G delegate, TypeResolver defaultResolver) {
        this(delegate, new DefaultFrameFactory(), defaultResolver);
    }

    public DelegatingFramedGraph(G delegate, boolean typeResolution, boolean annotationsSupported) {
        this.delegate = delegate;
        ReflectionCache reflections = new ReflectionCache();
        if (typeResolution) {
            this.defaultResolver = new PolymorphicTypeResolver(reflections);
            this.untypedResolver = new UntypedTypeResolver();
        } else {
            this.untypedResolver = this.defaultResolver = new UntypedTypeResolver();
        }
        this.builder = annotationsSupported ? new AnnotationFrameFactory(reflections) : new DefaultFrameFactory();
    }

    public DelegatingFramedGraph(G delegate, ReflectionCache reflections, boolean typeResolution, boolean annotationsSupported) {
        this.delegate = delegate;
        if (reflections == null) {
            throw new IllegalArgumentException("reflections can not be null");
        }
        if (typeResolution) {
            this.defaultResolver = new PolymorphicTypeResolver(reflections);
            this.untypedResolver = new UntypedTypeResolver();
        } else {
            this.untypedResolver = this.defaultResolver = new UntypedTypeResolver();
        }
        this.builder = annotationsSupported ? new AnnotationFrameFactory(reflections) : new DefaultFrameFactory();
    }

    public DelegatingFramedGraph(G delegate, Collection<? extends Class<?>> types) {
        this(delegate, new ReflectionCache(types), true, true);
    }

    public DelegatingFramedGraph(G delegate, String modelPackage) {
        this(delegate, new ReflectionCache(modelPackage), true, true);
    }

    public DelegatingFramedGraph(G delegate, boolean typeResolution, Collection<? extends Class<?>> types) {
        this.delegate = delegate;
        if (types == null) {
            throw new IllegalArgumentException("types can not be null");
        }
        ReflectionCache reflections = new ReflectionCache(types);
        if (typeResolution) {
            this.defaultResolver = new PolymorphicTypeResolver(reflections);
            this.untypedResolver = new UntypedTypeResolver();
        } else {
            this.untypedResolver = this.defaultResolver = new UntypedTypeResolver();
        }
        this.builder = new AnnotationFrameFactory(reflections);
    }

    @Override
    public FrameFactory getBuilder() {
        return this.builder;
    }

    @Override
    public void close() throws IOException {
        try {
            this.getBaseGraph().close();
        }
        catch (Exception caught) {
            if (caught instanceof RuntimeException) {
                throw (RuntimeException)caught;
            }
            throw new IOException("Close malfunctioned:", caught);
        }
    }

    @Override
    public <T> T frameElement(Element e, Class<T> kind) {
        if (e == null) {
            return null;
        }
        Class<T> frameType = kind == TVertex.class || kind == TEdge.class ? kind : this.defaultResolver.resolve(e, kind);
        T frame = this.builder.create(e, frameType);
        ((AbstractElementFrame)frame).init(this, e);
        return frame;
    }

    @Override
    public <T> T frameNewElement(Element e, ClassInitializer<T> initializer) {
        T frame = this.frameElement(e, initializer.getInitializationType());
        this.defaultResolver.init(e, initializer.getInitializationType());
        ((AbstractElementFrame)frame).init();
        initializer.initalize(frame);
        return frame;
    }

    @Override
    public <T> T frameNewElement(Element e, Class<T> kind) {
        return this.frameNewElement(e, new DefaultClassInitializer<T>(kind));
    }

    @Override
    public <T> Iterator<? extends T> frame(Iterator<? extends Element> pipeline, final Class<T> kind) {
        return Iterators.transform(pipeline, (Function)new Function<Element, T>(){

            public T apply(Element input) {
                return DelegatingFramedGraph.this.frameElement(input, kind);
            }
        });
    }

    @Override
    public <T> T frameElementExplicit(Element e, Class<T> kind) {
        if (e == null) {
            return null;
        }
        Class<T> frameType = this.untypedResolver.resolve(e, kind);
        T frame = this.builder.create(e, frameType);
        ((AbstractElementFrame)frame).init(this, e);
        return frame;
    }

    @Override
    public <T> T frameNewElementExplicit(Element e, ClassInitializer<T> initializer) {
        T frame = this.frameElement(e, initializer.getInitializationType());
        this.untypedResolver.init(e, initializer.getInitializationType());
        ((AbstractElementFrame)frame).init();
        initializer.initalize(frame);
        return frame;
    }

    @Override
    public <T> T frameNewElementExplicit(Element e, Class<T> kind) {
        return this.frameNewElementExplicit(e, new DefaultClassInitializer<T>(kind));
    }

    @Override
    public <T> Iterator<? extends T> frameExplicit(Iterator<? extends Element> pipeline, final Class<T> kind) {
        return Iterators.transform(pipeline, (Function)new Function<Element, T>(){

            public T apply(Element input) {
                return DelegatingFramedGraph.this.frameElementExplicit(input, kind);
            }
        });
    }

    @Override
    public <T> T addFramedVertex(ClassInitializer<T> initializer, Object ... keyValues) {
        if (keyValues != null) {
            T framedVertex = this.frameNewElement((Element)this.getBaseGraph().addVertex(keyValues), initializer);
            return framedVertex;
        }
        T framedVertex = this.frameNewElement((Element)this.getBaseGraph().addVertex(new Object[0]), initializer);
        return framedVertex;
    }

    @Override
    public <T> T addFramedVertex(Class<T> kind) {
        return this.addFramedVertex(new DefaultClassInitializer<T>(kind), new Object[0]);
    }

    @Override
    public <T> T addFramedVertexExplicit(ClassInitializer<T> initializer) {
        T framedVertex = this.frameNewElementExplicit((Element)this.getBaseGraph().addVertex(new Object[0]), initializer);
        return framedVertex;
    }

    @Override
    public <T> T addFramedVertexExplicit(Class<T> kind) {
        return this.addFramedVertexExplicit(new DefaultClassInitializer<T>(kind));
    }

    @Override
    public TVertex addFramedVertex() {
        return this.addFramedVertex(TVertex.DEFAULT_INITIALIZER, new Object[0]);
    }

    @Override
    public TVertex addFramedVertexExplicit() {
        return this.addFramedVertexExplicit(TVertex.DEFAULT_INITIALIZER);
    }

    @Override
    public <T> T addFramedEdge(VertexFrame source, VertexFrame destination, String label, ClassInitializer<T> initializer, Object ... keyValues) {
        Edge baseEdge = source.getElement().addEdge(label, destination.getElement(), keyValues);
        T framedEdge = this.frameNewElement((Element)baseEdge, initializer);
        return framedEdge;
    }

    @Override
    public <T> T addFramedEdge(VertexFrame source, VertexFrame destination, String label, Class<T> kind) {
        return this.addFramedEdge(source, destination, label, new DefaultClassInitializer<T>(kind), new Object[0]);
    }

    @Override
    public <T> T addFramedEdgeExplicit(VertexFrame source, VertexFrame destination, String label, ClassInitializer<T> initializer) {
        T framedEdge = this.frameNewElementExplicit((Element)source.getElement().addEdge(label, destination.getElement(), new Object[0]), initializer);
        return framedEdge;
    }

    @Override
    public <T> T addFramedEdgeExplicit(VertexFrame source, VertexFrame destination, String label, Class<T> kind) {
        return this.addFramedEdgeExplicit(source, destination, label, new DefaultClassInitializer<T>(kind));
    }

    @Override
    public TEdge addFramedEdge(VertexFrame source, VertexFrame destination, String label) {
        return this.addFramedEdge(source, destination, label, TEdge.DEFAULT_INITIALIZER, new Object[0]);
    }

    @Override
    public TEdge addFramedEdgeExplicit(VertexFrame source, VertexFrame destination, String label) {
        return this.addFramedEdgeExplicit(source, destination, label, TEdge.DEFAULT_INITIALIZER);
    }

    @Override
    public <T extends Traversable<?, ?>> T traverse(java.util.function.Function<GraphTraversalSource, GraphTraversal<?, ?>> traverser) {
        return (T)new DefaultTraversable(traverser.apply(this.getBaseGraph().traversal()), this);
    }

    @Override
    public GraphTraversalSource getRawTraversal() {
        return this.getBaseGraph().traversal();
    }

    @Override
    public <T> T getFramedVertex(Class<T> kind, Object id) {
        return this.traverse(input -> input.V(new Object[]{id})).next(kind);
    }

    @Override
    public <T> T getFramedVertexExplicit(Class<T> kind, Object id) {
        return this.traverse(input -> input.V(new Object[]{id})).nextExplicit(kind);
    }

    @Override
    public <T> Iterator<? extends T> getFramedVertices(Class<T> kind) {
        T result = this.traverse(input -> input.V(new Object[0]));
        return result.frame(kind);
    }

    @Override
    public <T> Iterator<? extends T> getFramedVertices(String key, Object value, Class<T> kind) {
        return this.traverse(input -> input.V(new Object[0]).has(key, value)).frame(kind);
    }

    @Override
    public <T> Iterator<? extends T> getFramedVerticesExplicit(Class<T> kind) {
        return this.traverse(input -> input.V(new Object[0])).frameExplicit(kind);
    }

    @Override
    public <T> Iterator<? extends T> getFramedVerticesExplicit(String key, Object value, Class<T> kind) {
        return this.traverse(input -> input.V(new Object[0]).has(key, value)).frameExplicit(kind);
    }

    @Override
    public <T> Iterator<? extends T> getFramedEdges(Class<T> kind) {
        return this.traverse(input -> input.E(new Object[0])).frame(kind);
    }

    @Override
    public <T> Iterator<? extends T> getFramedEdges(String key, Object value, Class<T> kind) {
        return this.traverse(input -> input.E(new Object[0]).has(key, value)).frame(kind);
    }

    @Override
    public <T> Iterator<? extends T> getFramedEdgesExplicit(Class<T> kind) {
        return this.traverse(input -> input.E(new Object[0])).frameExplicit(kind);
    }

    @Override
    public <T> Iterator<? extends T> getFramedEdgesExplicit(String key, Object value, Class<T> kind) {
        return this.traverse(input -> input.E(new Object[0]).has(key, value)).frameExplicit(kind);
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.defaultResolver;
    }

    @Override
    public WrappedTransaction tx() {
        return new DelegatingTransaction(this.getBaseGraph().tx(), this);
    }
}

