/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SourceViewer
extends JPanel {
    private static final long serialVersionUID = -1688405955293925453L;
    private URL sourceURL = null;
    private final JTextField sourceCodeLocation;
    private final DefaultListModel<String> sourceCodeLinesList = new DefaultListModel();
    private final JList<String> sourceCodeLines = new JList<String>(this.sourceCodeLinesList);

    public SourceViewer() {
        super(new BorderLayout());
        this.sourceCodeLocation = new JTextField("Source code");
        this.add((Component)this.sourceCodeLocation, "First");
        this.add((Component)new JScrollPane(this.sourceCodeLines), "Center");
    }

    public void setSource(URL url) {
        this.setSource(url, -1);
    }

    public void setSource(URL url, int sourceLine) {
        boolean succsess = this.loadSource(url);
        if (succsess) {
            this.sourceCodeLocation.setText("Source code: " + url);
            if (sourceLine != -1) {
                this.sourceCodeLines.ensureIndexIsVisible(sourceLine - 1);
                this.sourceCodeLines.setSelectedIndex(sourceLine - 1);
                this.sourceCodeLines.validate();
            }
        } else {
            this.sourceCodeLocation.setText("Error loading source code from: " + url);
        }
    }

    private boolean loadSource(URL url) {
        if (url == null) {
            if (this.sourceURL != null) {
                this.sourceCodeLinesList.clear();
            }
            return false;
        }
        if (url.toString().equals(this.sourceURL.toString())) {
            return true;
        }
        this.sourceCodeLinesList.clear();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((line = br.readLine()) != null) {
                this.sourceCodeLinesList.addElement(line.replaceAll("\t", "   "));
            }
            br.close();
            return true;
        }
        catch (IOException e) {
            System.err.println("Could not load source at " + url);
            return false;
        }
    }

    public void removeSelection() {
        int curSelectedIndex = this.sourceCodeLines.getSelectedIndex();
        this.sourceCodeLines.removeSelectionInterval(curSelectedIndex, curSelectedIndex);
    }

    public void removeSource() {
        this.sourceURL = null;
        this.sourceCodeLocation.setText("Source code");
        this.sourceCodeLinesList.clear();
        this.sourceCodeLines.validate();
    }
}

