/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.cfg.exceptionpruning.filter;

import com.ibm.wala.analysis.nullpointer.IntraproceduralNullPointerAnalysis;
import com.ibm.wala.cfg.exc.intra.NullPointerState;
import com.ibm.wala.ipa.cfg.exceptionpruning.ExceptionFilter;
import com.ibm.wala.ipa.cfg.exceptionpruning.FilteredException;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class NullPointerExceptionFilter
implements ExceptionFilter<SSAInstruction> {
    private final IntraproceduralNullPointerAnalysis analysis;

    public NullPointerExceptionFilter(IntraproceduralNullPointerAnalysis analysis) {
        this.analysis = analysis;
    }

    @Override
    public boolean alwaysThrowsException(SSAInstruction instruction) {
        return this.analysis.nullPointerExceptionThrowState(instruction) == NullPointerState.State.NULL;
    }

    @Override
    public Collection<FilteredException> filteredExceptions(SSAInstruction instruction) {
        if (this.analysis.nullPointerExceptionThrowState(instruction) == NullPointerState.State.NOT_NULL) {
            LinkedList<FilteredException> result = new LinkedList<FilteredException>();
            result.add(new FilteredException(TypeReference.JavaLangNullPointerException));
            return result;
        }
        return Collections.emptyList();
    }
}

