/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.pruned;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.pruned.ApplicationLoaderPolicy;
import com.ibm.wala.ipa.callgraph.pruned.PruningPolicy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class CallGraphPruning {
    private PruningPolicy pruningPolicy;
    private Set<CGNode> keep;
    private LinkedList<CGNode> visited;
    private List<CGNode> marked;
    private int depth;
    private final CallGraph cg;
    private final boolean DEBUG = false;

    public CallGraphPruning(CallGraph cg) {
        this.cg = cg;
    }

    public Set<CGNode> findApplicationNodes() {
        return this.findApplicationNodes(0);
    }

    public Set<CGNode> findApplicationNodes(int depth) {
        return this.findNodes(depth, ApplicationLoaderPolicy.INSTANCE);
    }

    public Set<CGNode> findNodes(int depth, PruningPolicy policy) {
        this.marked = new LinkedList<CGNode>();
        this.keep = new HashSet<CGNode>();
        this.visited = new LinkedList();
        this.depth = depth;
        this.pruningPolicy = policy;
        this.dfs(this.cg.getFakeRootNode());
        return this.keep;
    }

    private void dfs(CGNode root) {
        this.visited.addLast(root);
        Iterator it = this.cg.getSuccNodes(root);
        while (it.hasNext()) {
            CGNode next = (CGNode)it.next();
            if (!this.marked.contains(next)) {
                this.marked.add(next);
                this.dfs(next);
                continue;
            }
            if (!this.keep.contains(next)) continue;
            this.keep.addAll(this.visited);
        }
        if (this.pruningPolicy.check(root)) {
            this.keep.addAll(this.visited);
            this.addDepth(root);
        }
        this.visited.removeLast();
    }

    private void addDepth(CGNode node) {
        LinkedList<CGNode> A = new LinkedList<CGNode>();
        LinkedList B = new LinkedList();
        A.add(node);
        for (int i = this.depth; i > 0; --i) {
            for (CGNode n : A) {
                Iterator it = this.cg.getSuccNodes(n);
                while (it.hasNext()) {
                    B.add(it.next());
                }
            }
            this.keep.addAll(B);
            A.clear();
            A.addAll(B);
            B.clear();
        }
    }
}

