/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.drivers;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.CallGraphStats;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.io.CommandLine;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.util.warnings.Warnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class ScopeFileCallGraph {
    public static void main(String[] args) throws IOException, ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException {
        long start = System.currentTimeMillis();
        Properties p = CommandLine.parse((String[])args);
        String scopeFile = p.getProperty("scopeFile");
        String entryClass = p.getProperty("entryClass");
        String mainClass = p.getProperty("mainClass");
        String dump = p.getProperty("dump");
        if (mainClass != null && entryClass != null) {
            throw new IllegalArgumentException("only specify one of mainClass or entryClass");
        }
        File exclusionsFile = null;
        AnalysisScope scope = AnalysisScopeReader.readJavaScope(scopeFile, exclusionsFile, ScopeFileCallGraph.class.getClassLoader());
        ClassHierarchy cha = ClassHierarchyFactory.make(scope);
        System.out.println(cha.getNumberOfClasses() + " classes");
        System.out.println(Warnings.asString());
        Warnings.clear();
        AnalysisOptions options = new AnalysisOptions();
        Iterable<Entrypoint> entrypoints = entryClass != null ? ScopeFileCallGraph.makePublicEntrypoints(cha, entryClass) : Util.makeMainEntrypoints(scope, (IClassHierarchy)cha, mainClass);
        options.setEntrypoints(entrypoints);
        options.setReflectionOptions(AnalysisOptions.ReflectionOptions.NONE);
        AnalysisCacheImpl cache = new AnalysisCacheImpl();
        SSAPropagationCallGraphBuilder builder = Util.makeZeroOneContainerCFABuilder(options, cache, cha, scope);
        System.out.println("building call graph...");
        CallGraph cg = builder.makeCallGraph(options, null);
        long end = System.currentTimeMillis();
        System.out.println("done");
        if (dump != null) {
            System.err.println(cg);
        }
        System.out.println("took " + (end - start) + "ms");
        System.out.println(CallGraphStats.getStats(cg));
    }

    private static Iterable<Entrypoint> makePublicEntrypoints(IClassHierarchy cha, String entryClass) {
        ArrayList<Entrypoint> result = new ArrayList<Entrypoint>();
        IClass klass = cha.lookupClass(TypeReference.findOrCreate(ClassLoaderReference.Application, StringStuff.deployment2CanonicalTypeString(entryClass)));
        for (IMethod iMethod : klass.getDeclaredMethods()) {
            if (!iMethod.isPublic()) continue;
            result.add(new DefaultEntrypoint(iMethod, cha));
        }
        return result;
    }
}

