/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.ssa;

import com.ibm.wala.fixedpoint.impl.DefaultFixedPointSolver;
import com.ibm.wala.fixedpoint.impl.NullaryOperator;
import com.ibm.wala.fixpoint.AbstractOperator;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.util.ArrayList;
import java.util.List;

public abstract class SSAInference<T extends IVariable<T>>
extends DefaultFixedPointSolver<T> {
    static final boolean DEBUG = false;
    private IR ir;
    private SymbolTable symbolTable;
    private List<IVariable<T>> vars;

    protected void init(IR ir, VariableFactory<T> varFactory, OperatorFactory<T> opFactory) {
        this.ir = ir;
        this.symbolTable = ir.getSymbolTable();
        this.createVariables(varFactory);
        this.createEquations(opFactory);
    }

    private void createEquations(OperatorFactory<T> opFactory) {
        SSAInstruction[] instructions = this.ir.getInstructions();
        for (SSAInstruction s : instructions) {
            this.makeEquationForInstruction(opFactory, s);
        }
        for (SSAInstruction s : Iterator2Iterable.make(this.ir.iteratePhis())) {
            this.makeEquationForInstruction(opFactory, s);
        }
        for (SSAInstruction s : Iterator2Iterable.make(this.ir.iteratePis())) {
            this.makeEquationForInstruction(opFactory, s);
        }
        for (SSAInstruction s : Iterator2Iterable.make(this.ir.iterateCatchInstructions())) {
            this.makeEquationForInstruction(opFactory, s);
        }
    }

    private void makeEquationForInstruction(OperatorFactory<T> opFactory, SSAInstruction s) {
        AbstractOperator<T> op;
        if (s != null && s.hasDef() && (op = opFactory.get(s)) != null) {
            T def = this.getVariable(s.getDef());
            if (op instanceof NullaryOperator) {
                this.newStatement((IVariable)def, (NullaryOperator)op, false, false);
            } else {
                int n = s.getNumberOfUses();
                IVariable[] uses = this.makeStmtRHS(n);
                for (int j = 0; j < n; ++j) {
                    if (s.getUse(j) <= -1) continue;
                    uses[j] = this.getVariable(s.getUse(j));
                    assert (uses[j] != null);
                }
                this.newStatement((IVariable)def, (AbstractOperator)op, uses, false, false);
            }
        }
    }

    private void createVariables(VariableFactory<T> factory) {
        int varsCount = this.symbolTable.getMaxValueNumber() + 1;
        this.vars = new ArrayList<IVariable<T>>(varsCount);
        this.vars.add(null);
        for (int i = 1; i < varsCount; ++i) {
            this.vars.add(factory.makeVariable(i));
        }
    }

    protected T getVariable(int valueNumber) {
        if (valueNumber < 0) {
            throw new IllegalArgumentException("Illegal valueNumber " + valueNumber);
        }
        assert (this.vars != null) : "null vars array";
        return (T)this.vars.get(valueNumber);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Type inference : \n");
        for (int i = 0; i < this.vars.size(); ++i) {
            result.append('v').append(i).append("  ").append(this.vars.get(i)).append('\n');
        }
        return result.toString();
    }

    public static interface VariableFactory<T extends IVariable<T>> {
        public IVariable<T> makeVariable(int var1);
    }

    public static interface OperatorFactory<T extends IVariable<T>> {
        public AbstractOperator<T> get(SSAInstruction var1);
    }
}

