/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva.irgen;

import com.ibm.wala.cast.java.translator.SourceModuleTranslator;
import com.ibm.wala.cast.java.translator.jdt.ecj.ECJSourceLoaderImpl;
import com.ibm.wala.cast.java.translator.jdt.ecj.ECJSourceModuleTranslator;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashMapFactory;
import io.tackle.diva.irgen.DivaIRGen;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DivaSourceLoaderImpl
extends ECJSourceLoaderImpl {
    private final String[] stdlibs;
    Map<String, ModuleEntry> sourceMap = HashMapFactory.make();
    int countdown;
    String[] jdtDirs;

    public DivaSourceLoaderImpl(ClassLoaderReference loaderRef, IClassLoader parent, IClassHierarchy cha, String[] stdlibs) {
        super(loaderRef, parent, cha, false);
        this.stdlibs = stdlibs;
        this.countdown = cha.getScope().getModules(loaderRef).size();
        ArrayList<String> jdtDirList = new ArrayList<String>();
        for (ClassLoaderReference clref = loaderRef; clref != ClassLoaderReference.Application; clref = clref.getParent()) {
            List modules = cha.getScope().getModules(clref);
            for (Module m : modules) {
                jdtDirList.add(((SourceDirectoryTreeModule)m).getPath());
            }
        }
        this.jdtDirs = jdtDirList.toArray(new String[jdtDirList.size()]);
    }

    protected SourceModuleTranslator getTranslator() {
        return new ECJSourceModuleTranslator(this.cha.getScope(), this, false){

            public void loadAllSources(Set<ModuleEntry> sourceFiles) {
                for (ModuleEntry m : sourceFiles) {
                    if (!m.isSourceFile()) continue;
                    SourceFileModule s = (SourceFileModule)m;
                    DivaSourceLoaderImpl.this.sourceMap.put(s.getAbsolutePath(), (ModuleEntry)s);
                }
                if (--DivaSourceLoaderImpl.this.countdown > 0) {
                    return;
                }
                DivaIRGen irgen = new DivaIRGen((IClassLoader)DivaSourceLoaderImpl.this, c -> DivaSourceLoaderImpl.this.loadedClasses.put(c.getName(), c));
                irgen.genIR(DivaSourceLoaderImpl.this.cha, DivaSourceLoaderImpl.this.sourceMap, DivaSourceLoaderImpl.this.stdlibs, DivaSourceLoaderImpl.this.jdtDirs, (arg_0, arg_1) -> (this).makeCAstTranslator(arg_0, arg_1), () -> (this).makeIRTranslator());
            }
        };
    }
}

