/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva.analysis;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableIntSet;
import io.tackle.diva.Constants;
import io.tackle.diva.Context;
import io.tackle.diva.Framework;
import io.tackle.diva.Trace;
import io.tackle.diva.analysis.PointerAnalysis;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class JDBCAnalysis {
    static Logger logger = Logger.getLogger(JDBCAnalysis.class.getName());

    public static boolean checkRelevance(IClass c) {
        return c.getName() == Constants.LJavaSqlConnection;
    }

    public static Context.CallSiteVisitor getTransactionAnalysis(final Framework fw, Context context) {
        Context context2 = context;
        context2.getClass();
        return new Context.CallSiteVisitor(context2){

            @Override
            public void visitCallSite(Trace trace) {
                CGNode node = trace.node();
                CallSiteReference site = trace.site();
                MethodReference ref = site.getDeclaredTarget();
                Trace.Val sql = null;
                ArrayList<Trace.Val> seeds = null;
                if (ref.getDeclaringClass().getName() == Constants.LJavaSqlPreparedStatement && (ref.getName() == Constants.executeQuery || ref.getName() == Constants.executeUpdate) && ref.getNumberOfParameters() == 0 || ref.getDeclaringClass().getName() == Constants.LJavaSqlCallableStatement && ref.getName() == Constants.execute) {
                    if (fw.usageAnalysis) {
                        seeds = new ArrayList<Trace.Val>();
                    }
                    sql = JDBCAnalysis.analyzeJdbc(fw, trace, site, seeds);
                } else if (ref.getDeclaringClass().getName() == Constants.LJavaSqlStatement && (ref.getName() == Constants.executeQuery || ref.getName() == Constants.executeUpdate) && ref.getNumberOfParameters() == 1) {
                    SSAAbstractInvokeInstruction instr = trace.instrFromSite(site);
                    sql = trace.getDef(instr.getUse(1));
                }
                if (sql != null) {
                    if (!fw.txStarted()) {
                        fw.reportSqlStatement(trace, "BEGIN");
                    }
                    IntSet uses = null;
                    if (seeds != null && !seeds.isEmpty()) {
                        uses = JDBCAnalysis.getUsingOps(fw, seeds);
                    }
                    JDBCAnalysis.analyzeSqlStatement(fw, trace, sql, uses);
                }
                if (fw.txStarted() && ref.getDeclaringClass().getName() == Constants.LJavaSqlConnection) {
                    if (ref.getName() == Constants.commit) {
                        fw.reportSqlStatement(trace, "COMMIT");
                        fw.reportTxBoundary();
                    } else if (ref.getName() == Constants.rollback) {
                        fw.reportSqlStatement(trace, "ROLLBACK");
                        fw.reportTxBoundary();
                    }
                }
            }
        };
    }

    public static Trace.Val analyzeJdbc(Framework fw, Trace trace, CallSiteReference site, List<Trace.Val> uses) {
        Trace trace2 = trace;
        trace2.getClass();
        Trace.Val sql = new Trace.Val(trace2, "??");
        SSAAbstractInvokeInstruction instr = trace.instrFromSite(site);
        HashSet<IntPair> visited = new HashSet<IntPair>();
        int self = instr.getUse(0);
        Trace.Val v = trace.getReceiverUseOrDef((SSAInstruction)instr, visited);
        block0: while (v != null && v.isInstr()) {
            SSAAbstractInvokeInstruction invoke;
            MethodReference mref;
            instr = v.instr();
            if (instr instanceof SSAPhiInstruction) {
                IntPair key = null;
                for (int k = 0; k < 2; ++k) {
                    Trace.Val vk = v.getDef(instr.getUse(k));
                    if (vk.isConstant()) continue;
                    int bbid = vk.trace().node().getIR().getBasicBlockForInstruction(vk.instr()).getNumber();
                    key = IntPair.make((int)v.trace().node().getGraphNodeId(), (int)bbid);
                    if (visited.contains(key)) continue;
                    visited.add(key);
                    v = vk;
                    continue block0;
                }
                break;
            }
            if (instr instanceof SSAGetInstruction) {
                v = PointerAnalysis.fromInits(fw, v.trace(), (SSAGetInstruction)instr);
                continue;
            }
            if (instr instanceof SSAReturnInstruction) {
                self = instr.getUse(0);
                v = v.getReceiverUseOrDef(visited);
                continue;
            }
            if (instr instanceof SSAAbstractInvokeInstruction && instr.getNumberOfUses() > 0 && instr.getUse(0) == self) {
                Trace.Val d;
                MethodReference mref2;
                if (uses != null && ((mref2 = instr.getDeclaredTarget()).getName() == Constants.setInt || mref2.getName() == Constants.setString || mref2.getName() == Constants.setBigDecimal || mref2.getName() == Constants.getFloat || mref2.getName() == Constants.getDouble) && (d = v.getDef(instr.getUse(2))) != null) {
                    uses.add(d);
                }
                v = v.getReceiverUseOrDef(visited);
                continue;
            }
            if (!(instr instanceof SSAAbstractInvokeInstruction) || (mref = (invoke = instr).getDeclaredTarget()).getDeclaringClass().getName() != Constants.LJavaSqlConnection || mref.getName() != Constants.prepareStatement && mref.getName() != Constants.prepareCall) break;
            sql = v.getDef(instr.getUse(1));
            break;
        }
        return sql;
    }

    public static void analyzeSqlStatement(Framework fw, Trace trace, Trace.Val v) {
        JDBCAnalysis.analyzeSqlStatement(fw, trace, v, null);
    }

    public static void analyzeSqlStatement(Framework fw, Trace trace, Trace.Val v, IntSet uses) {
        if (v.isConstant()) {
            fw.reportSqlStatement(trace, (String)v.constant(), uses);
        } else {
            fw.reportSqlStatement(trace, JDBCAnalysis.calculateReachingString(fw, v, new HashSet<IntPair>()), uses);
        }
    }

    public static SSAAbstractInvokeInstruction getConstructorForNew(IR ir, SSANewInstruction alloc) {
        for (int i = alloc.iIndex() + 1; i < ir.getInstructions().length; ++i) {
            SSAInstruction instr = ir.getInstructions()[i];
            if (instr == null || !(instr instanceof SSAAbstractInvokeInstruction) || instr.getNumberOfUses() == 0 || instr.getUse(0) != alloc.getDef()) continue;
            SSAAbstractInvokeInstruction constr = (SSAAbstractInvokeInstruction)instr;
            if (constr.getDeclaredTarget().getName() != Constants.theInit) {
                return null;
            }
            return constr;
        }
        return null;
    }

    public static String calculateReachingString(Framework fw, Trace.Val value, Set<IntPair> visited) {
        if (value == null || value.isParam()) {
            return "??";
        }
        if (value.isConstant()) {
            if (value.constant() == null) {
                return "??";
            }
            return value.constant().toString();
        }
        SSAInstruction instr = value.instr();
        if (instr instanceof SSABinaryOpInstruction) {
            SSABinaryOpInstruction bin = (SSABinaryOpInstruction)instr;
            if (bin.getOperator() == IBinaryOpInstruction.Operator.ADD) {
                return JDBCAnalysis.calculateReachingString(fw, value.getDef(bin.getUse(0)), visited) + JDBCAnalysis.calculateReachingString(fw, value.getDef(bin.getUse(1)), new HashSet<IntPair>());
            }
        } else if (instr instanceof SSAGetInstruction) {
            Trace.Val v = PointerAnalysis.fromInits(fw, value.trace(), (SSAGetInstruction)instr);
            if (v != null) {
                return JDBCAnalysis.calculateReachingString(fw, v, visited);
            }
        } else {
            if (instr instanceof SSAPhiInstruction) {
                SSAPhiInstruction phi = (SSAPhiInstruction)instr;
                Trace.Val lhs = value.getDef(phi.getUse(0));
                Trace.Val rhs = value.getDef(phi.getUse(1));
                if (lhs.isConstant()) {
                    return JDBCAnalysis.calculateReachingString(fw, lhs, visited);
                }
                if (rhs.isConstant()) {
                    return JDBCAnalysis.calculateReachingString(fw, rhs, visited);
                }
                int bbid = lhs.trace().node().getIR().getBasicBlockForInstruction(lhs.instr()).getNumber();
                IntPair key = IntPair.make((int)value.trace().node().getGraphNodeId(), (int)bbid);
                if (visited.contains(key)) {
                    return JDBCAnalysis.calculateReachingString(fw, rhs, visited);
                }
                visited.add(key);
                return JDBCAnalysis.calculateReachingString(fw, lhs, visited);
            }
            if (instr instanceof SSAAbstractInvokeInstruction) {
                MethodReference mref = ((SSAAbstractInvokeInstruction)instr).getDeclaredTarget();
                if (mref.getDeclaringClass().getName() == Constants.LJavaLangStringBuffer || mref.getDeclaringClass().getName() == Constants.LJavaLangStringBuilder) {
                    if (mref.getName() == Constants.toString) {
                        Trace.Val lastVal = value.getReceiverUseOrDef(visited);
                        return JDBCAnalysis.calculateReachingString(fw, lastVal, visited);
                    }
                    if (mref.getName() == Constants.append) {
                        Trace.Val lastVal = value.getReceiverUseOrDef(visited);
                        return JDBCAnalysis.calculateReachingString(fw, lastVal, visited) + JDBCAnalysis.calculateReachingString(fw, value.getDef(instr.getUse(1)), new HashSet<IntPair>());
                    }
                    if (mref.getName() == Constants.theInit) {
                        if (mref.getNumberOfParameters() == 0) {
                            return "";
                        }
                        if (mref.getParameterType(0).isPrimitiveType()) {
                            return "";
                        }
                        return JDBCAnalysis.calculateReachingString(fw, value.getDef(instr.getUse(1)), visited);
                    }
                }
            } else if (instr instanceof SSANewInstruction) {
                SSAAbstractInvokeInstruction constr;
                SSANewInstruction alloc = (SSANewInstruction)instr;
                if (alloc.getConcreteType().getName() == Constants.LJavaLangString && (constr = JDBCAnalysis.getConstructorForNew(value.trace().node().getIR(), alloc)).getNumberOfUses() == 2) {
                    return JDBCAnalysis.calculateReachingString(fw, value.trace().getDef(constr.getUse(1)), visited);
                }
            } else if (instr instanceof SSAReturnInstruction) {
                Trace.Val lastVal = value.getReceiverUseOrDef(visited);
                return JDBCAnalysis.calculateReachingString(fw, lastVal, visited);
            }
        }
        return "??";
    }

    public static IntSet getUsingOps(Framework fw, List<Trace.Val> seeds) {
        BitVectorIntSet ops = new BitVectorIntSet();
        JDBCAnalysis.getDataflowSources(fw, seeds, (arg_0, arg_1) -> JDBCAnalysis.lambda$getUsingOps$0(fw, (MutableIntSet)ops, arg_0, arg_1));
        return ops;
    }

    public static void getDataflowSources(Framework fw, List<Trace.Val> seeds, BiConsumer<Trace.Val, Consumer<Trace.Val>> cont) {
        HashSet visited = new HashSet();
        Stack<Trace.Val> todo = new Stack<Trace.Val>();
        todo.addAll(seeds);
        Consumer<Trace.Val> handler = v -> {
            IntPair key;
            if (v != null && v.isInstr() && !visited.contains(key = IntPair.make((int)v.trace().node().getGraphNodeId(), (int)v.instr().iIndex()))) {
                visited.add(key);
                todo.push((Trace.Val)v);
            }
        };
        while (!todo.isEmpty()) {
            Trace.Val v2 = (Trace.Val)todo.pop();
            if (v2.isConstant()) {
                cont.accept(v2, handler);
                continue;
            }
            SSAInstruction instr = v2.instr();
            if (instr instanceof SSAGetInstruction) {
                v2 = PointerAnalysis.fromInits(fw, v2.trace(), (SSAGetInstruction)instr);
                handler.accept(v2);
                continue;
            }
            if (instr instanceof SSAPhiInstruction) {
                SSAPhiInstruction phi = (SSAPhiInstruction)instr;
                handler.accept(v2.getDef(phi.getUse(0)));
                handler.accept(v2.getDef(phi.getUse(1)));
                continue;
            }
            if (instr instanceof SSABinaryOpInstruction) {
                handler.accept(v2.getDef(instr.getUse(0)));
                handler.accept(v2.getDef(instr.getUse(1)));
                continue;
            }
            if (instr instanceof SSACheckCastInstruction) {
                handler.accept(v2.getDef(instr.getUse(0)));
                continue;
            }
            if (instr instanceof SSANewInstruction) {
                SSAAbstractInvokeInstruction constr;
                SSANewInstruction alloc = (SSANewInstruction)instr;
                if (alloc.getConcreteType().getName() != Constants.LJavaLangString && alloc.getConcreteType().getName() != Constants.LJavaLangInteger || (constr = JDBCAnalysis.getConstructorForNew(v2.trace().node().getIR(), alloc)).getNumberOfUses() != 2) continue;
                handler.accept(v2.trace().getDef(constr.getUse(1)));
                continue;
            }
            if (instr instanceof SSAAbstractInvokeInstruction) {
                MethodReference mref = ((SSAAbstractInvokeInstruction)instr).getDeclaredTarget();
                if (instr.getNumberOfUses() == 1 && (mref.getName() == Constants.toString || mref.getName() == Constants.intValue || mref.getName() == Constants.longValue || mref.getName() == Constants.floatValue || mref.getName() == Constants.doubleValue)) {
                    handler.accept(v2.getDef(instr.getUse(0)));
                    continue;
                }
                cont.accept(v2, handler);
                continue;
            }
            cont.accept(v2, handler);
        }
    }

    private static /* synthetic */ void lambda$getUsingOps$0(Framework fw, MutableIntSet ops, Trace.Val v, Consumer h) {
        Trace.Val query;
        MethodReference mref;
        if (!v.isInstr()) {
            return;
        }
        SSAInstruction instr = v.instr();
        if (instr instanceof SSAAbstractInvokeInstruction && (mref = ((SSAAbstractInvokeInstruction)instr).getDeclaredTarget()).getDeclaringClass().getName() == Constants.LJavaSqlResultSet && (mref.getName() == Constants.getInt || mref.getName() == Constants.getString || mref.getName() == Constants.getFloat || mref.getName() == Constants.getDouble || mref.getName() == Constants.getBigDecimal) && (query = v.getDef(instr.getUse(0))).isInstr() && query.instr() instanceof SSAAbstractInvokeInstruction) {
            CallSiteReference site = ((SSAAbstractInvokeInstruction)query.instr()).getCallSite();
            int op = fw.callSiteToOp.getOrDefault(query.trace().updateSite(site), -1);
            if (op >= 0) {
                ops.add(op);
            }
        }
    }
}

