/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva;

import com.ibm.wala.cast.java.ipa.callgraph.JavaSourceAnalysisScope;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntPair;
import io.tackle.diva.Context;
import io.tackle.diva.Framework;
import io.tackle.diva.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Trace
extends Util.Chain<Trace> {
    final CallSiteReference site;
    final Cache cache;

    public CGNode node() {
        return this.cache.node;
    }

    public Trace parent() {
        return (Trace)this.next;
    }

    public CallSiteReference site() {
        return this.site;
    }

    public Context context() {
        return this.cache.context;
    }

    public Map<CallSiteReference, Trace> callLog() {
        return this.cache.callLog;
    }

    public Trace updateSite(CallSiteReference site) {
        if (this.cache.callLog != null && this.cache.callLog.containsKey(site)) {
            return (Trace)this.cache.callLog.get((Object)site).next;
        }
        return new Trace(this.cache, site, (Trace)this.next);
    }

    public void logCall(Trace callee) {
        if (this.site == null) {
            return;
        }
        if (this.cache.callLog == null) {
            this.cache.callLog = new HashMap<CallSiteReference, Trace>();
        }
        this.cache.callLog.put(this.site, callee);
    }

    public void setContext(Context context) {
        this.cache.context = context;
    }

    private Trace(Cache cache, CallSiteReference site, Trace next) {
        super(next);
        this.cache = cache;
        this.site = site;
    }

    public Trace(CGNode node, Trace parent) {
        super(parent);
        this.cache = new Cache(node);
        this.site = null;
    }

    public void populateUd() {
        IR ir = this.cache.node.getIR();
        if (ir == null) {
            return;
        }
        this.cache.ud = new Object[ir.getSymbolTable().getMaxValueNumber() + 1];
        SSAInstruction[] instrs = ir.getInstructions();
        for (SSAInstruction instr : instrs) {
            if (instr == null || !instr.hasDef()) continue;
            this.cache.ud[instr.getDef((int)0)] = instr;
        }
        for (ISSABasicBlock bb : () -> ir.getBlocks()) {
            for (SSAPhiInstruction phi : () -> bb.iteratePhis()) {
                this.cache.ud[phi.getDef()] = phi;
            }
        }
        int param = 0;
        for (int i : ir.getParameterValueNumbers()) {
            this.cache.ud[i] = param++;
        }
    }

    public Val getDef(int number) {
        SSAAbstractInvokeInstruction caller;
        Trace callerTrace;
        IR ir = this.cache.node.getIR();
        if (ir == null) {
            return null;
        }
        SymbolTable sym = ir.getSymbolTable();
        if (sym.isConstant(number)) {
            return new Val(sym.getConstantValue(number));
        }
        if (this.cache.ud == null) {
            this.populateUd();
        }
        if (this.cache.ud[number] instanceof SSAAbstractInvokeInstruction) {
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)this.cache.ud[number];
            if (this.cache.callLog != null && this.cache.callLog.containsKey(invoke.getCallSite())) {
                Trace calleeTrace = this.cache.callLog.get(invoke.getCallSite());
                SSAInstruction[] instrs = calleeTrace.node().getIR().getInstructions();
                for (int i = instrs.length - 1; i >= 0; --i) {
                    if (instrs[i] == null || !(instrs[i] instanceof SSAReturnInstruction)) continue;
                    Val v = calleeTrace.getDef(((SSAReturnInstruction)instrs[i]).getUse(0));
                    return v;
                }
            }
        }
        if (this.cache.ud[number] instanceof SSAInstruction) {
            return new Val(this.cache.ud[number]);
        }
        if (this.cache.ud[number] instanceof Integer && (callerTrace = (Trace)this.next) != null && (caller = callerTrace.instrFromSite(callerTrace.site)) != null && (Integer)this.cache.ud[number] < caller.getNumberOfUses()) {
            return callerTrace.getDef(caller.getUse(((Integer)this.cache.ud[number]).intValue()));
        }
        return null;
    }

    public Val getDefOrParam(int number) {
        IR ir = this.cache.node.getIR();
        if (ir == null) {
            return null;
        }
        SymbolTable sym = ir.getSymbolTable();
        if (sym.isConstant(number)) {
            return new Val(sym.getConstantValue(number));
        }
        if (this.cache.ud == null) {
            this.populateUd();
        }
        if (this.cache.ud[number] instanceof SSAAbstractInvokeInstruction) {
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)this.cache.ud[number];
            if (this.cache.callLog != null && this.cache.callLog.containsKey(invoke.getCallSite())) {
                Trace calleeTrace = this.cache.callLog.get(invoke.getCallSite());
                SSAInstruction[] instrs = calleeTrace.node().getIR().getInstructions();
                for (int i = instrs.length - 1; i >= 0; --i) {
                    if (instrs[i] == null || !(instrs[i] instanceof SSAReturnInstruction)) continue;
                    Val v = calleeTrace.getDef(((SSAReturnInstruction)instrs[i]).getUse(0));
                    return v;
                }
            }
        }
        if (this.cache.ud[number] instanceof SSAInstruction) {
            return new Val(this.cache.ud[number]);
        }
        if (this.cache.ud[number] instanceof Integer) {
            SSAAbstractInvokeInstruction caller;
            Trace callerTrace = (Trace)this.next;
            if (callerTrace != null && (caller = callerTrace.instrFromSite(callerTrace.site)) != null && (Integer)this.cache.ud[number] < caller.getNumberOfUses()) {
                return callerTrace.getDefOrParam(caller.getUse(((Integer)this.cache.ud[number]).intValue()));
            }
            return new ParamVal(this.cache.ud[number]);
        }
        return null;
    }

    public TypeReference inferType(SSAInstruction instr) {
        TypeReference ref = null;
        if (instr instanceof SSAGetInstruction) {
            ref = ((SSAGetInstruction)instr).getDeclaredFieldType();
        }
        if (instr instanceof SSANewInstruction) {
            ref = ((SSANewInstruction)instr).getConcreteType();
        }
        if (instr instanceof SSAAbstractInvokeInstruction) {
            ref = ((SSAAbstractInvokeInstruction)instr).getDeclaredResultType();
        }
        if (instr instanceof SSACheckCastInstruction) {
            ref = ((SSACheckCastInstruction)instr).getDeclaredResultType();
        }
        return ref;
    }

    public TypeReference inferType(Val value) {
        if (value == null) {
            return null;
        }
        if (value.isConstant()) {
            return null;
        }
        if (value.isParam()) {
            return value.trace().node().getMethod().getParameterType(value.param());
        }
        return this.inferType(value.instr());
    }

    public TypeReference inferType(int number) {
        return this.inferType(this.getDefOrParam(number));
    }

    public IClass inferType(Framework fw, int number) {
        TypeReference ref = this.inferType(number);
        if (ref == null) {
            return null;
        }
        return fw.classHierarchy().lookupClass(ref);
    }

    public SSAAbstractInvokeInstruction instrFromSite(CallSiteReference site) {
        if (this.cache.node.getMethod().getDeclaringClass().getClassLoader().getReference() == JavaSourceAnalysisScope.SOURCE) {
            return this.cache.node.getIR().getCalls(site)[0];
        }
        for (SSAInstruction i : this.cache.node.getIR().getInstructions()) {
            SSAAbstractInvokeInstruction instr;
            if (!(i instanceof SSAAbstractInvokeInstruction) || (instr = (SSAAbstractInvokeInstruction)i).getCallSite() != site) continue;
            return instr;
        }
        return null;
    }

    public boolean in(Framework fw, CallSiteReference site) {
        return this.in(fw, (SSAInstruction)this.instrFromSite(site));
    }

    public boolean in(Framework fw, SSAInstruction instr) {
        if (this.cache.context == null) {
            return true;
        }
        if (instr == null || instr.iIndex() < 0) {
            return false;
        }
        if (this.cache.reachingInstrs == null) {
            this.cache.reachingInstrs = this.cache.context.calculateReachable(fw, this.cache.node);
        }
        return this.cache.reachingInstrs.contains(instr.iIndex());
    }

    public Val getReceiverUseOrDef(SSAInstruction instr, Set<IntPair> visited) {
        IR ir = this.node().getIR();
        return this.getReceiverUseOrDef(ir.getBasicBlockForInstruction(instr), instr.iIndex(), instr.getUse(0), visited);
    }

    public Val getReceiverUseOrDef(ISSABasicBlock bb, int index, int number, Set<IntPair> visited) {
        int i;
        IR ir = this.node().getIR();
        int n = i = bb.getFirstInstructionIndex() <= index && index <= bb.getLastInstructionIndex() ? index - 1 : bb.getLastInstructionIndex();
        while (i >= bb.getFirstInstructionIndex()) {
            SSAInstruction s = ir.getInstructions()[i];
            if (s != null) {
                SSAAbstractInvokeInstruction invoke;
                if (s.hasDef() && s.getDef() == number) {
                    if (s instanceof SSAAbstractInvokeInstruction && this.callLog() != null) {
                        invoke = (SSAAbstractInvokeInstruction)ir.getInstructions()[i];
                        if (this.callLog().containsKey(invoke.getCallSite())) {
                            Trace calleeTrace = this.callLog().get(invoke.getCallSite());
                            SSAInstruction[] instrs = calleeTrace.node().getIR().getInstructions();
                            for (int j = instrs.length - 1; j >= 0; --j) {
                                if (instrs[j] == null || !(instrs[j] instanceof SSAReturnInstruction)) continue;
                                Trace trace = calleeTrace;
                                trace.getClass();
                                return trace.new Val(instrs[j]);
                            }
                        }
                    }
                    return new Val(s);
                }
                if (s instanceof SSAAbstractInvokeInstruction && !(invoke = (SSAAbstractInvokeInstruction)ir.getInstructions()[i]).isStatic() && invoke.getUse(0) == number) {
                    return new Val(s);
                }
            }
            --i;
        }
        for (SSAPhiInstruction phi : () -> bb.iteratePhis()) {
            if (phi.getDef() != number) continue;
            return new Val(phi);
        }
        Collection preds = ir.getControlFlowGraph().getNormalPredecessors(bb);
        for (ISSABasicBlock pred : preds) {
            Val v0;
            if (pred.getFirstInstructionIndex() > index) continue;
            if (preds.size() > 1) {
                int bbid = pred.getNumber();
                IntPair key = IntPair.make((int)this.node().getGraphNodeId(), (int)bbid);
                if (visited.contains(key)) continue;
                visited.add(key);
            }
            if ((v0 = this.getReceiverUseOrDef(pred, index, number, visited)) == null) continue;
            return v0;
        }
        return null;
    }

    public int hashCode() {
        int hash = System.identityHashCode(this.cache);
        if (this.site() != null) {
            hash ^= this.site().hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Trace)) {
            return false;
        }
        Trace other = (Trace)o;
        if (other.cache != this.cache) {
            return false;
        }
        if (this.site == null) {
            return other.site == null;
        }
        return this.site.equals((Object)other.site);
    }

    public class ParamVal
    extends Val {
        public ParamVal(Object content) {
            super(content);
        }

        @Override
        public int param() {
            return (Integer)this.content;
        }
    }

    public class Val {
        final Object content;

        public Val(Object content) {
            this.content = content;
        }

        public boolean isConstant() {
            return !(this.content instanceof SSAInstruction) && !(this instanceof ParamVal);
        }

        public Object constant() {
            return this.content;
        }

        public SSAInstruction instr() {
            return (SSAInstruction)this.content;
        }

        public String toString() {
            return "" + this.content;
        }

        public Trace trace() {
            return Trace.this;
        }

        public Val getDef(int number) {
            return Trace.this.getDef(number);
        }

        public boolean isParam() {
            return this instanceof ParamVal;
        }

        public boolean isInstr() {
            return !this.isConstant() && !this.isParam();
        }

        public int param() {
            return -1;
        }

        public Val getDefOrParam(int number) {
            return Trace.this.getDefOrParam(number);
        }

        public Val getReceiverUseOrDef(Set<IntPair> visited) {
            if (this.isInstr()) {
                return Trace.this.getReceiverUseOrDef(this.instr(), visited);
            }
            return null;
        }

        public int getBbId() {
            if (this.content == null) {
                return -1;
            }
            if (!(this.content instanceof SSAInstruction)) {
                return -1;
            }
            return Trace.this.node().getIR().getBasicBlockForInstruction((SSAInstruction)this.content).getNumber();
        }
    }

    public static class Cache {
        final CGNode node;
        Context context;
        BitVector reachingInstrs;
        Object[] ud;
        Map<CallSiteReference, Trace> callLog;

        public Cache(CGNode node) {
            this.node = node;
        }
    }

    @FunctionalInterface
    public static interface InstructionVisitor
    extends Visitor {
        @Override
        default public void visitNode(Trace trace) {
        }

        @Override
        default public void visitCallSite(Trace trace) {
        }
    }

    @FunctionalInterface
    public static interface NodeVisitor
    extends Visitor {
        @Override
        default public void visitCallSite(Trace trace) {
        }

        @Override
        default public void visitInstruction(Trace trace, SSAInstruction instr) {
        }
    }

    @FunctionalInterface
    public static interface CallSiteVisitor
    extends Visitor {
        @Override
        default public void visitNode(Trace trace) {
        }

        @Override
        default public void visitInstruction(Trace trace, SSAInstruction instr) {
        }
    }

    public static interface Visitor {
        public void visitCallSite(Trace var1);

        public void visitNode(Trace var1);

        public void visitInstruction(Trace var1, SSAInstruction var2);

        default public void visitExit(Trace trace) {
        }

        default public Visitor with(final Visitor other) {
            final Visitor self = this;
            return new Visitor(){

                @Override
                public void visitCallSite(Trace trace) {
                    self.visitCallSite(trace);
                    other.visitCallSite(trace);
                }

                @Override
                public void visitNode(Trace trace) {
                    self.visitNode(trace);
                    other.visitNode(trace);
                }

                @Override
                public void visitExit(Trace trace) {
                    self.visitExit(trace);
                    other.visitExit(trace);
                }

                @Override
                public void visitInstruction(Trace trace, SSAInstruction instr) {
                    self.visitInstruction(trace, instr);
                    other.visitInstruction(trace, instr);
                }
            };
        }
    }
}

