/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.diva.analysis;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.strings.StringStuff;
import io.tackle.diva.Report;
import io.tackle.diva.Trace;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.diva.analysis.DivaLauncher;
import org.jboss.windup.rules.apps.diva.model.DivaConstraintModel;
import org.jboss.windup.rules.apps.diva.model.DivaContextModel;
import org.jboss.windup.rules.apps.diva.model.DivaOpModel;
import org.jboss.windup.rules.apps.diva.model.DivaRequestParamModel;
import org.jboss.windup.rules.apps.diva.model.DivaRestCallOpModel;
import org.jboss.windup.rules.apps.diva.model.DivaSqlOpModel;
import org.jboss.windup.rules.apps.diva.model.DivaStackTraceModel;
import org.jboss.windup.rules.apps.diva.model.DivaTxModel;
import org.jboss.windup.rules.apps.diva.service.DivaStackTraceService;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaMethodModel;
import org.jboss.windup.rules.apps.java.model.LineMappingModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.java.service.JavaMethodService;
import org.jboss.windup.rules.apps.java.service.LineMappingService;

public class DivaToWindup<T extends WindupVertexFrame>
implements Report {
    static final String CONSTRAINTS = "constraints";
    GraphService<T> service = null;
    GraphContext gc;
    Consumer<T> addEdge = null;

    public DivaToWindup(GraphContext context, Class<T> model) {
        this(context, model, null);
    }

    public DivaToWindup(GraphContext context, Class<T> model, Consumer<T> addEdge) {
        this.gc = context;
        this.service = new GraphService(context, model);
        this.addEdge = addEdge;
    }

    public void add(Report.Named.Builder builder) {
        WindupVertexFrame model = this.service.create();
        if (this.addEdge != null) {
            this.addEdge.accept(model);
        }
        builder.build(new Named<WindupVertexFrame>(this.gc, model));
    }

    public void add(T model) {
        if (this.addEdge != null) {
            this.addEdge.accept(model);
        }
    }

    public void add(Report.Builder builder) {
    }

    public void add(String data) {
    }

    public void add(Integer data) {
    }

    public static class Named<T extends WindupVertexFrame>
    implements Report.Named {
        GraphContext gc;
        T model;

        public Named(GraphContext context, T model) {
            this.gc = context;
            this.model = model;
        }

        public void putPrimitive(String key, Object value) {
            if (this.model instanceof DivaTxModel && key.equals("txid")) {
                ((DivaTxModel)this.model).setTxid((Integer)value);
            } else if (this.model instanceof DivaOpModel && key.equals("sql")) {
                DivaSqlOpModel m = (DivaSqlOpModel)GraphService.addTypeToModel((GraphContext)this.gc, this.model, DivaSqlOpModel.class);
                this.model = m;
                m.setSql((String)value);
            } else if (this.model instanceof DivaRestCallOpModel) {
                if (key.equals("http-method")) {
                    ((DivaRestCallOpModel)this.model).setHttpMethod((String)value);
                } else if (key.equals("url-path")) {
                    ((DivaRestCallOpModel)this.model).setUrlPath(DivaLauncher.stripBraces((String)value));
                } else if (!key.equals("client-class")) {
                    DivaRequestParamModel param = (DivaRequestParamModel)new GraphService(this.gc, DivaRequestParamModel.class).create();
                    param.setParamName(key);
                    param.setParamValue(value.toString());
                    ((DivaRestCallOpModel)this.model).addCallParam(param);
                }
            }
        }

        public void put(String key, Report.Named.Builder builder) {
            if (this.model instanceof DivaOpModel && key.equals("rest-call")) {
                DivaRestCallOpModel m = (DivaRestCallOpModel)GraphService.addTypeToModel((GraphContext)this.gc, this.model, DivaRestCallOpModel.class);
                this.model = m;
                builder.build(new Named<DivaRestCallOpModel>(this.gc, m));
            }
        }

        public void put(String key, Report.Builder builder) {
            if (this.model instanceof DivaContextModel && key.equals(DivaToWindup.CONSTRAINTS)) {
                builder.build(new DivaToWindup<DivaConstraintModel>(this.gc, DivaConstraintModel.class, ((DivaContextModel)this.model)::addConstraint));
            } else if (this.model instanceof DivaContextModel && key.equals("transactions")) {
                builder.build(new DivaToWindup<DivaTxModel>(this.gc, DivaTxModel.class, ((DivaContextModel)this.model)::addTransaction));
            } else if (this.model instanceof DivaTxModel && key.equals("transaction")) {
                int[] counter = new int[]{0};
                builder.build(new DivaToWindup<DivaOpModel>(this.gc, DivaOpModel.class, op -> {
                    int n = counter[0];
                    counter[0] = n + 1;
                    op.setOrdinal(n);
                    ((DivaTxModel)this.model).addOp((DivaOpModel)op);
                }));
            }
        }

        public <S> void put(String key, S data, Function<S, Report.Builder> fun) {
            if (this.model instanceof DivaOpModel && key.equals("stacktrace")) {
                DivaStackTraceService service = new DivaStackTraceService(this.gc);
                JavaClassService classService = new JavaClassService(this.gc);
                JavaMethodService methodService = new JavaMethodService(this.gc);
                LineMappingService lineMappingService = new LineMappingService(this.gc);
                DivaStackTraceModel parent = null;
                DivaStackTraceModel current = null;
                for (Trace t : ((Trace)data).reversed()) {
                    IMethod m = t.node().getMethod();
                    IMethod.SourcePosition p = null;
                    try {
                        p = m.getSourcePosition(t.site().getProgramCounter());
                    }
                    catch (InvalidClassFileException | NullPointerException throwable) {
                        // empty catch block
                    }
                    if (p == null) continue;
                    JavaClassModel classModel = classService.create(StringStuff.jvmToBinaryName((String)m.getDeclaringClass().getName().toString()));
                    JavaMethodModel methodModel = methodService.createJavaMethod(classModel, m.getName().toString(), new JavaClassModel[0]);
                    AbstractJavaSourceModel sourceFile = classModel.getOriginalSource();
                    LineMappingModel lineMapping = null;
                    if (sourceFile == null && (sourceFile = classModel.getDecompiledSource()) != null) {
                        lineMapping = sourceFile.getLineMapping();
                    }
                    if (lineMapping != null) {
                        Map mapping = lineMappingService.getMapping(lineMapping);
                        int lineNum = mapping.getOrDefault(p.getFirstLine(), p.getFirstLine());
                        parent = current = service.getOrCreate((FileModel)sourceFile, lineNum, 0, 0, parent, methodModel);
                        continue;
                    }
                    if (sourceFile == null) continue;
                    parent = current = service.getOrCreate((FileModel)sourceFile, p.getFirstLine(), p.getFirstCol(), p.getLastOffset() - p.getFirstOffset(), parent, methodModel);
                }
                ((DivaOpModel)this.model).setStackTrace(current);
                if (((Trace)data).site() != null) {
                    MethodReference mref = ((Trace)data).site().getDeclaredTarget();
                    JavaClassModel classModel = classService.create(StringStuff.jvmToBinaryName((String)mref.getDeclaringClass().getName().toString()));
                    JavaMethodModel methodModel = methodService.createJavaMethod(classModel, mref.getName().toString(), new JavaClassModel[0]);
                    ((DivaOpModel)this.model).setMethod(methodModel);
                }
            } else {
                this.put(key, fun.apply(data));
            }
        }
    }
}

