/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.ferma;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syncleus.ferma.AbstractElementFrame;
import com.syncleus.ferma.ClassInitializer;
import com.syncleus.ferma.DefaultClassInitializer;
import com.syncleus.ferma.TEdge;
import com.syncleus.ferma.Traversable;
import com.syncleus.ferma.VertexFrame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedElement;

public abstract class AbstractVertexFrame
extends AbstractElementFrame
implements VertexFrame {
    @Override
    public Vertex getElement() {
        if (super.getElement() instanceof WrappedElement) {
            return (Vertex)((WrappedElement)super.getElement()).getBaseElement();
        }
        return (Vertex)super.getElement();
    }

    @Override
    public <T> T addFramedEdge(String label, VertexFrame inVertex, ClassInitializer<T> initializer) {
        Edge edge = this.getElement().addEdge(label, inVertex.getElement(), new Object[0]);
        T framedEdge = this.getGraph().frameNewElement((Element)edge, initializer);
        return framedEdge;
    }

    @Override
    public <T> T addFramedEdge(String label, VertexFrame inVertex, Class<T> kind) {
        return this.addFramedEdge(label, inVertex, new DefaultClassInitializer<T>(kind));
    }

    @Override
    public <T> T addFramedEdgeExplicit(String label, VertexFrame inVertex, ClassInitializer<T> initializer) {
        Edge edge = this.getElement().addEdge(label, inVertex.getElement(), new Object[0]);
        T framedEdge = this.getGraph().frameNewElementExplicit((Element)edge, initializer);
        return framedEdge;
    }

    @Override
    public <T> T addFramedEdgeExplicit(String label, VertexFrame inVertex, Class<T> kind) {
        return this.addFramedEdgeExplicit(label, inVertex, new DefaultClassInitializer<T>(kind));
    }

    @Override
    public TEdge addFramedEdge(String label, VertexFrame inVertex) {
        return this.addFramedEdge(label, inVertex, TEdge.DEFAULT_INITIALIZER);
    }

    @Override
    public TEdge addFramedEdgeExplicit(String label, VertexFrame inVertex) {
        return this.addFramedEdgeExplicit(label, inVertex, TEdge.DEFAULT_INITIALIZER);
    }

    @Override
    public void linkOut(VertexFrame vertex, String ... labels) {
        for (String label : labels) {
            this.getElement().addEdge(label, vertex.getElement(), new Object[0]);
        }
    }

    @Override
    public void linkIn(VertexFrame vertex, String ... labels) {
        for (String label : labels) {
            vertex.getElement().addEdge(label, this.getElement(), new Object[0]);
        }
    }

    @Override
    public void linkBoth(VertexFrame vertex, String ... labels) {
        for (String label : labels) {
            vertex.getElement().addEdge(label, this.getElement(), new Object[0]);
            this.getElement().addEdge(label, vertex.getElement(), new Object[0]);
        }
    }

    @Override
    public void unlinkOut(final VertexFrame vertex, String ... labels) {
        GraphTraversal edges = this.getRawTraversal().outE(labels);
        edges.forEachRemaining(new Consumer<Edge>(){

            @Override
            public void accept(Edge edge) {
                if (vertex == null) {
                    edge.remove();
                } else if (edge.inVertex().equals(vertex.getElement())) {
                    edge.remove();
                }
            }
        });
    }

    @Override
    public void unlinkIn(final VertexFrame vertex, String ... labels) {
        GraphTraversal edges = this.getRawTraversal().inE(labels);
        edges.forEachRemaining(new Consumer<Edge>(){

            @Override
            public void accept(Edge edge) {
                if (vertex == null) {
                    edge.remove();
                } else if (edge.outVertex().id().equals(vertex.getElement().id())) {
                    edge.remove();
                }
            }
        });
    }

    @Override
    public void unlinkBoth(VertexFrame vertex, String ... labels) {
        this.unlinkIn(vertex, labels);
        this.unlinkOut(vertex, labels);
    }

    @Override
    public void setLinkOut(VertexFrame vertex, String ... labels) {
        this.unlinkOut(null, labels);
        if (vertex != null) {
            this.linkOut(vertex, labels);
        }
    }

    @Override
    public void setLinkIn(VertexFrame vertex, String ... labels) {
        this.unlinkIn(null, labels);
        if (vertex != null) {
            this.linkIn(vertex, labels);
        }
    }

    @Override
    public void setLinkBoth(VertexFrame vertex, String ... labels) {
        this.unlinkBoth(null, labels);
        if (vertex != null) {
            this.linkBoth(vertex, labels);
        }
    }

    @Override
    public <K> K setLinkOut(ClassInitializer<K> initializer, String ... labels) {
        K vertex = this.getGraph().addFramedVertex(initializer, new Object[0]);
        this.setLinkOut((VertexFrame)vertex, labels);
        return vertex;
    }

    @Override
    public <K> K setLinkOut(Class<K> kind, String ... labels) {
        return this.setLinkOut(new DefaultClassInitializer<K>(kind), labels);
    }

    @Override
    public <K> K setLinkOutExplicit(ClassInitializer<K> initializer, String ... labels) {
        K vertex = this.getGraph().addFramedVertexExplicit(initializer);
        this.setLinkOut((VertexFrame)vertex, labels);
        return vertex;
    }

    @Override
    public <K> K setLinkOutExplicit(Class<K> kind, String ... labels) {
        return this.setLinkOutExplicit(new DefaultClassInitializer<K>(kind), labels);
    }

    @Override
    public <K> K setLinkIn(ClassInitializer<K> initializer, String ... labels) {
        K vertex = this.getGraph().addFramedVertex(initializer, new Object[0]);
        this.setLinkIn((VertexFrame)vertex, labels);
        return vertex;
    }

    @Override
    public <K> K setLinkIn(Class<K> kind, String ... labels) {
        return this.setLinkIn(new DefaultClassInitializer<K>(kind), labels);
    }

    @Override
    public <K> K setLinkInExplicit(ClassInitializer<K> initializer, String ... labels) {
        K vertex = this.getGraph().addFramedVertexExplicit(initializer);
        this.setLinkIn((VertexFrame)vertex, labels);
        return vertex;
    }

    @Override
    public <K> K setLinkInExplicit(Class<K> kind, String ... labels) {
        return this.setLinkInExplicit(new DefaultClassInitializer<K>(kind), labels);
    }

    @Override
    public <K> K setLinkBoth(ClassInitializer<K> initializer, String ... labels) {
        K vertex = this.getGraph().addFramedVertex(initializer, new Object[0]);
        this.setLinkBoth((VertexFrame)vertex, labels);
        return vertex;
    }

    @Override
    public <K> K setLinkBoth(Class<K> kind, String ... labels) {
        return this.setLinkBoth(new DefaultClassInitializer<K>(kind), labels);
    }

    @Override
    public <K> K setLinkBothExplicit(ClassInitializer<K> initializer, String ... labels) {
        K vertex = this.getGraph().addFramedVertexExplicit(initializer);
        this.setLinkBoth((VertexFrame)vertex, labels);
        return vertex;
    }

    @Override
    public <K> K setLinkBothExplicit(Class<K> kind, String ... labels) {
        return this.setLinkBothExplicit(new DefaultClassInitializer<K>(kind), labels);
    }

    private Object getPropertySupportingMultiproperty(String name) {
        Iterator propertyIterator = this.getElement().properties(new String[]{name});
        ArrayList<Object> results = new ArrayList<Object>();
        while (propertyIterator.hasNext()) {
            Property property = (Property)propertyIterator.next();
            if (!property.isPresent()) continue;
            results.add(property.value());
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        return results;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.getId() instanceof Number) {
            json.addProperty("id", this.getId(Number.class));
        }
        if (this.getId() instanceof String) {
            json.addProperty("id", this.getId(String.class));
        }
        json.addProperty("elementClass", "vertex");
        for (String key : this.getPropertyKeys()) {
            Object value = this.getPropertySupportingMultiproperty(key);
            if (value instanceof Number) {
                json.addProperty(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                json.addProperty(key, (Boolean)value);
                continue;
            }
            if (value instanceof Character) {
                json.addProperty(key, (Character)value);
                continue;
            }
            if (value instanceof List) {
                JsonArray jsonArray = new JsonArray();
                ((List)value).forEach(item -> {
                    if (item instanceof Number) {
                        jsonArray.add((Number)item);
                    } else if (item instanceof Boolean) {
                        jsonArray.add((Boolean)item);
                    } else if (item instanceof Character) {
                        jsonArray.add((Character)item);
                    } else {
                        jsonArray.add(item.toString());
                    }
                });
                json.add(key, (JsonElement)jsonArray);
                continue;
            }
            json.addProperty(key, value.toString());
        }
        return json;
    }

    @Override
    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)this.toJson());
    }

    @Override
    public <T> T reframe(Class<T> kind) {
        return this.getGraph().frameElement((Element)this.getElement(), kind);
    }

    @Override
    public <T> T reframeExplicit(Class<T> kind) {
        return this.getGraph().frameElementExplicit((Element)this.getElement(), kind);
    }

    @Override
    public <T extends Traversable<?, ?>> T traverse(Function<GraphTraversal<Vertex, Vertex>, GraphTraversal<?, ?>> traverser) {
        return this.getGraph().traverse((GraphTraversalSource input) -> (GraphTraversal)traverser.apply(input.V(new Object[]{this.getElement().id()})));
    }

    @Override
    public GraphTraversal<? extends Vertex, ? extends Vertex> getRawTraversal() {
        return this.getGraph().getRawTraversal().V(new Object[]{this.getElement().id()});
    }
}

