/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.summaries;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticClass;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeDynamicInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LambdaSummaryClass
extends SyntheticClass {
    private static final int REF_INVOKEVIRTUAL = 5;
    private static final int REF_INVOKESTATIC = 6;
    private static final int REF_INVOKESPECIAL = 7;
    private static final int REF_NEWINVOKESPECIAL = 8;
    private static final int REF_INVOKEINTERFACE = 9;
    private final SSAInvokeDynamicInstruction invoke;
    private final Map<Atom, IField> fields;
    private final Map<Selector, IMethod> methods;

    public static LambdaSummaryClass create(CGNode caller, SSAInvokeDynamicInstruction inst) {
        String bootstrapCls = caller.getMethod().getDeclaringClass().getName().toString().replace("/", "$").substring(1);
        int bootstrapIndex = inst.getBootstrap().getIndexInClassFile();
        TypeReference ref = TypeReference.findOrCreate(ClassLoaderReference.Primordial, "Lwala/lambda$" + bootstrapCls + '$' + bootstrapIndex);
        LambdaSummaryClass cls = new LambdaSummaryClass(ref, caller.getClassHierarchy(), inst);
        caller.getClassHierarchy().addClass(cls);
        return cls;
    }

    private LambdaSummaryClass(TypeReference T, IClassHierarchy cha, SSAInvokeDynamicInstruction invoke) {
        super(T, cha);
        this.invoke = invoke;
        this.fields = this.makeFields();
        this.methods = Collections.singletonMap(this.trampoline().getSelector(), this.makeTrampoline());
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public int getModifiers() throws UnsupportedOperationException {
        return 48;
    }

    @Override
    public IClass getSuperclass() {
        return this.getClassHierarchy().getRootClass();
    }

    @Override
    public Collection<? extends IClass> getDirectInterfaces() {
        return Collections.singleton(this.getClassHierarchy().lookupClass(this.invoke.getDeclaredResultType()));
    }

    @Override
    public Collection<IClass> getAllImplementedInterfaces() {
        IClass iface = this.getClassHierarchy().lookupClass(this.invoke.getDeclaredResultType());
        HashSet result = HashSetFactory.make(iface.getAllImplementedInterfaces());
        result.add(iface);
        return result;
    }

    @Override
    public IMethod getMethod(Selector selector) {
        return this.methods.get(selector);
    }

    @Override
    public IField getField(Atom name) {
        return this.fields.get(name);
    }

    @Override
    public IMethod getClassInitializer() {
        return null;
    }

    public Collection<IMethod> getDeclaredMethods() {
        return this.methods.values();
    }

    @Override
    public Collection<IField> getAllInstanceFields() {
        return this.fields.values();
    }

    @Override
    public Collection<IField> getAllStaticFields() {
        return Collections.emptySet();
    }

    @Override
    public Collection<IField> getAllFields() {
        return this.getAllInstanceFields();
    }

    public Collection<IMethod> getAllMethods() {
        return this.methods.values();
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() {
        return this.fields.values();
    }

    private Map<Atom, IField> makeFields() {
        HashMap result = HashMapFactory.make();
        int i = 0;
        while (i < this.invoke.getNumberOfPositionalParameters()) {
            final int index = i++;
            result.put(LambdaSummaryClass.getCaptureFieldName(index), new IField(){

                @Override
                public IClass getDeclaringClass() {
                    return LambdaSummaryClass.this;
                }

                @Override
                public Atom getName() {
                    return LambdaSummaryClass.getCaptureFieldName(index);
                }

                @Override
                public Collection<Annotation> getAnnotations() {
                    return Collections.emptySet();
                }

                @Override
                public IClassHierarchy getClassHierarchy() {
                    return LambdaSummaryClass.this.getClassHierarchy();
                }

                @Override
                public TypeReference getFieldTypeReference() {
                    return LambdaSummaryClass.this.invoke.getDeclaredTarget().getParameterType(index);
                }

                @Override
                public FieldReference getReference() {
                    return FieldReference.findOrCreate(LambdaSummaryClass.this.getReference(), this.getName(), this.getFieldTypeReference());
                }

                @Override
                public boolean isFinal() {
                    return true;
                }

                @Override
                public boolean isPrivate() {
                    return true;
                }

                @Override
                public boolean isProtected() {
                    return false;
                }

                @Override
                public boolean isPublic() {
                    return false;
                }

                @Override
                public boolean isStatic() {
                    return false;
                }

                @Override
                public boolean isVolatile() {
                    return false;
                }
            });
        }
        return result;
    }

    private MethodReference trampoline() {
        try {
            return MethodReference.findOrCreate(this.getReference(), this.invoke.getDeclaredTarget().getName(), Descriptor.findOrCreateUTF8(this.getLambdaDeclaredSignature()));
        }
        catch (InvalidClassFileException e) {
            throw new RuntimeException(e);
        }
    }

    private String getLambdaCalleeClass() throws InvalidClassFileException {
        int cpIndex = this.invoke.getBootstrap().callArgumentIndex(1);
        return 'L' + this.invoke.getBootstrap().getCP().getCPHandleClass(cpIndex);
    }

    private String getLambdaCalleeName() throws InvalidClassFileException {
        int cpIndex = this.invoke.getBootstrap().callArgumentIndex(1);
        return this.invoke.getBootstrap().getCP().getCPHandleName(cpIndex);
    }

    private String getLambdaCalleeSignature() throws InvalidClassFileException {
        int cpIndex = this.invoke.getBootstrap().callArgumentIndex(1);
        return this.invoke.getBootstrap().getCP().getCPHandleType(cpIndex);
    }

    private String getLambdaDeclaredSignature() throws InvalidClassFileException {
        int cpIndex = this.invoke.getBootstrap().callArgumentIndex(0);
        return this.invoke.getBootstrap().getCP().getCPMethodType(cpIndex);
    }

    private int getLambdaCalleeKind() throws InvalidClassFileException {
        int cpIndex = this.invoke.getBootstrap().callArgumentIndex(1);
        return this.invoke.getBootstrap().getCP().getCPHandleKind(cpIndex);
    }

    private IMethod makeTrampoline() {
        int firstCapturedValNum;
        SSAInstructionFactory insts = this.getClassLoader().getInstructionFactory();
        MethodReference ref = this.trampoline();
        int numFIMethodArgs = ref.getNumberOfParameters();
        int lastFIArgValNum = numFIMethodArgs + 1;
        MethodSummary summary = new MethodSummary(ref);
        int inst = 0;
        int numCapturedValues = this.invoke.getNumberOfPositionalParameters();
        int curValNum = firstCapturedValNum = lastFIArgValNum + 1;
        for (int i = 0; i < numCapturedValues; ++i) {
            summary.addStatement(insts.GetInstruction(inst++, curValNum++, 1, this.getField(LambdaSummaryClass.getCaptureFieldName(i)).getReference()));
        }
        try {
            MethodReference lambdaBodyCallee = MethodReference.findOrCreate(ClassLoaderReference.Application, this.getLambdaCalleeClass(), this.getLambdaCalleeName(), this.getLambdaCalleeSignature());
            int kind = this.getLambdaCalleeKind();
            boolean isNew = kind == 8;
            IInvokeInstruction.Dispatch code = LambdaSummaryClass.getDispatchForMethodHandleKind(kind);
            IMethod resolved = this.getClassHierarchy().resolveMethod(lambdaBodyCallee);
            if (resolved == null) {
                throw new UnresolvedLambdaBodyException("could not resolve " + lambdaBodyCallee);
            }
            int numLambdaCalleeParams = resolved.getNumberOfParameters();
            if (numLambdaCalleeParams != numFIMethodArgs + numCapturedValues + (isNew ? 1 : 0)) {
                throw new RuntimeException("unexpected # of args " + numLambdaCalleeParams + " lastFIArgValNum " + lastFIArgValNum + " numCaptured " + numCapturedValues + " " + lambdaBodyCallee);
            }
            int[] params = new int[numLambdaCalleeParams];
            int newValNum = -1;
            int curParamInd = 0;
            if (isNew) {
                int n = inst++;
                newValNum = curValNum++;
                summary.addStatement(insts.NewInstruction(n, newValNum, NewSiteReference.make(inst, lambdaBodyCallee.getDeclaringClass())));
                params[curParamInd] = newValNum;
                ++curParamInd;
            }
            int i = 0;
            while (i < numCapturedValues) {
                params[curParamInd] = firstCapturedValNum + i;
                ++i;
                ++curParamInd;
            }
            i = 0;
            while (i < numFIMethodArgs) {
                params[curParamInd] = 2 + i;
                ++i;
                ++curParamInd;
            }
            if (lambdaBodyCallee.getReturnType().equals(TypeReference.Void)) {
                summary.addStatement(insts.InvokeInstruction(inst++, params, curValNum++, CallSiteReference.make(inst, lambdaBodyCallee, (IInvokeInstruction.IDispatch)code), null));
                if (isNew) {
                    summary.addStatement(insts.ReturnInstruction(inst++, newValNum, false));
                }
            } else {
                int ret = curValNum++;
                summary.addStatement(insts.InvokeInstruction(inst++, ret, params, curValNum++, CallSiteReference.make(inst, lambdaBodyCallee, (IInvokeInstruction.IDispatch)code), null));
                summary.addStatement(insts.ReturnInstruction(inst++, ret, lambdaBodyCallee.getReturnType().isPrimitiveType()));
            }
        }
        catch (InvalidClassFileException e) {
            throw new RuntimeException(e);
        }
        SummarizedMethod method = new SummarizedMethod(ref, summary, this);
        return method;
    }

    private static IInvokeInstruction.Dispatch getDispatchForMethodHandleKind(int kind) {
        IInvokeInstruction.Dispatch code;
        switch (kind) {
            case 5: {
                code = IInvokeInstruction.Dispatch.VIRTUAL;
                break;
            }
            case 6: {
                code = IInvokeInstruction.Dispatch.STATIC;
                break;
            }
            case 7: 
            case 8: {
                code = IInvokeInstruction.Dispatch.SPECIAL;
                break;
            }
            case 9: {
                code = IInvokeInstruction.Dispatch.INTERFACE;
                break;
            }
            default: {
                throw new Error("unexpected dynamic invoke type " + kind);
            }
        }
        return code;
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() {
        return Collections.emptySet();
    }

    @Override
    public boolean isReferenceType() {
        return true;
    }

    public static Atom getCaptureFieldName(int i) {
        return Atom.findOrCreateUnicodeAtom("c" + i);
    }

    static class UnresolvedLambdaBodyException
    extends RuntimeException {
        private static final long serialVersionUID = -6504849409929928820L;

        public UnresolvedLambdaBodyException(String s) {
            super(s);
        }
    }
}

