/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.util;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.demandpa.util.MemoryAccess;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.shrike.ShrikeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleMemoryAccessMap
implements MemoryAccessMap {
    private static final boolean DEBUG = false;
    private static final boolean ALWAYS_BUILD_IR = true;
    private final Map<IField, Set<MemoryAccess>> readMap = HashMapFactory.make();
    private final Map<IField, Set<MemoryAccess>> writeMap = HashMapFactory.make();
    private final Set<MemoryAccess> arrayReads = HashSetFactory.make();
    private final Set<MemoryAccess> arrayWrites = HashSetFactory.make();
    private final IClassHierarchy cha;
    private final boolean includePrimOps;
    private final HeapModel heapModel;

    public SimpleMemoryAccessMap(CallGraph cg, HeapModel heapModel, boolean includePrimOps) {
        if (cg == null) {
            throw new IllegalArgumentException("null cg");
        }
        this.cha = cg.getClassHierarchy();
        this.heapModel = heapModel;
        this.includePrimOps = includePrimOps;
        this.populate(cg);
    }

    private void populate(CallGraph cg) {
        Iterator iterator = cg.iterator();
        while (iterator.hasNext()) {
            CGNode n = (CGNode)iterator.next();
            this.populate(n);
        }
    }

    private void populate(CGNode n) {
        IR ir = n.getIR();
        if (ir == null) {
            return;
        }
        SSAInstruction[] statements = ir.getInstructions();
        SSAMemoryAccessVisitor v = new SSAMemoryAccessVisitor(n);
        for (int i = 0; i < statements.length; ++i) {
            SSAInstruction s = statements[i];
            if (s == null) continue;
            v.setInstructionIndex(i);
            s.visit(v);
        }
    }

    @Override
    public Collection<MemoryAccess> getFieldReads(PointerKey pk, IField field) {
        Collection result = this.readMap.get(field);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public Collection<MemoryAccess> getFieldWrites(PointerKey pk, IField field) {
        Collection result = this.writeMap.get(field);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public Collection<MemoryAccess> getArrayReads(PointerKey pk) {
        return this.arrayReads;
    }

    @Override
    public Collection<MemoryAccess> getArrayWrites(PointerKey pk) {
        return this.arrayWrites;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        HashSet allFields = HashSetFactory.make();
        allFields.addAll(this.readMap.keySet());
        allFields.addAll(this.writeMap.keySet());
        for (IField f : allFields) {
            Collection<MemoryAccess> writes;
            result.append("FIELD ").append(f).append(":\n");
            Collection<MemoryAccess> reads = this.getFieldReads(null, f);
            if (!reads.isEmpty()) {
                result.append("  reads:\n");
                for (MemoryAccess memoryAccess : reads) {
                    result.append("  ").append(memoryAccess).append('\n');
                }
            }
            if ((writes = this.getFieldWrites(null, f)).isEmpty()) continue;
            result.append("  writes:\n");
            for (MemoryAccess memoryAccess : writes) {
                result.append("  ").append(memoryAccess).append('\n');
            }
        }
        result.append("ARRAY CONTENTS:\n");
        if (!this.arrayReads.isEmpty()) {
            result.append("  reads:\n");
            for (MemoryAccess memoryAccess : this.arrayReads) {
                result.append("  ").append(memoryAccess).append('\n');
            }
        }
        if (!this.arrayWrites.isEmpty()) {
            result.append("  writes:\n");
            for (MemoryAccess memoryAccess : this.arrayWrites) {
                result.append("  ").append(memoryAccess).append('\n');
            }
        }
        return result.toString();
    }

    @Override
    public Collection<MemoryAccess> getStaticFieldReads(IField field) {
        return this.getFieldReads(null, field);
    }

    @Override
    public Collection<MemoryAccess> getStaticFieldWrites(IField field) {
        return this.getFieldWrites(null, field);
    }

    @Override
    public HeapModel getHeapModel() {
        return this.heapModel;
    }

    public void repOk() {
        for (MemoryAccess m : Iterator2Iterable.make((Iterator)new CompoundIterator(this.arrayReads.iterator(), this.arrayWrites.iterator()))) {
            CGNode node = m.getNode();
            IR ir = node.getIR();
            assert (ir != null) : "null IR for " + node + " but we have a memory access";
            SSAInstruction[] instructions = ir.getInstructions();
            int instructionIndex = m.getInstructionIndex();
            assert (instructionIndex >= 0 && instructionIndex < instructions.length) : "instruction index " + instructionIndex + " out of range for " + node + ", which has " + instructions.length + " instructions";
            SSAInstruction s = instructions[m.getInstructionIndex()];
            if (s != null) assert (s instanceof SSAArrayReferenceInstruction || s instanceof SSANewInstruction) : "bad type " + s.getClass() + " for array access instruction";
        }
    }

    private class MemoryAccessVisitor
    extends IInstruction.Visitor {
        int instructionIndex;
        final ClassLoaderReference loader;
        final CGNode node;

        public MemoryAccessVisitor(ClassLoaderReference loader, CGNode node) {
            this.loader = loader;
            this.node = node;
        }

        protected void setInstructionIndex(int instructionIndex) {
            this.instructionIndex = instructionIndex;
        }

        public void visitNew(NewInstruction instruction) {
            TypeReference tr = ShrikeUtil.makeTypeReference(this.loader, instruction.getType());
            if (tr.isArrayType() && tr.getArrayElementType().isArrayType()) {
                SimpleMemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
            }
        }

        public void visitArrayLoad(IArrayLoadInstruction instruction) {
            TypeReference tr;
            if (!SimpleMemoryAccessMap.this.includePrimOps && (tr = ShrikeUtil.makeTypeReference(this.loader, instruction.getType())).isPrimitiveType()) {
                return;
            }
            SimpleMemoryAccessMap.this.arrayReads.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        public void visitArrayStore(IArrayStoreInstruction instruction) {
            TypeReference tr;
            if (!SimpleMemoryAccessMap.this.includePrimOps && (tr = ShrikeUtil.makeTypeReference(this.loader, instruction.getType())).isPrimitiveType()) {
                return;
            }
            SimpleMemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        public void visitGet(IGetInstruction instruction) {
            FieldReference fr = FieldReference.findOrCreate(this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
            if (!SimpleMemoryAccessMap.this.includePrimOps && fr.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = SimpleMemoryAccessMap.this.cha.resolveField(fr);
            if (f == null) {
                return;
            }
            Set s = MapUtil.findOrCreateSet((Map)SimpleMemoryAccessMap.this.readMap, (Object)f);
            MemoryAccess fa = new MemoryAccess(this.instructionIndex, this.node);
            s.add(fa);
        }

        public void visitPut(IPutInstruction instruction) {
            FieldReference fr = FieldReference.findOrCreate(this.loader, instruction.getClassType(), instruction.getFieldName(), instruction.getFieldType());
            if (!SimpleMemoryAccessMap.this.includePrimOps && fr.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = SimpleMemoryAccessMap.this.cha.resolveField(fr);
            if (f == null) {
                return;
            }
            Set s = MapUtil.findOrCreateSet((Map)SimpleMemoryAccessMap.this.writeMap, (Object)f);
            MemoryAccess fa = new MemoryAccess(this.instructionIndex, this.node);
            s.add(fa);
        }
    }

    private class SSAMemoryAccessVisitor
    extends SSAInstruction.Visitor {
        private final CGNode node;
        private int instructionIndex;

        public SSAMemoryAccessVisitor(CGNode n) {
            this.node = n;
        }

        public void setInstructionIndex(int i) {
            this.instructionIndex = i;
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            TypeReference declaredType = instruction.getNewSite().getDeclaredType();
            if (declaredType.isArrayType() && declaredType.getArrayElementType().isArrayType()) {
                SimpleMemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
            }
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            if (!SimpleMemoryAccessMap.this.includePrimOps && instruction.typeIsPrimitive()) {
                return;
            }
            SimpleMemoryAccessMap.this.arrayReads.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            if (!SimpleMemoryAccessMap.this.includePrimOps && instruction.typeIsPrimitive()) {
                return;
            }
            SimpleMemoryAccessMap.this.arrayWrites.add(new MemoryAccess(this.instructionIndex, this.node));
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            if (!SimpleMemoryAccessMap.this.includePrimOps && instruction.getDeclaredFieldType().isPrimitiveType()) {
                return;
            }
            FieldReference fr = instruction.getDeclaredField();
            IField f = SimpleMemoryAccessMap.this.cha.resolveField(fr);
            if (f == null) {
                return;
            }
            Set s = MapUtil.findOrCreateSet((Map)SimpleMemoryAccessMap.this.readMap, (Object)f);
            MemoryAccess fa = new MemoryAccess(this.instructionIndex, this.node);
            s.add(fa);
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            if (!SimpleMemoryAccessMap.this.includePrimOps && instruction.getDeclaredFieldType().isPrimitiveType()) {
                return;
            }
            FieldReference fr = instruction.getDeclaredField();
            IField f = SimpleMemoryAccessMap.this.cha.resolveField(fr);
            if (f == null) {
                return;
            }
            Set s = MapUtil.findOrCreateSet((Map)SimpleMemoryAccessMap.this.writeMap, (Object)f);
            MemoryAccess fa = new MemoryAccess(this.instructionIndex, this.node);
            s.add(fa);
        }
    }
}

