/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class DirectoryTreeModule
implements Module {
    protected final File root;

    DirectoryTreeModule(File root) throws IllegalArgumentException {
        this.root = root;
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        if (!root.exists()) {
            throw new IllegalArgumentException("root does not exist " + root);
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root is not a directory " + root);
        }
    }

    protected abstract FileModule makeFile(File var1);

    protected abstract boolean includeFile(File var1);

    private Set<FileModule> getEntriesRecursive(File dir) {
        HashSet result = HashSetFactory.make();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                FileModule fileModule;
                if (file.isDirectory()) {
                    result.addAll(this.getEntriesRecursive(file));
                    continue;
                }
                if (!this.includeFile(file) || (fileModule = this.makeFile(file)) == null) continue;
                result.add(fileModule);
            }
        } else {
            System.err.println("Warning: failed to retrieve files in " + dir);
        }
        return result;
    }

    public Iterator<FileModule> getEntries() {
        return this.getEntriesRecursive(this.root).iterator();
    }

    public String getPath() {
        return this.root.getAbsolutePath();
    }

    public String toString() {
        return this.getClass().getName() + ':' + this.getPath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectoryTreeModule other = (DirectoryTreeModule)obj;
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }
}

