/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.intra;

import com.ibm.wala.cfg.exc.intra.OperatorUtil;
import com.ibm.wala.cfg.exc.intra.ParameterState;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.fixpoint.AbstractVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ssa.SymbolTable;
import java.util.Collection;

public class NullPointerState
extends AbstractVariable<NullPointerState> {
    private final State[] vars;

    NullPointerState(int maxVarNum, SymbolTable symbolTable, ParameterState parameterState) {
        this(maxVarNum, symbolTable, parameterState, State.UNKNOWN);
    }

    NullPointerState(int maxVarNum, SymbolTable symbolTable, ParameterState parameterState, State defaultState) {
        int i;
        this.vars = new State[maxVarNum + 1];
        for (i = 0; i < this.vars.length; ++i) {
            if (symbolTable.isConstant(i)) {
                if (symbolTable.isNullConstant(i)) {
                    this.vars[i] = State.NULL;
                    continue;
                }
                this.vars[i] = State.NOT_NULL;
                continue;
            }
            this.vars[i] = defaultState;
        }
        if (parameterState != null) {
            for (i = 0; i < parameterState.getStates().size(); ++i) {
                assert (parameterState.getState(i) != null);
                this.vars[i + 1] = parameterState.getState(i);
                assert (this.vars[i + 1] != null);
            }
        }
    }

    static AbstractMeetOperator<NullPointerState> meetOperator() {
        return StateMeet.INSTANCE;
    }

    static UnaryOperator<NullPointerState> phiValueMeetFunction(int varNum, int[] fromVars) {
        return new PhiValueMeet(varNum, fromVars);
    }

    static UnaryOperator<NullPointerState> nullifyFunction(int varNum) {
        return new NullifyFunction(varNum);
    }

    static UnaryOperator<NullPointerState> denullifyFunction(int varNum) {
        return new DenullifyFunction(varNum);
    }

    static UnaryOperator<NullPointerState> identityFunction() {
        return IndentityFunction.INSTANCE;
    }

    static UnaryOperator<NullPointerState> phisFunction(Collection<UnaryOperator<NullPointerState>> phiFunctions) {
        return new OperatorUtil.UnaryOperatorSequence<NullPointerState>(phiFunctions);
    }

    boolean isNeverNull(int varNum) {
        assert (varNum > 0 && varNum < this.vars.length);
        return this.vars[varNum] == State.NOT_NULL;
    }

    boolean isAlwaysNull(int varNum) {
        assert (varNum > 0 && varNum < this.vars.length);
        return this.vars[varNum] == State.NULL;
    }

    public void copyState(NullPointerState v) {
        assert (v.vars.length == this.vars.length);
        System.arraycopy(v.vars, 0, this.vars, 0, v.vars.length);
    }

    boolean meet(int varNum, State rhs) {
        State lhs = this.vars[varNum];
        if (lhs != State.BOTH && rhs != lhs && rhs != State.UNKNOWN) {
            this.vars[varNum] = lhs == State.UNKNOWN ? rhs : State.BOTH;
            return true;
        }
        return false;
    }

    boolean meet(NullPointerState other) {
        assert (other.vars.length == this.vars.length);
        boolean changed = false;
        for (int i = 0; i < this.vars.length; ++i) {
            changed |= this.meet(i, other.vars[i]);
        }
        return changed;
    }

    boolean nullify(int varNum) {
        if (this.vars[varNum] != State.NULL) {
            this.vars[varNum] = State.NULL;
            return true;
        }
        return false;
    }

    boolean denullify(int varNum) {
        if (this.vars[varNum] != State.NOT_NULL) {
            this.vars[varNum] = State.NOT_NULL;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NullPointerState) {
            NullPointerState other = (NullPointerState)((Object)obj);
            assert (this.vars.length == other.vars.length);
            for (int i = 0; i < this.vars.length; ++i) {
                if (this.vars[i] == other.vars[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public State getState(int ssaVarNum) {
        return this.vars[ssaVarNum];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("<");
        block6: for (State var : this.vars) {
            switch (var) {
                case BOTH: {
                    buf.append('*');
                    continue block6;
                }
                case NOT_NULL: {
                    buf.append('1');
                    continue block6;
                }
                case NULL: {
                    buf.append('0');
                    continue block6;
                }
                case UNKNOWN: {
                    buf.append('?');
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        buf.append('>');
        return buf.toString();
    }

    private static class IndentityFunction
    extends UnaryOperator<NullPointerState> {
        private static final IndentityFunction INSTANCE = new IndentityFunction();

        private IndentityFunction() {
        }

        public byte evaluate(NullPointerState lhs, NullPointerState rhs) {
            if (lhs.equals((Object)rhs)) {
                return 0;
            }
            lhs.copyState(rhs);
            return 1;
        }

        public boolean equals(Object o) {
            return o instanceof IndentityFunction;
        }

        public int hashCode() {
            return 8911;
        }

        public String toString() {
            return "Id";
        }
    }

    private static class DenullifyFunction
    extends UnaryOperator<NullPointerState> {
        private final int varNum;

        private DenullifyFunction(int varNum) {
            assert (varNum >= 0);
            this.varNum = varNum;
        }

        public byte evaluate(NullPointerState lhs, NullPointerState rhs) {
            byte state = 0;
            if (!lhs.equals((Object)rhs)) {
                lhs.copyState(rhs);
                state = 1;
            }
            if (lhs.denullify(this.varNum)) {
                state = 1;
            }
            return state;
        }

        public boolean equals(Object o) {
            return o instanceof DenullifyFunction && ((DenullifyFunction)((Object)o)).varNum == this.varNum;
        }

        public int hashCode() {
            return -47000 - this.varNum;
        }

        public String toString() {
            return "Denullify(" + this.varNum + ')';
        }
    }

    private static class NullifyFunction
    extends UnaryOperator<NullPointerState> {
        private final int varNum;

        private NullifyFunction(int varNum) {
            this.varNum = varNum;
        }

        public byte evaluate(NullPointerState lhs, NullPointerState rhs) {
            byte state = 0;
            if (!lhs.equals((Object)rhs)) {
                lhs.copyState(rhs);
                state = 1;
            }
            if (lhs.nullify(this.varNum)) {
                state = 1;
            }
            return state;
        }

        public boolean equals(Object o) {
            return o instanceof NullifyFunction && ((NullifyFunction)((Object)o)).varNum == this.varNum;
        }

        public int hashCode() {
            return 47000 + this.varNum;
        }

        public String toString() {
            return "Nullify(" + this.varNum + ')';
        }
    }

    private static class PhiValueMeet
    extends UnaryOperator<NullPointerState> {
        private final int varNum;
        private final int[] fromVars;

        private PhiValueMeet(int varNum, int[] fromVars) {
            this.varNum = varNum;
            this.fromVars = fromVars;
        }

        public byte evaluate(NullPointerState lhs, NullPointerState rhs) {
            boolean changed = false;
            if (!lhs.equals((Object)rhs)) {
                lhs.copyState(rhs);
                changed = true;
            }
            ((NullPointerState)lhs).vars[this.varNum] = State.UNKNOWN;
            for (int from : this.fromVars) {
                changed |= lhs.meet(this.varNum, rhs.vars[from]);
            }
            return changed ? (byte)1 : 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PhiValueMeet) {
                PhiValueMeet other = (PhiValueMeet)((Object)o);
                if (this.varNum == other.varNum && this.fromVars.length == other.fromVars.length) {
                    for (int i = 0; i < this.fromVars.length; ++i) {
                        if (this.fromVars[i] == other.fromVars[i]) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return 11000 + this.varNum;
        }

        public String toString() {
            StringBuilder str = new StringBuilder("PhiValueMeet(" + this.varNum + ", [");
            for (int i = 0; i < this.fromVars.length; ++i) {
                str.append(this.fromVars[i]);
                str.append(i == this.fromVars.length - 1 ? "" : ",");
            }
            str.append("])");
            return str.toString();
        }
    }

    private static class StateMeet
    extends AbstractMeetOperator<NullPointerState> {
        private static final StateMeet INSTANCE = new StateMeet();

        private StateMeet() {
        }

        public boolean equals(Object o) {
            return o instanceof StateMeet;
        }

        public byte evaluate(NullPointerState lhs, NullPointerState[] rhs) {
            boolean changed = false;
            for (NullPointerState state : rhs) {
                changed |= lhs.meet(state);
            }
            return changed ? (byte)1 : 0;
        }

        public int hashCode() {
            return 4711;
        }

        public String toString() {
            return "NullPointerStateMeet";
        }
    }

    public static enum State {
        UNKNOWN,
        BOTH,
        NULL,
        NOT_NULL;

    }
}

