/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.BitVectorBase;
import com.ibm.wala.util.intset.Bits;
import java.util.Arrays;

public class BitVector
extends BitVectorBase<BitVector> {
    private static final long serialVersionUID = 9087259335807761617L;
    private static final int MAX_BITS = 0x1FFFFFFF;

    public BitVector() {
        this(1);
    }

    public BitVector(int nbits) {
        if (nbits > 0x1FFFFFFF || nbits < 0) {
            throw new IllegalArgumentException("invalid nbits: " + nbits);
        }
        this.bits = new int[BitVector.subscript(nbits) + 1];
    }

    void expand(int newCapacity) {
        this.bits = Arrays.copyOf(this.bits, BitVector.subscript(newCapacity) + 1);
    }

    public BitVector(BitVector s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.bits = new int[s.bits.length];
        this.copyBits(s);
    }

    @Override
    public final void set(int bit) {
        int shiftBits = bit & 0x1F;
        int subscript = BitVector.subscript(bit);
        if (subscript >= this.bits.length) {
            this.expand(bit);
        }
        try {
            int n = subscript;
            this.bits[n] = this.bits[n] | 1 << shiftBits;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void clear(int bit) {
        if (bit < 0) {
            throw new IllegalArgumentException("invalid bit: " + bit);
        }
        int ss = BitVector.subscript(bit);
        if (ss >= this.bits.length) {
            return;
        }
        int shiftBits = bit & 0x1F;
        int n = ss;
        this.bits[n] = this.bits[n] & ~(1 << shiftBits);
    }

    @Override
    public final boolean get(int bit) {
        if (bit < 0) {
            throw new IllegalArgumentException("illegal bit: " + bit);
        }
        int ss = BitVector.subscript(bit);
        if (ss >= this.bits.length) {
            return false;
        }
        int shiftBits = bit & 0x1F;
        return (this.bits[ss] & 1 << shiftBits) != 0;
    }

    public static BitVector not(BitVector s) {
        BitVector b = new BitVector(s);
        b.not();
        return b;
    }

    @Override
    public final void and(BitVector set) {
        int i;
        if (set == null) {
            throw new IllegalArgumentException("null set");
        }
        if (this == set) {
            return;
        }
        int n = Math.min(this.bits.length, set.bits.length);
        for (i = n - 1; i >= 0; --i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & set.bits[i];
        }
        for (i = n; i < this.bits.length; ++i) {
            this.bits[i] = 0;
        }
    }

    public static BitVector and(BitVector b1, BitVector b2) {
        if (b1 == null) {
            throw new IllegalArgumentException("null b1");
        }
        if (b2 == null) {
            throw new IllegalArgumentException("null b2");
        }
        BitVector b = new BitVector(b1);
        b.and(b2);
        return b;
    }

    @Override
    public final void or(BitVector set) {
        if (set == null) {
            throw new IllegalArgumentException("null set");
        }
        if (this == set) {
            return;
        }
        this.ensureCapacity(set);
        int n = Math.min(this.bits.length, set.bits.length);
        for (int i = n - 1; i >= 0; --i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] | set.bits[i];
        }
    }

    private void ensureCapacity(BitVector set) {
        if (set.bits.length > this.bits.length) {
            this.expand(32 * set.bits.length - 1);
        }
    }

    public final int orWithDelta(BitVector set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        int delta = 0;
        this.ensureCapacity(set);
        int[] otherBits = set.bits;
        int n = Math.min(this.bits.length, otherBits.length);
        for (int i = n - 1; i >= 0; --i) {
            int v1 = this.bits[i];
            int v2 = otherBits[i];
            if (v1 == v2) continue;
            delta -= Bits.populationCount(v1);
            int v3 = v1 | v2;
            delta += Bits.populationCount(v3);
            this.bits[i] = v3;
        }
        return delta;
    }

    public static BitVector or(BitVector b1, BitVector b2) {
        if (b1 == null) {
            throw new IllegalArgumentException("null b1");
        }
        if (b2 == null) {
            throw new IllegalArgumentException("null b2");
        }
        BitVector b = new BitVector(b1);
        b.or(b2);
        return b;
    }

    public static BitVector xor(BitVector b1, BitVector b2) {
        if (b1 == null) {
            throw new IllegalArgumentException("null b1");
        }
        if (b2 == null) {
            throw new IllegalArgumentException("null b2");
        }
        BitVector b = new BitVector(b1);
        b.xor(b2);
        return b;
    }

    @Override
    public final void xor(BitVector set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        this.ensureCapacity(set);
        int n = Math.min(this.bits.length, set.bits.length);
        for (int i = n - 1; i >= 0; --i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] ^ set.bits[i];
        }
    }

    @Override
    public final boolean intersectionEmpty(BitVector other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        int n = Math.min(this.bits.length, other.bits.length);
        for (int i = n - 1; i >= 0; --i) {
            if ((this.bits[i] & other.bits[i]) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int length() {
        return this.bits.length << 5;
    }

    @Override
    public final boolean sameBits(BitVector B) {
        int i;
        if (B == null) {
            throw new IllegalArgumentException("null B");
        }
        if (this == B) {
            return true;
        }
        int n = Math.min(this.bits.length, B.bits.length);
        if (this.bits.length > B.bits.length) {
            for (i = n; i < this.bits.length; ++i) {
                if (this.bits[i] == 0) continue;
                return false;
            }
        } else if (B.bits.length > this.bits.length) {
            for (i = n; i < B.bits.length; ++i) {
                if (B.bits[i] == 0) continue;
                return false;
            }
        }
        for (i = n - 1; i >= 0; --i) {
            if (this.bits[i] == B.bits[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubset(BitVector other) {
        if (other == null) {
            throw new IllegalArgumentException("null other");
        }
        if (this == other) {
            return true;
        }
        for (int i = 0; i < this.bits.length; ++i) {
            if (!(i >= other.bits.length ? this.bits[i] != 0 : (this.bits[i] & ~other.bits[i]) != 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void andNot(BitVector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("null vector");
        }
        int ai = 0;
        int bi = 0;
        ai = 0;
        for (bi = 0; ai < this.bits.length && bi < vector.bits.length; ++bi) {
            int n = ai++;
            this.bits[n] = this.bits[n] & ~vector.bits[bi];
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BitVector) {
            if (this == obj) {
                return true;
            }
            BitVector set = (BitVector)obj;
            return this.sameBits(set);
        }
        return false;
    }

    public final void setAll() {
        Arrays.fill(this.bits, -1);
    }

    public final void not() {
        int i = 0;
        while (i < this.bits.length) {
            int n = i++;
            this.bits[n] = ~this.bits[n];
        }
    }

    public static BitVector andNot(BitVector b1, BitVector b2) {
        BitVector b = new BitVector(b1);
        b.andNot(b2);
        return b;
    }
}

