/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import java.io.Serializable;

public class SlowSparseNumberedGraph<T>
extends AbstractNumberedGraph<T>
implements Serializable {
    private static final long serialVersionUID = 7014361126159594838L;
    private final SlowNumberedNodeManager<T> nodeManager = new SlowNumberedNodeManager();
    private final SparseNumberedEdgeManager<T> edgeManager;

    protected SlowSparseNumberedGraph() {
        this(0);
    }

    public SlowSparseNumberedGraph(int normalOutCount) {
        this.edgeManager = new SparseNumberedEdgeManager<T>(this.nodeManager, normalOutCount, 1);
    }

    @Override
    public NumberedNodeManager<T> getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public NumberedEdgeManager<T> getEdgeManager() {
        return this.edgeManager;
    }

    public static <T> SlowSparseNumberedGraph<T> duplicate(Graph<T> g) {
        SlowSparseNumberedGraph<T> result = SlowSparseNumberedGraph.make();
        SlowSparseNumberedGraph.copyInto(g, result);
        return result;
    }

    public static <T> void copyInto(Graph<T> g, Graph<T> into) {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        for (Object name : g) {
            into.addNode(name);
        }
        for (Object n : g) {
            for (Object succ : Iterator2Iterable.make(g.getSuccNodes(n))) {
                into.addEdge(n, succ);
            }
        }
    }

    public static <T> SlowSparseNumberedGraph<T> make() {
        return new SlowSparseNumberedGraph<T>();
    }
}

