/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.ConfigurationOption;
import org.jboss.windup.config.RuleProvider;
import org.jboss.windup.config.furnace.FurnaceHolder;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.NullWindupProgressMonitor;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.util.PathUtil;

public class WindupConfiguration {
    private static final String DEFAULT_USER_RULES_DIRECTORIES_OPTION = "defaultUserRulesDirectories";
    private static final String DEFAULT_USER_LABELS_DIRECTORIES_OPTION = "defaultUserLabelsDirectories";
    private static final String DEFAULT_USER_IGNORE_DIRECTORIES_OPTION = "defaultUserIgnorePaths";
    public static final boolean DEFAULT_ONLINE = false;
    private Predicate<RuleProvider> ruleProviderFilter;
    private WindupProgressMonitor progressMonitor = new NullWindupProgressMonitor();
    private final Map<String, Object> configurationOptions = new HashMap<String, Object>();
    private boolean alwaysHaltOnException;
    private GraphContext context;

    public void useDefaultDirectories() throws IOException {
        Path windupHomeIgnoreDir;
        Path windupHomeLabelsDir;
        Path windupHomeRulesDir;
        Path userIgnoreDir;
        Path userLabelsDir;
        Path userRulesDir = PathUtil.getUserRulesDir();
        if (userRulesDir != null && !Files.isDirectory(userRulesDir, new LinkOption[0])) {
            Files.createDirectories(userRulesDir, new FileAttribute[0]);
        }
        if (userRulesDir != null) {
            this.addDefaultUserRulesDirectory(userRulesDir);
            this.addDefaultUserLabelsDirectory(userRulesDir);
        }
        if ((userLabelsDir = PathUtil.getUserLabelsDir()) != null && !Files.isDirectory(userLabelsDir, new LinkOption[0])) {
            Files.createDirectories(userLabelsDir, new FileAttribute[0]);
        }
        if (userLabelsDir != null) {
            this.addDefaultUserLabelsDirectory(userLabelsDir);
        }
        if ((userIgnoreDir = PathUtil.getUserIgnoreDir()) != null && !Files.isDirectory(userIgnoreDir, new LinkOption[0])) {
            Files.createDirectories(userIgnoreDir, new FileAttribute[0]);
        }
        if (userIgnoreDir != null) {
            this.addDefaultUserIgnorePath(userIgnoreDir);
        }
        if ((windupHomeRulesDir = PathUtil.getWindupRulesDir()) != null && !Files.isDirectory(windupHomeRulesDir, new LinkOption[0])) {
            Files.createDirectories(windupHomeRulesDir, new FileAttribute[0]);
        }
        if (windupHomeRulesDir != null) {
            this.addDefaultUserRulesDirectory(windupHomeRulesDir);
            this.addDefaultUserLabelsDirectory(windupHomeRulesDir);
        }
        if ((windupHomeLabelsDir = PathUtil.getWindupLabelsDir()) != null && !Files.isDirectory(windupHomeLabelsDir, new LinkOption[0])) {
            Files.createDirectories(windupHomeLabelsDir, new FileAttribute[0]);
        }
        if (windupHomeLabelsDir != null) {
            this.addDefaultUserLabelsDirectory(windupHomeLabelsDir);
        }
        if ((windupHomeIgnoreDir = PathUtil.getWindupIgnoreDir()) != null && !Files.isDirectory(windupHomeIgnoreDir, new LinkOption[0])) {
            Files.createDirectories(windupHomeIgnoreDir, new FileAttribute[0]);
        }
        if (windupHomeIgnoreDir != null) {
            this.addDefaultUserIgnorePath(windupHomeIgnoreDir);
        }
    }

    public WindupConfiguration setOptionValue(String name, Object value) {
        this.configurationOptions.put(name, value);
        return this;
    }

    public boolean isAlwaysHaltOnException() {
        return this.alwaysHaltOnException;
    }

    public void setAlwaysHaltOnException(boolean alwaysHaltOnException) {
        this.alwaysHaltOnException = alwaysHaltOnException;
    }

    public <T> T getOptionValue(String name) {
        return (T)this.configurationOptions.get(name);
    }

    public Map<String, Object> getOptionMap() {
        return Collections.unmodifiableMap(this.configurationOptions);
    }

    public static Iterable<ConfigurationOption> getWindupConfigurationOptions() {
        return WindupConfiguration.getWindupConfigurationOptions(FurnaceHolder.getFurnace());
    }

    public static Iterable<ConfigurationOption> getWindupConfigurationOptions(Furnace furnace) {
        ArrayList<ConfigurationOption> results = new ArrayList<ConfigurationOption>();
        for (ConfigurationOption option : furnace.getAddonRegistry(new AddonRepository[0]).getServices(ConfigurationOption.class)) {
            results.add(option);
        }
        Collections.sort(results, (o1, o2) -> {
            if (o1.isRequired()) {
                if (!o2.isRequired()) {
                    return -1;
                }
                return o2.getPriority() - o1.getPriority();
            }
            if (o2.isRequired()) {
                return 1;
            }
            return o2.getPriority() - o1.getPriority();
        });
        return results;
    }

    public WindupConfiguration addInputPath(Path inputPath) {
        LinkedHashSet<Path> inputPaths = (LinkedHashSet<Path>)this.getOptionValue("input");
        if (inputPaths == null) {
            inputPaths = new LinkedHashSet<Path>();
            this.setOptionValue("input", inputPaths);
        }
        inputPaths.add(inputPath);
        return this;
    }

    public Collection<Path> getInputPaths() {
        Collection inputPaths = (Collection)this.getOptionValue("input");
        return inputPaths;
    }

    public WindupConfiguration addInputApplicationName(String name) {
        ArrayList<String> inputApplicationNames = (ArrayList<String>)this.getOptionValue("inputApplicationName");
        if (inputApplicationNames == null) {
            inputApplicationNames = new ArrayList<String>();
            this.setOptionValue("inputApplicationName", inputApplicationNames);
        }
        inputApplicationNames.add(name);
        return this;
    }

    public List<String> getInputApplicationNames() {
        return (List)this.getOptionValue("inputApplicationName");
    }

    public Path getOutputDirectory() {
        File file = (File)this.getOptionValue("output");
        return file == null ? null : file.toPath();
    }

    public WindupConfiguration setOutputDirectory(Path outputDirectory) {
        this.setOptionValue("output", outputDirectory.toFile());
        return this;
    }

    public Iterable<Path> getAllUserRulesDirectories() {
        HashSet<Path> results = new HashSet<Path>();
        results.addAll(this.getDefaultUserRulesDirectories());
        Collection userSpecifiedFiles = (Collection)this.getOptionValue("userRulesDirectory");
        if (userSpecifiedFiles != null && !userSpecifiedFiles.isEmpty()) {
            userSpecifiedFiles.forEach(file -> results.add(file.toPath()));
        }
        return results;
    }

    public Iterable<Path> getAllUserLabelsDirectories() {
        HashSet<Path> results = new HashSet<Path>();
        results.addAll(this.getDefaultUserLabelsDirectories());
        Collection userSpecifiedFiles = (Collection)this.getOptionValue("userLabelsDirectory");
        if (userSpecifiedFiles != null && !userSpecifiedFiles.isEmpty()) {
            userSpecifiedFiles.stream().forEach(file -> results.add(file.toPath()));
        }
        return results;
    }

    public Iterable<Path> getAllIgnoreDirectories() {
        HashSet<Path> results = new HashSet<Path>();
        results.addAll(this.getDefaultUserIgnoreDirectories());
        File userSpecifiedFile = (File)this.getOptionValue("userIgnorePath");
        if (userSpecifiedFile != null) {
            results.add(userSpecifiedFile.toPath());
        }
        return results;
    }

    public List<Path> getDefaultUserRulesDirectories() {
        List paths = (List)this.getOptionValue(DEFAULT_USER_RULES_DIRECTORIES_OPTION);
        if (paths == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(paths);
    }

    public List<Path> getDefaultUserLabelsDirectories() {
        List paths = (List)this.getOptionValue(DEFAULT_USER_LABELS_DIRECTORIES_OPTION);
        if (paths == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(paths);
    }

    public List<Path> getDefaultUserIgnoreDirectories() {
        List paths = (List)this.getOptionValue(DEFAULT_USER_IGNORE_DIRECTORIES_OPTION);
        if (paths == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(paths);
    }

    public WindupConfiguration addDefaultUserRulesDirectory(Path path) {
        Iterable userRulesDirs;
        ArrayList<Path> paths = (ArrayList<Path>)this.getOptionValue(DEFAULT_USER_RULES_DIRECTORIES_OPTION);
        if (paths == null) {
            paths = new ArrayList<Path>();
            this.setOptionValue(DEFAULT_USER_RULES_DIRECTORIES_OPTION, paths);
        }
        if ((userRulesDirs = (Iterable)this.getOptionValue("userRulesDirectory")) != null) {
            for (File userSpecifiedRuleFile : userRulesDirs) {
                if (userSpecifiedRuleFile != null && userSpecifiedRuleFile.toPath().equals(path)) {
                    return this;
                }
                for (Path existingPath : paths) {
                    if (!existingPath.equals(path)) continue;
                    return this;
                }
            }
        }
        paths.add(path);
        return this;
    }

    public WindupConfiguration addDefaultUserLabelsDirectory(Path path) {
        Iterable userLabelsDirs;
        ArrayList<Path> paths = (ArrayList<Path>)this.getOptionValue(DEFAULT_USER_LABELS_DIRECTORIES_OPTION);
        if (paths == null) {
            paths = new ArrayList<Path>();
            this.setOptionValue(DEFAULT_USER_LABELS_DIRECTORIES_OPTION, paths);
        }
        if ((userLabelsDirs = (Iterable)this.getOptionValue("userLabelsDirectory")) != null) {
            for (File userSpecifiedLabelsFile : userLabelsDirs) {
                if (userSpecifiedLabelsFile != null && userSpecifiedLabelsFile.toPath().equals(path)) {
                    return this;
                }
                for (Path existingPath : paths) {
                    if (!existingPath.equals(path)) continue;
                    return this;
                }
            }
        }
        paths.add(path);
        return this;
    }

    public WindupConfiguration addDefaultUserIgnorePath(Path path) {
        File userSpecifiedIgnorePath;
        ArrayList<Path> paths = (ArrayList<Path>)this.getOptionValue(DEFAULT_USER_IGNORE_DIRECTORIES_OPTION);
        if (paths == null) {
            paths = new ArrayList<Path>();
            this.setOptionValue(DEFAULT_USER_IGNORE_DIRECTORIES_OPTION, paths);
        }
        if ((userSpecifiedIgnorePath = (File)this.getOptionValue("userIgnorePath")) != null && userSpecifiedIgnorePath.toPath().equals(path)) {
            return this;
        }
        for (Path existingPath : paths) {
            if (!existingPath.equals(path)) continue;
            return this;
        }
        paths.add(path);
        return this;
    }

    public Predicate<RuleProvider> getRuleProviderFilter() {
        return this.ruleProviderFilter;
    }

    public WindupConfiguration setRuleProviderFilter(Predicate<RuleProvider> ruleProviderFilter) {
        this.ruleProviderFilter = ruleProviderFilter;
        return this;
    }

    public WindupProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public WindupConfiguration setProgressMonitor(WindupProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        return this;
    }

    public WindupConfiguration setGraphContext(GraphContext context) {
        this.context = context;
        return this;
    }

    public GraphContext getGraphContext() {
        return this.context;
    }

    public WindupConfiguration setOnline(boolean online) {
        this.setOptionValue("online", online);
        return this;
    }

    public boolean isOnline() {
        Boolean online = (Boolean)this.getOptionValue("online");
        return online == null ? false : online;
    }

    public WindupConfiguration setExportingCSV(boolean export) {
        this.setOptionValue("exportCSV", export);
        return this;
    }

    public boolean isExportingCSV() {
        Boolean export = (Boolean)this.getOptionValue("exportCSV");
        return export == null ? false : export;
    }

    public boolean isAnalyseKnownLibrariesSet() {
        return (Boolean)Optional.ofNullable(this.getOptionMap().get("analyzeKnownLibraries")).orElse(false);
    }

    public WindupConfiguration setExportingSummary(boolean export) {
        this.setOptionValue("exportSummary", export);
        return this;
    }

    public boolean isExportingSummary() {
        Boolean export = (Boolean)this.getOptionValue("exportSummary");
        return export == null ? false : export;
    }

    public WindupConfiguration setExportingZipReport(boolean export) {
        this.setOptionValue("exportZipReport", export);
        return this;
    }

    public boolean isExportingZipReport() {
        Boolean export = (Boolean)this.getOptionValue("exportZipReport");
        return export != null && export != false;
    }
}

