/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.traversal;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.graph.model.DuplicateProjectModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.traversal.AllTraversalStrategy;
import org.jboss.windup.graph.traversal.ProjectTraversalVisitor;
import org.jboss.windup.graph.traversal.TraversalStrategy;

public class ProjectModelTraversal {
    private final ProjectModelTraversal previous;
    private final ProjectModel current;
    private final TraversalStrategy traversalStrategy;

    public ProjectModelTraversal(ProjectModelTraversal previous, ProjectModel current, TraversalStrategy traversalStrategy) {
        this.previous = previous;
        this.current = current;
        this.traversalStrategy = traversalStrategy == null ? new AllTraversalStrategy() : traversalStrategy;
    }

    public ProjectModelTraversal(ProjectModel current) {
        this(null, current, null);
    }

    public ProjectModelTraversal(ProjectModel current, TraversalStrategy traversalStrategy) {
        this(null, current, traversalStrategy);
    }

    public Set<ProjectModel> getAllProjects(boolean recursive) {
        if (!recursive) {
            return Collections.singleton(this.getCanonicalProject());
        }
        return this.addProjects(new HashSet<ProjectModel>(), this);
    }

    public Set<Vertex> getAllProjectsAsVertices(boolean recursive) {
        LinkedHashSet<Vertex> vertices = new LinkedHashSet<Vertex>();
        for (ProjectModel projectModel : this.getAllProjects(recursive)) {
            vertices.add(projectModel.getElement());
        }
        return vertices;
    }

    private Set<ProjectModel> addProjects(Set<ProjectModel> existingVertices, ProjectModelTraversal traversal) {
        TraversalState nodeTraversalState = traversal.getTraversalState();
        if (nodeTraversalState == TraversalState.ALL) {
            existingVertices.add(traversal.getCanonicalProject());
        }
        if (nodeTraversalState != TraversalState.NONE) {
            for (ProjectModelTraversal child : traversal.getChildren()) {
                this.addProjects(existingVertices, child);
            }
        }
        return existingVertices;
    }

    public void accept(ProjectTraversalVisitor visitor) {
        visitor.visit(this);
        for (ProjectModelTraversal child : this.getChildren()) {
            child.accept(visitor);
        }
    }

    public Iterable<ProjectModelTraversal> getChildren() {
        return this.traversalStrategy.getChildren(this);
    }

    public String getFilePath(FileModel fileModel) {
        FileModel rootFileModel = this.getCurrent().getRootFileModel();
        FileModel canonicalRootFileModel = this.getCanonicalProject().getRootFileModel();
        String base = "";
        if (this.previous != null) {
            base = this.combinePaths(base, this.previous.getFilePath(canonicalRootFileModel));
        }
        if (this.current.getRootFileModel().getParentFile() != null) {
            base = this.combinePaths(base, this.current.getRootFileModel().getParentFile().getPrettyPathWithinProject());
        }
        String rootFilename = rootFileModel.getFileName();
        base = this.combinePaths(base, rootFilename);
        if (this.getCurrent().getRootFileModel().getFilePath().equals(fileModel.getFilePath())) {
            return base;
        }
        String relativePath = fileModel.getPrettyPathWithinProject();
        return this.combinePaths(base, relativePath);
    }

    private String combinePaths(String path1, String path2) {
        if (StringUtils.isNotBlank((CharSequence)path1) && StringUtils.isNotBlank((CharSequence)path2)) {
            return path1 + "/" + path2;
        }
        return path1 + path2;
    }

    public TraversalState getTraversalState() {
        TraversalState calculatedState = this.traversalStrategy.getTraversalState(this);
        return calculatedState == null ? TraversalState.ALL : calculatedState;
    }

    public ProjectModel getCanonicalProject() {
        return this.getCanonicalProject(this.current);
    }

    public ProjectModel getCurrent() {
        return this.current;
    }

    private ProjectModel getCanonicalProject(ProjectModel projectModel) {
        if (projectModel instanceof DuplicateProjectModel) {
            DuplicateProjectModel duplicate = (DuplicateProjectModel)projectModel;
            return this.getCanonicalProject(duplicate.getCanonicalProject());
        }
        return projectModel;
    }

    public String toString() {
        FileModel rootFileModel = null;
        if (this.current != null) {
            try {
                rootFileModel = this.current.getRootFileModel();
            }
            catch (NoSuchElementException e) {
                rootFileModel = null;
            }
        }
        String checksum = rootFileModel == null ? null : StringUtils.substring((String)rootFileModel.getMD5Hash(), (int)0, (int)8);
        String name = rootFileModel == null ? this.current.getName() : rootFileModel.getFileName();
        String projectInfo = this.current == null ? null : checksum + " " + name + " (" + this.current.getProjectType() + ")";
        String strategyInfo = this.traversalStrategy == null ? null : this.traversalStrategy.getClass().getSimpleName();
        return "Trav@" + this.hashCode() + "{cur: " + projectInfo + ", strategy: " + strategyInfo + ", prev: " + this.previous + "}";
    }

    public void reset() {
        this.traversalStrategy.reset();
    }

    public static enum TraversalState {
        ALL,
        CHILDREN_ONLY,
        NONE;

    }
}

