/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.OrganizationModel;
import org.jboss.windup.graph.service.GraphService;

public class OrganizationService
extends GraphService<OrganizationModel> {
    public OrganizationService(GraphContext context) {
        super(context, OrganizationModel.class);
    }

    public OrganizationModel attachOrganization(ArchiveModel archiveModel, String organizationName) {
        OrganizationModel model = (OrganizationModel)this.getUnique((Traversal<?, ?>)this.getQuery().traverse(g -> g.has("OrganizationModel-name", (Object)organizationName)).getRawTraversal());
        if (model != null) {
            return this.attachOrganization(model, archiveModel);
        }
        model = (OrganizationModel)this.create();
        model.setName(organizationName);
        model.addArchiveModel(archiveModel);
        return model;
    }

    public OrganizationModel attachOrganization(OrganizationModel organizationModel, ArchiveModel archiveModel) {
        for (OrganizationModel existingOrganizationModel : archiveModel.getOrganizationModels()) {
            if (!existingOrganizationModel.equals(organizationModel)) continue;
            return organizationModel;
        }
        organizationModel.addArchiveModel(archiveModel);
        return organizationModel;
    }

    public OrganizationModel attachLink(OrganizationModel organizationModel, LinkModel linkModel) {
        for (LinkModel existing : organizationModel.getLinks()) {
            if (!existing.equals(linkModel)) continue;
            return organizationModel;
        }
        organizationModel.addLink(linkModel);
        return organizationModel;
    }
}

