/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.sourcepos;

import com.ibm.wala.sourcepos.Debug;
import com.ibm.wala.sourcepos.InvalidPositionException;
import com.ibm.wala.sourcepos.InvalidRangeException;
import com.ibm.wala.sourcepos.Position;
import com.ibm.wala.sourcepos.PositionsAttribute;
import com.ibm.wala.sourcepos.Range;
import java.io.DataInputStream;
import java.io.IOException;

public final class MethodPositions
extends PositionsAttribute {
    public static final String ATTRIBUTE_NAME = "joana.sourceinfo.MethodPositions";
    private static final String ERR_COLUMN_ZERO = "Error in MethodPositions attribute: Invalid column number in %1$s.";
    private static final String ERR_LINE_ZERO = "Error in MethodPositions attribute: Invalid line number in %1$s.";
    private static final String ERR_RANGE_UNDEFINED = "Error in MethodPositions attribute: %1$s and %2$s are undefined.";
    private static final String ERR_SET_RANGE_UNDEFINED = "Error in MethodPositions attribute: Invalid positions, so %1$s and %2$s are set undefined.";
    private static final String ERR_POSITION_UNDEFINED = "Error in MethodPositions attribute: %1$s is undefined.";
    private static final String ERR_END_BEFORE_START = "Error in MethodPositions attribute: %2$s (%4$s) is before %1$s (%3$s).";
    private static final String ERR_UNKNOWN_REASON = "Error in MethodPositions attribute: unknown reason %1$s.";
    private static final String WARN_INVALID_BLOCK_END = "Warning in MethodPositions attribute: Invalid method block end position.";
    private static final String WARN_PARAMETER_NOT_IN_DECLARATION = "Warning in MethodPositions attribute: Parameter not in the declaration range.";
    private Range declaration;
    private Range parameter;
    private Range block_end;

    public MethodPositions(byte[] data) throws IOException {
        super(data);
    }

    @Override
    protected final void readData(DataInputStream in) throws IOException {
        this.declaration = MethodPositions.readRange(in, "declaration_start", "declaration_end", false);
        this.parameter = MethodPositions.readRange(in, "parameter_start", "parameter_end", true);
        this.block_end = MethodPositions.readRange(in, "block_end_start", "block_end_end", false);
        if (!(this.parameter.isUndefined() || this.declaration.getStartPosition().isBefore(this.parameter.getStartPosition()) && this.parameter.getEndPosition().isBefore(this.declaration.getEndPosition()))) {
            Debug.warn(WARN_PARAMETER_NOT_IN_DECLARATION);
        }
        if (!this.declaration.getEndPosition().isBefore(this.block_end.getStartPosition())) {
            Debug.warn(WARN_INVALID_BLOCK_END);
        }
    }

    private static Range readRange(DataInputStream in, String startVarName, String endVarName, boolean undefinedAllowed) throws IOException {
        boolean valid = true;
        Range range = null;
        Position start = null;
        Position end = null;
        try {
            start = MethodPositions.readPosition(in, startVarName);
        }
        catch (InvalidPositionException e) {
            valid = false;
        }
        try {
            end = MethodPositions.readPosition(in, endVarName);
        }
        catch (InvalidPositionException e) {
            valid = false;
        }
        if (valid) {
            try {
                range = new Range(start, end);
            }
            catch (InvalidRangeException e) {
                InvalidRangeException.Cause thisCause = e.getThisCause();
                switch (thisCause) {
                    case END_BEFORE_START: {
                        Debug.warn(ERR_END_BEFORE_START, startVarName, endVarName, start, end);
                        break;
                    }
                    case START_UNDEFINED: {
                        Debug.warn(ERR_POSITION_UNDEFINED, startVarName);
                        break;
                    }
                    case END_UNDEFINED: {
                        Debug.warn(ERR_POSITION_UNDEFINED, endVarName);
                        break;
                    }
                    default: {
                        Debug.warn(ERR_UNKNOWN_REASON, new Object[]{thisCause});
                    }
                }
            }
        }
        if (range == null) {
            range = new Range();
            Debug.warn(ERR_SET_RANGE_UNDEFINED, startVarName, endVarName);
        }
        if (range.isUndefined() && !undefinedAllowed) {
            Debug.warn(ERR_RANGE_UNDEFINED, startVarName, endVarName);
        }
        return range;
    }

    private static Position readPosition(DataInputStream in, String varName) throws IOException, InvalidPositionException {
        Position pos;
        block6: {
            pos = null;
            try {
                pos = new Position(in.readInt());
            }
            catch (InvalidPositionException e) {
                switch (e.getThisCause()) {
                    case LINE_NUMBER_ZERO: {
                        Debug.warn(ERR_LINE_ZERO, varName);
                        throw e;
                    }
                    case COLUMN_NUMBER_ZERO: {
                        Debug.warn(ERR_COLUMN_ZERO, varName);
                        throw e;
                    }
                }
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return pos;
    }

    public final Range getHeaderInfo() {
        return this.declaration;
    }

    public final Range getMethodInfo() {
        return this.parameter;
    }

    public final Range getFooterInfo() {
        return this.block_end;
    }

    public String toString() {
        return "header: " + this.declaration + " params: " + this.parameter + " footer:" + this.block_end;
    }
}

