/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.xml;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.reporting.category.IssueCategory;
import org.jboss.windup.reporting.category.IssueCategoryRegistry;
import org.jboss.windup.reporting.config.Hint;
import org.jboss.windup.reporting.config.HintText;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.model.IssueDisplayMode;
import org.jboss.windup.reporting.quickfix.Quickfix;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.ocpsoft.rewrite.context.Context;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="hint", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class HintHandler
implements ElementHandler<Hint> {
    private static final Logger LOG = Logger.getLogger(HintHandler.class.getName());

    public Hint processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String issueDisplayModeString;
        String title = JOOX.$((Element)element).attr("title");
        String categoryID = JOOX.$((Element)element).attr("category-id");
        if (StringUtils.isBlank((CharSequence)categoryID)) {
            categoryID = JOOX.$((Element)element).attr("severity");
        }
        String message = JOOX.$((Element)element).attr("message");
        String in = JOOX.$((Element)element).attr("in");
        HashSet<String> tags = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)message)) {
            StringBuilder messageBuilder = new StringBuilder();
            List children = JOOX.$((Element)element).children().get();
            for (Element child : children) {
                if (!child.getNodeName().equals("message")) continue;
                messageBuilder.append((String)handlerManager.processElement(child));
            }
            message = messageBuilder.toString();
            message = HintHandler.trimLeadingAndTrailingSpaces(message);
        }
        if (StringUtils.isBlank((CharSequence)message)) {
            throw new WindupException("Error, 'hint' element must have a non-empty 'message' attribute or element");
        }
        String effortStr = JOOX.$((Element)element).attr("effort");
        HintText hint = !StringUtils.isBlank((CharSequence)title) ? Hint.in((String)in).titled(title).withText(message) : Hint.in((String)in).withText(message);
        if (StringUtils.isNotBlank((CharSequence)categoryID)) {
            IssueCategoryRegistry issueCategoryRegistry = IssueCategoryRegistry.instance((Context)handlerManager.getRuleLoaderContext().getContext());
            IssueCategory issueCategory = issueCategoryRegistry.getByID(categoryID);
            hint.withIssueCategory(issueCategory);
        }
        int effort = 0;
        if (!StringUtils.isBlank((CharSequence)effortStr)) {
            try {
                effort = Integer.parseInt(effortStr);
                hint.withEffort(effort);
            }
            catch (NumberFormatException e) {
                throw new WindupException("Could not parse effort level: " + effortStr + " as an integer!");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(issueDisplayModeString = JOOX.$((Element)element).attr("issue-display-mode")))) {
            IssueDisplayMode issueDisplayMode = IssueDisplayMode.parse((String)issueDisplayModeString);
            if (issueDisplayMode == IssueDisplayMode.DETAIL_ONLY && effort != 0) {
                LOG.warning("WARNING: hint: " + title + " with effort " + effort + " is marked as detail only. This is generally a mistake.");
            }
            hint.withDisplayMode(issueDisplayMode);
        }
        List children = JOOX.$((Element)element).children().get();
        for (Element child : children) {
            switch (child.getNodeName()) {
                case "link": {
                    Link link = (Link)handlerManager.processElement(child);
                    hint.with(link);
                    break;
                }
                case "tag": {
                    tags.add(child.getTextContent());
                    break;
                }
                case "quickfix": {
                    Quickfix quickfix = (Quickfix)handlerManager.processElement(child);
                    hint.withQuickfix(quickfix);
                }
            }
        }
        hint.withTags(tags);
        return (Hint)hint;
    }

    public static String trimLeadingAndTrailingSpaces(String markdown) {
        StringBuilder markdownSB = new StringBuilder();
        StringBuilder currentLine = new StringBuilder();
        String firstLineIndent = null;
        for (int i = 0; i < markdown.length(); ++i) {
            char currentChar = markdown.charAt(i);
            if (currentChar == '\r' || currentChar == '\n') {
                int firstNonWhitespaceIndex;
                String currentLineString = currentLine.toString();
                if (firstLineIndent == null && !StringUtils.isEmpty((CharSequence)currentLineString) && (firstNonWhitespaceIndex = StringUtils.indexOfAnyBut((CharSequence)currentLineString, (CharSequence)" \t")) != -1) {
                    firstLineIndent = currentLineString.substring(0, firstNonWhitespaceIndex);
                }
                if (firstLineIndent != null) {
                    currentLineString = StringUtils.removeStart((String)currentLineString, firstLineIndent);
                }
                markdownSB.append(currentLineString).append(SystemUtils.LINE_SEPARATOR);
                currentLine.setLength(0);
                if (currentChar != '\r' || markdown.length() <= i + 1 || markdown.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            currentLine.append(currentChar);
        }
        markdownSB.append((CharSequence)currentLine);
        return markdownSB.toString();
    }
}

