/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.comparator.ProjectTraversalRootFileComparator;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;

public class SortProjectTraversalsByPathMethod
implements WindupFreeMarkerMethod {
    private static final String NAME = "sortProjectTraversalsByPathAscending";

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes an Iterable<" + ProjectModelTraversal.class.getSimpleName() + "> and returns them, ordered alphabetically.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (Iterable<ProjectModelTraversal>)");
        }
        Iterable projectTraversalIterable = FreeMarkerUtil.freemarkerWrapperToIterable(arguments.get(0));
        ArrayList<ProjectModelTraversal> projectTraversalList = new ArrayList<ProjectModelTraversal>();
        for (ProjectModelTraversal traversal : projectTraversalIterable) {
            projectTraversalList.add(traversal);
        }
        Collections.sort(projectTraversalList, new ProjectTraversalRootFileComparator());
        ExecutionStatistics.get().end(NAME);
        return projectTraversalList;
    }

    public void setContext(GraphRewrite event) {
    }
}

